/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.contentassist.ContentAssistUtils;
import org.jkiss.dbeaver.ui.contentassist.SmartTextContentAdapter;
import org.jkiss.dbeaver.ui.contentassist.StringContentProposalProvider;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageConnectionClient
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.client.connections";
    private static final String[] ALLOWED_VARIABLES = new String[]{"host", "host.tunnel", "port", "server", "database", "user", "url", "connection.type", "datasource", "context.name", "context.id", "workspace", "home", "dbeaver_home", "application.name", "application.version", "application.path", "local.ip"};
    private Button disableClientApplicationNameCheck;
    private Button overrideClientApplicationNameCheck;
    private Text clientApplicationNameText;
    private Button connUseEnvVariables;

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.meta.client.name.disable") || store.contains("database.meta.client.name.override") || store.contains("database.meta.client.name.value") || store.contains("database.connect.processEnvVars");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Composite clientNameGroup = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_database_client_name_group, (int)2, (int)768, (int)0);
        this.disableClientApplicationNameCheck = UIUtils.createCheckbox((Composite)clientNameGroup, (String)CoreMessages.pref_page_database_label_disable_client_application_name, null, (boolean)false, (int)2);
        Label label = UIUtils.createLabel((Composite)clientNameGroup, (String)CoreMessages.pref_page_database_client_name_group_description);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.overrideClientApplicationNameCheck = UIUtils.createCheckbox((Composite)clientNameGroup, (String)CoreMessages.pref_page_database_label_override_client_application_name, null, (boolean)false, (int)2);
        this.overrideClientApplicationNameCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PrefPageConnectionClient.this.updateClientAppEnablement();
            }
        });
        this.clientApplicationNameText = UIUtils.createLabelText((Composite)clientNameGroup, (String)CoreMessages.pref_page_database_label_client_application_name, (String)"");
        ContentAssistUtils.installContentProposal((Control)this.clientApplicationNameText, (IControlContentAdapter)new SmartTextContentAdapter(), (IContentProposalProvider)new StringContentProposalProvider(ALLOWED_VARIABLES));
        UIUtils.setContentProposalToolTip((Control)this.clientApplicationNameText, (String)CoreMessages.pref_page_connections_application_name_text, (String[])ALLOWED_VARIABLES);
        Composite connGroup = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_connection_label_general, (int)2, (int)768, (int)0);
        this.connUseEnvVariables = UIUtils.createCheckbox((Composite)connGroup, (String)CoreMessages.pref_page_connection_label_use_environment, null, (boolean)false, (int)2);
        return composite;
    }

    private void updateClientAppEnablement() {
        this.clientApplicationNameText.setEnabled(this.overrideClientApplicationNameCheck.getSelection());
    }

    protected void loadPreferences(@NotNull DBPPreferenceStore store) {
        if (this.disableClientApplicationNameCheck == null) {
            return;
        }
        try {
            this.disableClientApplicationNameCheck.setSelection(store.getBoolean("database.meta.client.name.disable"));
            this.overrideClientApplicationNameCheck.setSelection(store.getBoolean("database.meta.client.name.override"));
            this.clientApplicationNameText.setText(store.getString("database.meta.client.name.value"));
            this.connUseEnvVariables.setSelection(store.getBoolean("database.connect.processEnvVars"));
            this.updateClientAppEnablement();
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(@NotNull DBPPreferenceStore store) {
        if (this.disableClientApplicationNameCheck == null) {
            return;
        }
        try {
            store.setValue("database.meta.client.name.disable", this.disableClientApplicationNameCheck.getSelection());
            store.setValue("database.meta.client.name.override", this.overrideClientApplicationNameCheck.getSelection());
            store.setValue("database.meta.client.name.value", this.clientApplicationNameText.getText());
            store.setValue("database.connect.processEnvVars", this.connUseEnvVariables.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.meta.client.name.disable");
        store.setToDefault("database.meta.client.name.override");
        store.setToDefault("database.meta.client.name.value");
        store.setToDefault("database.connect.processEnvVars");
    }

    @NotNull
    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = this.getTargetPreferenceStore();
        this.disableClientApplicationNameCheck.setSelection(store.getDefaultBoolean("database.meta.client.name.disable"));
        this.overrideClientApplicationNameCheck.setSelection(store.getDefaultBoolean("database.meta.client.name.override"));
        this.clientApplicationNameText.setText(store.getDefaultString("database.meta.client.name.value"));
        this.connUseEnvVariables.setSelection(store.getDefaultBoolean("database.connect.processEnvVars"));
        this.updateClientAppEnablement();
    }
}

