/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.gis.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.gis.handlers.WKGUtils;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCContentBytes;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCAbstractValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.OutStream;
import org.locationtech.jts.io.OutputStreamOutStream;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;

public class GISGeometryValueHandler
extends JDBCAbstractValueHandler {
    private static final Log log = Log.getLog(GISGeometryValueHandler.class);
    private int defaultSRID;
    private boolean invertCoordinates;
    private boolean leadingSRID;

    public boolean isFlipCoordinates() {
        return this.invertCoordinates;
    }

    public int getDefaultSRID() {
        return this.defaultSRID;
    }

    public void setDefaultSRID(int defaultSRID) {
        this.defaultSRID = defaultSRID;
    }

    public void setInvertCoordinates(boolean invertCoordinates) {
        this.invertCoordinates = invertCoordinates;
    }

    public boolean isLeadingSRID() {
        return this.leadingSRID;
    }

    public void setLeadingSRID(boolean leadingSRID) {
        this.leadingSRID = leadingSRID;
    }

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        return this.getValueFromObject(session, type, this.fetchBytes(resultSet, index), false, this.invertCoordinates);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value instanceof DBGeometry) {
            value = ((DBGeometry)value).getRawValue();
        }
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else if (value instanceof byte[]) {
            this.bindBytes(statement, paramIndex, (byte[])value);
        } else if (value instanceof Geometry) {
            this.bindGeometryParameter(session, statement, paramIndex, (Geometry)value);
        }
    }

    protected void bindGeometryParameter(@NotNull JDBCSession session, @NotNull JDBCPreparedStatement statement, int paramIndex, @NotNull Geometry value) throws SQLException, DBCException {
        this.bindBytes(statement, paramIndex, this.convertGeometryToBinaryFormat((DBCSession)session, value));
    }

    @NotNull
    public Class<?> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return DBGeometry.class;
    }

    @NotNull
    public DBGeometry getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        DBGeometry geometry;
        if (object == null) {
            geometry = new DBGeometry();
        } else if (object instanceof DBGeometry) {
            geometry = copy ? ((DBGeometry)object).copy() : (DBGeometry)object;
        } else if (object instanceof Geometry) {
            geometry = new DBGeometry((Geometry)object);
        } else if (object instanceof byte[] || object instanceof JDBCContentBytes && !DBUtils.isNullValue((Object)object)) {
            byte[] bytes = object instanceof JDBCContentBytes ? ((JDBCContentBytes)object).getRawValue() : (byte[])object;
            if (bytes.length == 0) {
                return new DBGeometry();
            }
            try {
                geometry = new DBGeometry(this.convertGeometryFromBinaryFormat(session, bytes));
            }
            catch (DBCException e) {
                try {
                    geometry = new DBGeometry(new WKTReader().read(new String(bytes)));
                }
                catch (Exception exception) {
                    throw new DBCException("Error parsing geometry value from binary", (Throwable)e);
                }
            }
        } else {
            if (object instanceof String) {
                return WKGUtils.parseWKT((String)object);
            }
            throw new DBCException("Unsupported geometry value: " + String.valueOf(object));
        }
        if (geometry.getSRID() == 0) {
            geometry.setSRID(this.defaultSRID);
        }
        return geometry;
    }

    protected Geometry convertGeometryFromBinaryFormat(DBCSession session, byte[] object) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(object);){
                int srid = 0;
                if (this.leadingSRID) {
                    srid |= is.read();
                    srid |= is.read() << 8;
                    srid |= is.read() << 16;
                    srid |= is.read() << 24;
                }
                Geometry geometry = new WKBReader().read((InStream)new InputStreamInStream((InputStream)is));
                if (this.leadingSRID && srid > 0) {
                    geometry.setSRID(srid);
                }
                return geometry;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new DBCException("Error reading geometry from binary data", (Throwable)e);
        }
    }

    protected byte[] convertGeometryToBinaryFormat(DBCSession session, Geometry geometry) throws DBCException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                int srid = geometry.getSRID();
                if (this.leadingSRID) {
                    os.write((byte)srid);
                    os.write((byte)(srid >> 8));
                    os.write((byte)(srid >> 16));
                    os.write((byte)(srid >> 24));
                }
                WKBWriter writer = new WKBWriter(2, !this.leadingSRID ? 1 : 2, !this.leadingSRID && srid > 0);
                writer.write(geometry, (OutStream)new OutputStreamOutStream((OutputStream)os));
                return os.toByteArray();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new DBCException("Error writing geometry to binary data", (Throwable)e);
        }
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        byte[] bytes;
        if (value instanceof DBGeometry && format == DBDDisplayFormat.NATIVE) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof JDBCContentBytes && !DBUtils.isNullValue((Object)value) && (bytes = ((JDBCContentBytes)value).getRawValue()).length != 0) {
            try {
                Geometry geometry = this.convertGeometryFromBinaryFormat(null, bytes);
                return geometry.toString();
            }
            catch (DBCException dBCException) {
                log.debug((Object)"Error parsing string geometry value from binary");
            }
        }
        return super.getValueDisplayString(column, value, format);
    }

    protected byte[] fetchBytes(@NotNull JDBCResultSet resultSet, int index) throws SQLException {
        return resultSet.getBytes(index);
    }

    protected void bindBytes(@NotNull JDBCPreparedStatement dbStat, int index, @NotNull byte[] bytes) throws SQLException {
        dbStat.setBytes(index, bytes);
    }
}

