/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench.reports;

import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.directory.jxplorer.broker.DataBroker;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.tree.SmartTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import javax.swing.ProgressMonitor;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class JRLDAPDataSource
implements JRDataSource {
    private SmartTree tree;
    private ArrayList<? extends DN> nodes;
    private ArrayList<DXEntry> entries;
    private boolean isSearchResult;
    private int index = -1;
    private DN currentDN;
    private DataBroker broker;
    private String sortAttributeName = null;
    private boolean handlingMultipleValues = false;
    private HashMap<String, ArrayList> multiVals = null;
    private int multiValsSize = 0;
    private int multiValsIndex = 0;
    private static Logger log = Logger.getLogger(JRLDAPDataSource.class.getName());
    private static ProgressMonitor progressMonitor;

    public JRLDAPDataSource(SmartTree sourceTree, DN rootNode) {
        this.tree = sourceTree;
        this.nodes = this.tree.getAllSearchResultNodes(rootNode);
        this.broker = this.tree.getDataSource();
        if (progressMonitor != null) {
            progressMonitor.setProgress(50);
        }
    }

    public JRLDAPDataSource(JNDIDataBroker jndiBroker, DN rootDN, String searchFilter, String sortAttribute) {
        if (searchFilter == null) {
            searchFilter = "(objectClass=*)";
        }
        this.sortAttributeName = sortAttribute;
        this.broker = jndiBroker;
        if (progressMonitor != null) {
            progressMonitor.setProgress(30);
            progressMonitor.setNote("searching directory");
        }
        if (sortAttribute == null) {
            DXNamingEnumeration results = jndiBroker.unthreadedSearch(rootDN, searchFilter, 2, JNDIDataBroker.RETURN_ONLY_DN);
            ArrayList searchResultList = results.getArrayList();
            ArrayList<DN> DNResultList = new ArrayList<DN>(searchResultList.size());
            if (progressMonitor != null) {
                progressMonitor.setNote("sorting " + DNResultList.size() + " results");
            }
            for (SearchResult dn : searchResultList) {
                if (dn == null) continue;
                DNResultList.add(new DN(dn.getName()));
            }
            Collections.sort(DNResultList);
            this.nodes = DNResultList;
        } else {
            DXNamingEnumeration results = jndiBroker.unthreadedSearch(rootDN, searchFilter, 2, new String[]{sortAttribute});
            ArrayList<NamedValue> sortedNodes = new ArrayList<NamedValue>(results.size());
            ArrayList resultList = results.getArrayList();
            if (progressMonitor != null) {
                progressMonitor.setNote("sorting " + resultList.size() + " results");
            }
            for (SearchResult result : resultList) {
                DN dn = new DN(result.getName());
                String value = "";
                try {
                    Attribute sortVals = result.getAttributes().get(sortAttribute);
                    for (int i = 0; i < (sortVals == null ? 0 : sortVals.size()); ++i) {
                        value = sortVals.get(i).toString();
                        sortedNodes.add(new NamedValue(dn, value));
                    }
                }
                catch (Exception e) {
                    log.warning("exception reading attribute '" + sortAttribute + "' for entry " + dn.toString() + " : " + e.getMessage());
                }
            }
            Collections.sort(sortedNodes);
            this.nodes = sortedNodes;
        }
        if (progressMonitor != null) {
            progressMonitor.setNote("filling report");
        }
    }

    public static void setProgressMonitor(ProgressMonitor pbar) {
        progressMonitor = pbar;
    }

    public static ProgressMonitor getProgressMonitor() {
        return progressMonitor;
    }

    public static void setNote(String note) {
        if (progressMonitor != null) {
            progressMonitor.setNote(note);
        }
    }

    public static void setProgress(int i) {
        if (progressMonitor != null) {
            progressMonitor.setProgress(i);
        }
    }

    public boolean next() throws JRException {
        if (this.handlingMultipleValues) {
            ++this.multiValsIndex;
            if (this.multiValsIndex < this.multiValsSize) {
                return true;
            }
            this.handlingMultipleValues = false;
            this.multiValsIndex = 0;
            this.multiValsSize = 0;
            this.multiVals = null;
        }
        ++this.index;
        if (this.index < this.nodes.size()) {
            if (progressMonitor != null) {
                progressMonitor.setProgress(50 + this.index * 25 / this.nodes.size());
            }
            this.currentDN = this.nodes.get(this.index);
            return true;
        }
        return false;
    }

    public Object getFieldValue(JRField field) throws JRException {
        try {
            if (this.currentDN != null) {
                String fieldName = field.getName();
                String lowerCaseFieldName = fieldName.toLowerCase();
                if (lowerCaseFieldName.equals("rdn")) {
                    return this.currentDN.getLowestRDN().toString();
                }
                if (lowerCaseFieldName.equals("rdn.attid")) {
                    return this.currentDN.getLowestRDN().getAttID();
                }
                if (lowerCaseFieldName.equals("rdn.attval")) {
                    return this.currentDN.getLowestRDN().getRawVal();
                }
                if (lowerCaseFieldName.equals("dn")) {
                    return this.currentDN.toString();
                }
                if (lowerCaseFieldName.equals("rdn")) {
                    return this.currentDN.getLowestRDN().toString();
                }
                if (lowerCaseFieldName.equals("parentdn")) {
                    return this.currentDN.getParent().toString();
                }
                if (fieldName.contains(".")) {
                    try {
                        String[] components = fieldName.split("\\.");
                        String dnReferenceString = components[0];
                        String attReference = components[1];
                        DN referencedDN = dnReferenceString.toLowerCase().equals("dn") ? this.currentDN : (dnReferenceString.toLowerCase().equals("parentdn") ? this.currentDN.getParent() : new DN(this.getNextValue(dnReferenceString).toString()));
                        if (attReference.toLowerCase().equals("rdn")) {
                            return referencedDN.getLowestRDN().toString();
                        }
                        if (attReference.toLowerCase().equals("attid")) {
                            return referencedDN.getLowestRDN().getAttID();
                        }
                        if (attReference.toLowerCase().equals("attval")) {
                            return referencedDN.getLowestRDN().getRawVal();
                        }
                        Attribute att = this.lookupAttributeInDirectory(attReference);
                        if (att == null || att.size() == 0) {
                            return this.returnErrorValue(field);
                        }
                        String referencedValue = att.get().toString();
                        return referencedValue;
                    }
                    catch (Exception e) {
                        log.warning("error trying to evaluate indirect field lookup for " + fieldName + " on entry: " + this.currentDN.toString() + "\n error was: " + e.getMessage());
                    }
                }
                Object val = this.formatFieldValue(field, this.getNextValue(fieldName));
                return val;
            }
        }
        catch (NamingException e) {
            log.warning("error reading field: " + field.getName() + " for entry: " + this.currentDN.toString() + ".  Error was: " + e.getMessage());
        }
        return this.returnErrorValue(field);
    }

    public Object getNextValue(String attName) throws NamingException {
        if (this.handlingMultipleValues) {
            if (!this.multiVals.containsKey(attName)) {
                ArrayList valueList = this.getArrayList(attName);
                this.multiVals.put(attName, valueList);
                if (this.multiValsSize < valueList.size()) {
                    this.multiValsSize = valueList.size();
                }
                return valueList.size() > 0 ? valueList.get(0) : null;
            }
            ArrayList valueList = this.multiVals.get(attName);
            return this.multiValsIndex < valueList.size() ? valueList.get(this.multiValsIndex) : null;
        }
        Attribute att = this.lookupAttribute(attName);
        if (att == null || att.size() == 0) {
            return null;
        }
        if (att.size() == 1) {
            return att.get();
        }
        this.handlingMultipleValues = true;
        this.multiVals = new HashMap();
        ArrayList valueList = this.getArrayList(attName);
        this.multiVals.put(attName, valueList);
        this.multiValsSize = valueList.size();
        this.multiValsIndex = 0;
        return valueList.get(0);
    }

    private Attribute lookupAttribute(String attName) {
        if (attName.equals(this.sortAttributeName) && this.currentDN instanceof NamedValue) {
            String sortVal = ((NamedValue)this.currentDN).value;
            return new DXAttribute(this.sortAttributeName, (Object)sortVal);
        }
        return this.lookupAttributeInDirectory(attName);
    }

    private Attribute lookupAttributeInDirectory(String attName) {
        try {
            DXEntry newEntry = this.broker.unthreadedReadEntry(this.currentDN, new String[]{attName});
            DXAttribute att = newEntry.get(attName);
            return att;
        }
        catch (NamingException e) {
            System.err.println("error reading LDAP entry (" + this.currentDN.toString() + "): " + e.getMessage());
            log.warning("error reading LDAP entry (" + this.currentDN.toString() + "): " + e.getMessage());
            return null;
        }
    }

    private ArrayList getArrayList(String attName) throws NamingException {
        ArrayList valueList = new ArrayList();
        Attribute att = this.lookupAttributeInDirectory(attName);
        if (att != null) {
            NamingEnumeration<?> vals = att.getAll();
            while (vals.hasMore()) {
                Object val = vals.next();
                valueList.add(val);
            }
        }
        return valueList;
    }

    private Object returnErrorValue(JRField field) {
        if (field.getValueClassName().equals("java.lang.String")) {
            return "";
        }
        if (field.getValueClassName().equals("java.lang.Integer")) {
            return new Integer(-1);
        }
        return null;
    }

    private Object formatFieldValue(JRField field, Object value) {
        if (field.getValueClassName().equals("java.lang.String")) {
            return value == null ? "" : value.toString();
        }
        if (field.getValueClassName().equals("java.lang.Integer")) {
            try {
                if (value == null) {
                    return new Integer(-1);
                }
                Integer intVal = Integer.valueOf(value.toString());
                if (intVal == null) {
                    return new Integer(-1);
                }
                return intVal;
            }
            catch (NumberFormatException e) {
                return new Integer(-1);
            }
        }
        return value;
    }

    private class NamedValue
    extends DN {
        public String sortkey;
        public String value;

        public NamedValue(DN dn, String value) {
            super(dn);
            this.value = value;
            this.sortkey = value + " : " + dn.toString();
        }

        public int compareTo(Object o) {
            return this.sortkey.compareTo(((NamedValue)((Object)o)).sortkey);
        }
    }
}

