/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.cbutil.CBParse;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.cert.extensions.V3Extension;

public class SubjectKeyIdentifier
implements V3Extension {
    String value = null;
    byte[] keyId;

    public byte[] getKeyId() {
        return this.keyId;
    }

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.OCTET_STRING)) {
            throw new Exception("Wrong ASN.1 type for SubjectKeyIdentifier");
        }
        this.keyId = (byte[])asn1object.getValue();
        this.value = CBParse.bytes2HexSplit(this.keyId, 4);
    }

    public String toString() {
        return this.value;
    }
}

