/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security.cert.extensions;

import com.ca.commons.cbutil.CBParse;
import com.ca.commons.security.asn1.ASN1OID;
import com.ca.commons.security.asn1.ASN1Object;
import com.ca.commons.security.asn1.ASN1Type;
import com.ca.commons.security.asn1.Sequence;
import com.ca.commons.security.cert.extensions.V3Extension;
import java.util.Hashtable;

public class CertificatePolicies
implements V3Extension {
    String value = null;
    static Hashtable qualifierIDName = new Hashtable();

    @Override
    public void init(ASN1Object asn1object) throws Exception {
        if (!asn1object.isASN1Type(ASN1Type.SEQUENCE)) {
            throw new Exception("Wrong ASN.1 type for CertificatePolicies");
        }
        for (int i = 0; i < asn1object.size(); ++i) {
            if (!(asn1object.getComponent(i) instanceof Sequence)) {
                throw new Exception("CertificatePolicies component is not sequence");
            }
            Sequence seq = (Sequence)asn1object.getComponent(i);
            for (int j = 0; j < seq.size(); ++j) {
                ASN1Object nextComp = seq.getComponent(j);
                if (j == 0) {
                    String certPolicyID = nextComp.getValue().toString();
                    if (this.value == null) {
                        this.value = "Certificate Policy ID: " + certPolicyID;
                        continue;
                    }
                    this.value = this.value + "\n" + "Certificate Policy ID: " + certPolicyID;
                    continue;
                }
                if (j != 1) continue;
                this.value = this.value + "\n" + " Qualifier Info: ";
                if (!(nextComp instanceof Sequence)) {
                    throw new Exception("CertificatePolicies component.policyQualifierInfo is not sequence");
                }
                String qualifierID = (nextComp = nextComp.getComponent(0)).getComponent(0).getValue().toString();
                if (qualifierIDName.get(qualifierID) != null) {
                    qualifierID = (String)qualifierIDName.get(qualifierID);
                }
                this.value = this.value + "\n" + "  Qualifier ID: " + qualifierID;
                ASN1Object qualifier = nextComp.getComponent(1);
                this.value = qualifier.getValue() != null ? this.value + "\n" + "  Qualifier: " + qualifier.getValue() : this.value + "\n" + "  Qualifier: " + CBParse.bytes2HexSplit(qualifier.getByteArray(), 4, 36);
            }
        }
    }

    public String toString() {
        return this.value;
    }

    static {
        qualifierIDName.put(ASN1OID.cpsOID, "CPS");
    }
}

