/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.security;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.Theme;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class KeystorePrompt
extends CBDialog
implements ActionListener {
    private JButton browseButton;
    private JLabel keystorePathLabel;
    private JLabel keystorePasswordLabel;
    private JPanel rootPanel;
    private JPasswordField passwordField;
    private JTextField keystorePathField;
    private String keystorePath = null;
    private String keystorePassword = null;

    public KeystorePrompt(JFrame frame) {
        super((Frame)frame, CBIntText.get("Please select keystore file"), null);
        try {
            frame.setIconImage(new ImageIcon(this.getClass().getResource(Theme.getInstance().getDirImages() + "logo_16.gif")).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.setResizable(true);
        this.setSize(300, 160);
        this.setVisible(true);
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.keystorePathLabel = new JLabel(CBIntText.get("Keystore File") + ":");
        this.keystorePathField = new JTextField();
        this.keystorePasswordLabel = new JLabel(CBIntText.get("Password") + ":");
        this.passwordField = new JPasswordField();
        this.browseButton = new JButton();
        this.setDefaultCloseOperation(0);
        this.browseButton.setText(CBIntText.get("Browse"));
        this.browseButton.addActionListener(this);
        this.OK.addActionListener(this);
        this.Cancel.addActionListener(this);
        this.display.add(this.keystorePasswordLabel);
        this.display.addGreedyWide(this.passwordField, 3);
        this.display.newLine();
        this.display.add(this.keystorePathLabel);
        this.display.addGreedyWide(this.keystorePathField, 2);
        this.display.add(this.browseButton);
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.OK == e.getSource()) {
            this.setVisible(false);
            this.keystorePath = this.keystorePathField.getText();
            this.keystorePassword = this.passwordField.getPassword().toString();
        } else if (this.Cancel == e.getSource()) {
            this.setVisible(false);
            System.exit(0);
        } else if (this.browseButton == e.getSource()) {
            JFileChooser fc = new JFileChooser(CBIntText.get("Please select keystore file"));
            fc.setDialogTitle(CBIntText.get("Smart Keytool") + ":" + CBIntText.get("Please select keystore file"));
            int returnVal = fc.showOpenDialog(null);
            if (returnVal == 0) {
                this.keystorePathField.setText(fc.getSelectedFile().getAbsolutePath());
            }
        }
    }
}

