/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBUtility;
import com.ca.commons.jndi.AdvancedOps;
import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.commons.naming.DXEntry;
import com.ca.commons.naming.DXNamingEnumeration;
import com.ca.commons.naming.NameUtility;
import com.ca.commons.naming.RDN;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

public class DXOps
extends AdvancedOps {
    private static final Logger log = Logger.getLogger(DXOps.class.getName());

    public DXOps(LdapContext ctx) throws NamingException {
        super(ctx);
    }

    public DXOps(ConnectionData cData) throws NamingException {
        super(cData);
    }

    public Name preParse(Name name) {
        return name;
    }

    public Name postParse(Name name) {
        return this.postParse(name.toString());
    }

    public Name postParse(String name) {
        if (name.charAt(name.length() - 1) == '\\') {
            name = NameUtility.checkEndSpaces(name);
        }
        try {
            CompositeName cn = new CompositeName(name);
            if (cn.size() == 0) {
                return new DN();
            }
            return new DN(cn.get(cn.size() - 1));
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unexpected error: bad name back from jndi ftn in CBOps.postParse(" + name + ")?", e);
            e.printStackTrace();
            return new DN(name);
        }
    }

    public String postParseString(String name) {
        if (name.length() == 0) {
            return name;
        }
        if (name.charAt(name.length() - 1) == '\\') {
            name = NameUtility.checkEndSpaces(name);
        }
        if (name.startsWith("ldap://")) {
            try {
                name = URLDecoder.decode(name, "UTF8");
            }
            catch (UnsupportedEncodingException e) {
                log.severe("unexpected error: couldn't URL decode in CBOps.postParseString(" + name + ")?\n" + e.toString());
                e.printStackTrace();
                return name;
            }
        }
        try {
            CompositeName cn = new CompositeName(name);
            if (cn.size() == 0) {
                return "";
            }
            name = cn.get(cn.size() - 1);
            return name;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "unexpected error: bad name back from jndi ftn in CBOps.postParseString(" + name + ")?", e);
            e.printStackTrace();
            return name;
        }
    }

    public NamingEnumeration postParseNameClassPairs(NamingEnumeration names, Name base) {
        log.finer("parsing with base :" + base.toString());
        DXNamingEnumeration dxe = new DXNamingEnumeration();
        String baseString = null;
        if (base != null && !base.isEmpty()) {
            baseString = base.toString();
        }
        try {
            while (names.hasMore()) {
                NameClassPair ncp = (NameClassPair)names.next();
                String rawName = this.postParseString(ncp.getName()).toString();
                if (ncp.isRelative() && baseString != null) {
                    rawName = rawName.length() != 0 ? rawName + "," + baseString : baseString;
                }
                log.finer("ended up with: '" + rawName + "'");
                ncp.setName(rawName);
                dxe.add(ncp);
            }
        }
        catch (NamingException ex) {
            String msg = CBIntText.get("Search partially failed! - only {0} entries returned.", new Integer[]{new Integer(dxe.size())});
            if (ex instanceof SizeLimitExceededException) {
                msg = msg + "\n" + CBIntText.get("(Consider using paged results; see 'Advanced Options -> Ldap Limits.)");
            }
            CBUtility.error(msg, ex);
        }
        return dxe;
    }

    @Override
    protected NamingEnumeration rawSearchBaseEntry(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchBaseEntry(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    @Override
    protected NamingEnumeration rawSearchOneLevel(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchOneLevel(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    @Override
    protected NamingEnumeration rawSearchSubTree(Name searchbase, String filter, int limit, int timeout, String[] returnAttributes) throws NamingException {
        return this.postParseNameClassPairs(super.rawSearchSubTree(searchbase, filter, limit, timeout, returnAttributes), searchbase);
    }

    public void modifyEntry(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        if (oldEntry != null) {
            oldEntry.removeEmptyAttributes();
        }
        if (newEntry != null) {
            newEntry.removeEmptyAttributes();
        }
        if (oldEntry != null || newEntry != null) {
            if (oldEntry == null || newEntry != null && newEntry.getStatus() == 1) {
                this.addEntryToDirectory(newEntry);
            } else if (newEntry == null) {
                this.deleteTree(oldEntry.getDN());
            } else {
                if (oldEntry.getDN() == null || newEntry.getDN() == null) {
                    throw new NamingException("Internal Error: Entry with null DN passed to JNDIDataBroker unthreadedModify.  Modify Request Cancelled.");
                }
                this.handleAnyNameChange(oldEntry, newEntry);
                this.updateEntry(oldEntry, newEntry);
            }
        }
    }

    private void addEntryToDirectory(DXEntry newEntry) throws NamingException {
        this.addEntry(newEntry);
        newEntry.setStatus(2);
    }

    public void addEntry(DXEntry newEntry) throws NamingException {
        if (newEntry == null) {
            throw new NamingException("Internal Error: null Entry passed to DXOps addEntry");
        }
        if (newEntry.getDN() == null) {
            throw new NamingException("Internal Error: Entry with null DN passed to DXOps addEntry");
        }
        this.addEntry(newEntry.getDN(), (Attributes)newEntry);
    }

    public void handleAnyNameChange(DXEntry oldEntry, DXEntry newEntry) throws NamingException {
        DN newDN;
        RDN oldRDN = oldEntry.getRDN();
        DN oldDN = oldEntry.getDN();
        if (oldDN.equals(newDN = newEntry.getDN())) {
            return;
        }
        if (this.exists(newDN)) {
            throw new NamingException(CBIntText.get("The name: ''{0}'' already exists - please choose a different name", new String[]{newDN.getLowestRDN().toString()}));
        }
        boolean replaceRDN = this.doWeReplaceTheRDN(oldEntry, newEntry);
        this.moveTree(oldDN, newDN, replaceRDN);
        for (int i = 0; i < oldRDN.size(); ++i) {
            String type = oldRDN.getAttID(i);
            String value = oldRDN.getRawVal(i);
            DXAttribute oldNamingAttInNewEntry = newEntry.get(type);
            if (oldNamingAttInNewEntry == null || oldNamingAttInNewEntry.contains(value)) continue;
            oldEntry.get(type).remove(value);
        }
    }

    protected boolean doWeReplaceTheRDN(DXEntry oldEntry, DXEntry newEntry) {
        RDN oldRdn = oldEntry.getRDN();
        RDN newRdn = newEntry.getRDN();
        if (oldRdn.size() > 1 || newRdn.size() > 1) {
            return false;
        }
        if (oldRdn.equals(newRdn)) {
            return false;
        }
        if (oldRdn.getAttID().equals(newRdn.getAttID())) {
            DXAttribute oldNamingAtt = new DXAttribute(oldRdn.getAttID());
            if (oldNamingAtt.isSingleValued()) {
                return true;
            }
            if (newEntry.size() > 0) {
                DXAttribute newNamingAtt = newEntry.get(oldRdn.getAttID());
                return newNamingAtt == null || !newNamingAtt.contains(oldRdn.getRawVal(0));
            }
        }
        return false;
    }

    public void updateEntry(DXEntry oldSet, DXEntry newSet) throws NamingException {
        if (DXAttributes.attributesEqual(oldSet, newSet)) {
            return;
        }
        DN nodeDN = newSet.getDN();
        RDN newRDN = nodeDN.getLowestRDN();
        DXAttributes reps = null;
        DXAttributes dels = null;
        DXAttributes adds = null;
        reps = DXAttributes.getReplacementSet(newRDN, oldSet, newSet);
        dels = DXAttributes.getDeletionSet(newRDN, oldSet, newSet);
        adds = DXAttributes.getAdditionSet(newRDN, oldSet, newSet);
        log.fine("updateNode: " + nodeDN);
        ModificationItem[] mods = new ModificationItem[dels.size() + reps.size() + adds.size()];
        int modIndex = 0;
        modIndex = this.loadMods(mods, dels.getAll(), 3, modIndex);
        modIndex = this.loadMods(mods, adds.getAll(), 1, modIndex);
        modIndex = this.loadMods(mods, reps.getAll(), 2, modIndex);
        this.modifyAttributes(nodeDN, mods);
    }

    private int loadMods(ModificationItem[] mods, NamingEnumeration atts, int TYPE, int index) throws NamingException {
        while (atts.hasMore()) {
            Attribute temp = (Attribute)atts.next();
            mods[index++] = new ModificationItem(TYPE, temp);
        }
        return index;
    }

    private void printDebug(DXEntry oldSet, DXEntry newSet, DXAttributes adds, DXAttributes reps, DXAttributes dels) {
        System.out.println("\n*** entries are ***\n\nold:\n" + oldSet.toString() + "\n\nnew:\n" + newSet.toString());
        System.out.println("\n-----------------\nreps:\n" + reps.toString());
        System.out.println("\n-----------------\ndels:\n" + dels.toString());
        System.out.println("\n-----------------\nadds:\n" + adds.toString());
    }
}

