/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules.resolver;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSImportResolveContext;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.resolver.JSDefaultFileReferenceRootsProvider;
import com.intellij.lang.javascript.modules.JSFileResolveRootsProvider;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0013\u0010 \u001a\u00020\n2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020$H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/lang/javascript/frameworks/modules/resolver/JSImportConfigResolveContextImpl;", "Lcom/intellij/lang/javascript/config/JSImportResolveContext;", "config", "Lcom/intellij/lang/javascript/config/JSConfig;", "<init>", "(Lcom/intellij/lang/javascript/config/JSConfig;)V", "myRootDirs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "myPreserveSymlinks", "", "myBaseUrl", "myContainingDirectory", "myPathsMappings", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathMappings;", "Lcom/intellij/lang/javascript/frameworks/modules/JSModulePathSubstitution;", "myMappingRoots", "myRootsProvider", "Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "getMyRootsProvider", "()Lcom/intellij/lang/javascript/modules/JSFileResolveRootsProvider;", "myRootsProvider$delegate", "Lkotlin/Lazy;", "getRootDirs", "preserveSymlinks", "baseUrl", "pathsMappings", "getMappingRoots", "getRootsProvider", "contextDirectory", "getNodeModuleSearchProcessor", "Lcom/intellij/lang/javascript/frameworks/modules/JSDirectorySearchProcessor;", "equals", "other", "", "hashCode", "", "intellij.javascript.backend"})
public class JSImportConfigResolveContextImpl
implements JSImportResolveContext {
    @NotNull
    private final Collection<VirtualFile> myRootDirs;
    private final boolean myPreserveSymlinks;
    @Nullable
    private final VirtualFile myBaseUrl;
    @NotNull
    private final VirtualFile myContainingDirectory;
    @NotNull
    private final JSModulePathMappings<JSModulePathSubstitution> myPathsMappings;
    @NotNull
    private final Collection<VirtualFile> myMappingRoots;
    @NotNull
    private final Lazy myRootsProvider$delegate;

    public JSImportConfigResolveContextImpl(@NotNull JSConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Collection collection = config.getRootDirsFiles();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getRootDirsFiles(...)");
        this.myRootDirs = collection;
        this.myPreserveSymlinks = config.preserveSymlinks();
        this.myBaseUrl = config.getBaseUrl();
        VirtualFile virtualFile = config.getConfigDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getConfigDirectory(...)");
        this.myContainingDirectory = virtualFile;
        JSModulePathMappings jSModulePathMappings = config.getPathMappings();
        Intrinsics.checkNotNullExpressionValue((Object)jSModulePathMappings, (String)"getPathMappings(...)");
        this.myPathsMappings = jSModulePathMappings;
        this.myMappingRoots = CollectionsKt.listOf((Object)config.getMappingRoot());
        this.myRootsProvider$delegate = LazyKt.lazy(() -> JSImportConfigResolveContextImpl.myRootsProvider_delegate$lambda$0(this));
    }

    private final JSFileResolveRootsProvider getMyRootsProvider() {
        Lazy lazy = this.myRootsProvider$delegate;
        return (JSFileResolveRootsProvider)lazy.getValue();
    }

    @NotNull
    public Collection<VirtualFile> getRootDirs() {
        return this.myRootDirs;
    }

    public boolean preserveSymlinks() {
        return this.myPreserveSymlinks;
    }

    @Nullable
    public VirtualFile baseUrl() {
        return this.myBaseUrl;
    }

    @NotNull
    public JSModulePathMappings<JSModulePathSubstitution> pathsMappings() {
        return this.myPathsMappings;
    }

    @NotNull
    public Collection<VirtualFile> getMappingRoots() {
        return this.myMappingRoots;
    }

    @NotNull
    public JSFileResolveRootsProvider getRootsProvider() {
        return this.getMyRootsProvider();
    }

    @NotNull
    public VirtualFile contextDirectory() {
        return this.myContainingDirectory;
    }

    @NotNull
    public JSDirectorySearchProcessor getNodeModuleSearchProcessor() {
        NodeModuleDirectorySearchProcessor nodeModuleDirectorySearchProcessor = NodeModuleDirectorySearchProcessor.PROCESSOR;
        Intrinsics.checkNotNullExpressionValue((Object)nodeModuleDirectorySearchProcessor, (String)"PROCESSOR");
        return nodeModuleDirectorySearchProcessor;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.frameworks.modules.resolver.JSImportConfigResolveContextImpl");
        JSImportConfigResolveContextImpl cfr_ignored_0 = (JSImportConfigResolveContextImpl)object2;
        if (!Intrinsics.areEqual(this.myRootDirs, ((JSImportConfigResolveContextImpl)other).myRootDirs)) {
            return false;
        }
        if (this.myPreserveSymlinks != ((JSImportConfigResolveContextImpl)other).myPreserveSymlinks) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myBaseUrl, (Object)((JSImportConfigResolveContextImpl)other).myBaseUrl)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.myContainingDirectory, (Object)((JSImportConfigResolveContextImpl)other).myContainingDirectory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.myPathsMappings, ((JSImportConfigResolveContextImpl)other).myPathsMappings)) {
            return false;
        }
        return Intrinsics.areEqual(this.myMappingRoots, ((JSImportConfigResolveContextImpl)other).myMappingRoots);
    }

    public int hashCode() {
        int result2 = ((Object)this.myRootDirs).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.myPreserveSymlinks);
        VirtualFile virtualFile = this.myBaseUrl;
        result2 = 31 * result2 + (virtualFile != null ? virtualFile.hashCode() : 0);
        result2 = 31 * result2 + this.myContainingDirectory.hashCode();
        result2 = 31 * result2 + this.myPathsMappings.hashCode();
        result2 = 31 * result2 + ((Object)this.myMappingRoots).hashCode();
        return result2;
    }

    private static final JSDefaultFileReferenceRootsProvider myRootsProvider_delegate$lambda$0(JSImportConfigResolveContextImpl this$0) {
        return new JSDefaultFileReferenceRootsProvider(this$0);
    }
}

