/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class ES6CustomExtensionFileReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    protected ES6CustomExtensionFileReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        String[] extensions;
        PsiElement elementToSearch;
        if (queryParameters == null) {
            ES6CustomExtensionFileReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ES6CustomExtensionFileReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((elementToSearch = queryParameters.getElementToSearch()) instanceof JSFile)) {
            return;
        }
        VirtualFile file = ((JSFile)elementToSearch).getVirtualFile();
        if (file == null) {
            return;
        }
        String name = file.getName();
        String extension = JSFileReferencesUtil.findExtension((CharSequence)name, (String[])(extensions = ES6CustomExtensionFileReferenceSearcher.getExtensionsToSearch(name, elementToSearch)));
        if (extension == null) {
            return;
        }
        String defaultExtension = FileUtilRt.getExtension((String)name);
        if (extension.equals("." + defaultExtension)) {
            return;
        }
        ES6CustomExtensionFileReferenceSearcher.searchShortName(JSFileReferencesUtil.trimExistingExtension((String)name, (String)extension), queryParameters);
    }

    private static String[] getExtensionsToSearch(@NotNull String name, @NotNull PsiElement elementToSearch) {
        TypeScriptConfig configFile;
        if (name == null) {
            ES6CustomExtensionFileReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (elementToSearch == null) {
            ES6CustomExtensionFileReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (TypeScriptUtil.isTypeScriptFile((CharSequence)name) && (configFile = TypeScriptConfigUtil.getConfigForPsiFile((PsiFile)elementToSearch.getContainingFile())) != null) {
            return configFile.getImportResolver().getExtensionsWithDot();
        }
        return JSFileReferencesUtil.IMPLICIT_EXTENSIONS;
    }

    private static void searchShortName(String newName, @NotNull ReferencesSearch.SearchParameters queryParameters) {
        if (queryParameters == null) {
            ES6CustomExtensionFileReferenceSearcher.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)newName)) {
            SearchScope searchScope = queryParameters.getEffectiveSearchScope();
            queryParameters.getOptimizer().searchWord(newName, searchScope, false, queryParameters.getElementToSearch());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/findUsages/ES6CustomExtensionFileReferenceSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtensionsToSearch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "searchShortName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

