/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.propertyform;

import com.intellij.jpa.jpb.model.ui.propertyform.FormValueModel;
import com.intellij.openapi.ui.ValidationInfo;
import com.jgoodies.binding.PresentationModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class FormPresentationModel<B>
extends PresentationModel<B> {
    protected Map<String, FormValueModel> formModels = new LinkedHashMap<String, FormValueModel>();

    public FormPresentationModel(B bean) {
        super(bean);
    }

    public FormValueModel getModel(String propertyName) {
        FormValueModel model2 = this.formModels.get(propertyName);
        if (model2 == null) {
            model2 = this.createFormValueModel(propertyName);
            this.formModels.put(propertyName, model2);
        }
        return model2;
    }

    protected FormValueModel createFormValueModel(String propertyName) {
        return new FormValueModel(super.getModel(propertyName), propertyName);
    }

    public Object getValue(String propertyName) {
        return this.getModel(propertyName).getValue();
    }

    public void setValue(String propertyName, Object newValue) {
        this.getModel(propertyName).setValue(newValue);
    }

    public List<ValidationInfo> validate() {
        return this.formModels.values().stream().flatMap(formModel -> formModel.validate().stream()).collect(Collectors.toList());
    }

    public void initialPropertyChange() {
        ArrayList<FormValueModel> valueModels = new ArrayList<FormValueModel>(this.formModels.values());
        valueModels.forEach(FormValueModel::initialPropertyChange);
    }
}

