/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSAllCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_VALID = 1;
    private XSElementDecl[] fAllElements = new XSElementDecl[10];
    private boolean[] fIsOptionalElement = new boolean[10];
    private boolean fHasOptionalContent = false;
    private int fNumElements = 0;
    private int fNumRequired = 0;

    public XSAllCM(boolean bl) {
        this.fHasOptionalContent = bl;
    }

    public void addElement(XSElementDecl xSElementDecl, boolean bl) {
        if (this.fNumElements >= this.fAllElements.length) {
            XSElementDecl[] xSElementDeclArray = new XSElementDecl[2 * this.fAllElements.length];
            boolean[] blArray = new boolean[2 * this.fIsOptionalElement.length];
            System.arraycopy(this.fAllElements, 0, xSElementDeclArray, 0, this.fAllElements.length);
            System.arraycopy(this.fIsOptionalElement, 0, blArray, 0, this.fIsOptionalElement.length);
            this.fAllElements = xSElementDeclArray;
            this.fIsOptionalElement = blArray;
        }
        this.fAllElements[this.fNumElements] = xSElementDecl;
        this.fIsOptionalElement[this.fNumElements] = bl;
        ++this.fNumElements;
        if (!bl) {
            ++this.fNumRequired;
        }
    }

    public int[] startContentModel() {
        int[] nArray = new int[this.fNumElements + 1];
        int n = 0;
        while (n <= this.fNumElements) {
            nArray[n] = 0;
            ++n;
        }
        return nArray;
    }

    public Object oneTransition(QName qName, int[] nArray, SubstitutionGroupHandler substitutionGroupHandler) {
        XSElementDecl xSElementDecl = null;
        int n = 0;
        while (n < this.fNumElements) {
            xSElementDecl = substitutionGroupHandler.getMatchingElemDecl(qName, this.fAllElements[n]);
            if (xSElementDecl != null) {
                if (nArray[n + 1] == 0) {
                    nArray[n + 1] = 1;
                } else if (nArray[n + 1] == 1) {
                    nArray[n + 1] = -1;
                    nArray[0] = -1;
                } else if (nArray[n + 1] == -1) {
                    nArray[n + 1] = -2;
                    nArray[0] = -2;
                }
                if (nArray[0] == 0) {
                    nArray[0] = 1;
                }
                return xSElementDecl;
            }
            ++n;
        }
        if (nArray[0] == -1) {
            nArray[0] = -2;
        } else if (nArray[0] == 0 || nArray[0] == 1) {
            nArray[0] = -1;
        }
        return null;
    }

    public boolean endContentModel(int[] nArray) {
        int n = nArray[0];
        if (n == -1 || n == -2) {
            return false;
        }
        if (this.fHasOptionalContent && this.fNumElements == 0) {
            return true;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fNumElements) {
            if (!this.fIsOptionalElement[n3] && nArray[n3 + 1] != 0) {
                ++n2;
            }
            ++n3;
        }
        return this.fNumRequired == n2;
    }

    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler substitutionGroupHandler) throws XMLSchemaException {
        int n = 0;
        while (n < this.fNumElements) {
            int n2 = n + 1;
            while (n2 < this.fNumElements) {
                if (XSConstraints.overlapUPA(this.fAllElements[n], this.fAllElements[n2], substitutionGroupHandler)) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fAllElements[n].toString(), this.fAllElements[n2].toString()});
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }
}

