/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.Arrays;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeVariablesGroupKt;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.FunctionValue;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/debugger/FunctionScopesValueGroup;", "Lcom/intellij/xdebugger/frame/XValueGroup;", "functionValue", "Lorg/jetbrains/debugger/values/FunctionValue;", "variableContext", "Lorg/jetbrains/debugger/VariableContext;", "<init>", "(Lorg/jetbrains/debugger/values/FunctionValue;Lorg/jetbrains/debugger/VariableContext;)V", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.javascript.debugger.ui"})
@SourceDebugExtension(value={"SMAP\nFunctionScopesValueGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionScopesValueGroup.kt\norg/jetbrains/debugger/FunctionScopesValueGroup\n+ 2 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,31:1\n110#2,3:32\n23#3:35\n*S KotlinDebug\n*F\n+ 1 FunctionScopesValueGroup.kt\norg/jetbrains/debugger/FunctionScopesValueGroup\n*L\n17#1:32,3\n27#1:35\n*E\n"})
public final class FunctionScopesValueGroup
extends XValueGroup {
    @NotNull
    private final FunctionValue functionValue;
    @NotNull
    private final VariableContext variableContext;

    public FunctionScopesValueGroup(@NotNull FunctionValue functionValue, @NotNull VariableContext variableContext) {
        Intrinsics.checkNotNullParameter((Object)functionValue, (String)"functionValue");
        Intrinsics.checkNotNullParameter((Object)variableContext, (String)"variableContext");
        super("Function scopes");
        this.functionValue = functionValue;
        this.variableContext = variableContext;
    }

    /*
     * WARNING - void declaration
     */
    public void computeChildren(@NotNull XCompositeNode node) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.setAlreadySorted(true);
        Promise promise = this.functionValue.resolve();
        Obsolescent node$iv = (Obsolescent)node;
        boolean $i$f$onSuccess = false;
        Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<FunctionValue>(node$iv, node, this){
            final /* synthetic */ XCompositeNode $node$inlined;
            final /* synthetic */ FunctionScopesValueGroup this$0;
            {
                this.$node$inlined = xCompositeNode;
                this.this$0 = functionScopesValueGroup;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void accept(Object param) {
                FunctionValue it = (FunctionValue)param;
                boolean bl = false;
                Scope[] scopes = it.getScopes();
                Scope[] scopeArray = scopes;
                if (scopeArray == null || scopeArray.length == 0) {
                    this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                } else {
                    scopeArray = scopes;
                    ScopeVariablesGroupKt.createAndAddScopeList(this.$node$inlined, CollectionsKt.listOf((Object[])Arrays.copyOf(scopeArray, scopeArray.length)), FunctionScopesValueGroup.access$getVariableContext$p(this.this$0), null);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
        promise2.onError(arg_0 -> FunctionScopesValueGroup.computeChildren$lambda$2(arg_0 -> FunctionScopesValueGroup.computeChildren$lambda$1(this, node, arg_0), arg_0));
    }

    private static final Unit computeChildren$lambda$1(FunctionScopesValueGroup this$0, XCompositeNode $node, Throwable it) {
        FunctionScopesValueGroup $this$thisLogger$iv = this$0;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(FunctionScopesValueGroup.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Intrinsics.checkNotNull((Object)it);
        Promises.errorIfNotMessage((Logger)logger, (Throwable)it);
        String string = it.getMessage();
        Intrinsics.checkNotNull((Object)string);
        $node.setErrorMessage(string);
        return Unit.INSTANCE;
    }

    private static final void computeChildren$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ VariableContext access$getVariableContext$p(FunctionScopesValueGroup $this) {
        return $this.variableContext;
    }
}

