/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli.component;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.CliContextDescriptor;
import com.intellij.database.cli.CliLexeme;
import com.intellij.database.cli.CliModel;
import com.intellij.database.cli.CliPanelDecorator;
import com.intellij.database.cli.DbCliUtil;
import com.intellij.database.cli.argument.StringCliArgument;
import com.intellij.database.cli.component.ArgumentComponent;
import com.intellij.database.cli.component.CliPathTextFieldWithBrowseButton;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CliPathTextField
extends ArgumentComponent<StringCliArgument> {
    private final CliPathTextFieldWithBrowseButton myField;
    private final CliConfiguration.CliSubstitutor mySubstitutor;

    public CliPathTextField(@NotNull StringCliArgument argument, @Nullable CliConfiguration.CliSubstitutor substitutor, @NotNull CliModel model) {
        if (argument == null) {
            CliPathTextField.$$$reportNull$$$0(0);
        }
        if (model == null) {
            CliPathTextField.$$$reportNull$$$0(1);
        }
        super(argument);
        this.mySubstitutor = substitutor;
        this.myField = new CliPathTextFieldWithBrowseButton(model, target -> target.createPathChooserDescriptor());
        this.myField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                CliPathTextField.this.fireComponentChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/cli/component/CliPathTextField$1", "textChanged"));
            }
        });
    }

    @Override
    public void initialize(@NotNull CliPanelDecorator panelDecorator) {
        if (panelDecorator == null) {
            CliPathTextField.$$$reportNull$$$0(2);
        }
        this.myField.updateFileDescriptor();
        panelDecorator.addRunTargetChangeListener(() -> this.myField.updateFileDescriptor());
    }

    @Override
    public void reset(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliPathTextField.$$$reportNull$$$0(3);
        }
        this.myField.setText("");
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.mySubstitutor == null ? null : this.mySubstitutor.getDocumentation();
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        CliPathTextFieldWithBrowseButton cliPathTextFieldWithBrowseButton = this.myField;
        if (cliPathTextFieldWithBrowseButton == null) {
            CliPathTextField.$$$reportNull$$$0(4);
        }
        return cliPathTextFieldWithBrowseButton;
    }

    @Override
    public void changeState(@NotNull String text, @NotNull CliLexeme current, @NotNull CliLexeme next, @NotNull CliContextDescriptor cd) {
        String value;
        if (text == null) {
            CliPathTextField.$$$reportNull$$$0(5);
        }
        if (current == null) {
            CliPathTextField.$$$reportNull$$$0(6);
        }
        if (next == null) {
            CliPathTextField.$$$reportNull$$$0(7);
        }
        if (cd == null) {
            CliPathTextField.$$$reportNull$$$0(8);
        }
        if ((value = ((StringCliArgument)this.getArgument()).getComponentValue(text, current, next, cd)) == null) {
            return;
        }
        String parameter = DbCliUtil.clearString(value, ((StringCliArgument)this.getArgument()).getUnquoter());
        if (StringUtil.equals((CharSequence)parameter, (CharSequence)this.myField.getText())) {
            return;
        }
        this.myField.setText(parameter);
    }

    @Override
    public boolean configure(@NotNull Collection<DbElement> elements, @NotNull CliContextDescriptor cd) {
        if (elements == null) {
            CliPathTextField.$$$reportNull$$$0(9);
        }
        if (cd == null) {
            CliPathTextField.$$$reportNull$$$0(10);
        }
        if (this.myField.getText().isEmpty()) {
            this.myField.setText(this.getDefaultText());
            return true;
        }
        return false;
    }

    @NotNull
    private String getDefaultText() {
        String string = SystemProperties.getUserHome() + File.separator + this.getPatterns() + "dump.sql";
        if (string == null) {
            CliPathTextField.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull CliContextDescriptor cd) {
        if (cd == null) {
            CliPathTextField.$$$reportNull$$$0(12);
        }
        StringCliArgument argument = (StringCliArgument)this.getArgument();
        String string = StringUtil.isEmptyOrSpaces((String)this.myField.getText()) ? "" : DbCliUtil.fromListToArgument(Collections.singletonList(this.myField.getText()), argument.getPrefix(), argument.getQuoter());
        if (string == null) {
            CliPathTextField.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    public boolean isHideable() {
        return false;
    }

    @NotNull
    private String getPatterns() {
        Object object = this.mySubstitutor == null ? "" : StringUtil.join(this.mySubstitutor.getDefaultPatterns(), (String)"-") + "-";
        if (object == null) {
            CliPathTextField.$$$reportNull$$$0(14);
        }
        return object;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panelDecorator";
                break;
            }
            case 3: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cd";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/component/CliPathTextField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/component/CliPathTextField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullArgument";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "changeState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "configure";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFullArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 13, 14 -> new IllegalStateException(string);
        };
    }
}

