/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.quarkus.gradle.extensions;

import com.intellij.buildsystem.model.unified.UnifiedCoordinates;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.externalSystem.DependencyModifierService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.quarkus.gradle.extensions.QsGradleExtensionsManager;
import com.intellij.quarkus.run.extensions.QsExtensionsManager;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.plugins.gradle.util.GradleConstants;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001e\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016J\u0014\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/quarkus/gradle/extensions/QsGradleExtensionsManager;", "Lcom/intellij/quarkus/run/extensions/QsExtensionsManager;", "<init>", "()V", "supports", "", "module", "Lcom/intellij/openapi/module/Module;", "addDependency", "", "dependency", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "addDependencies", "dependencies", "", "refresh", "Lorg/jetbrains/concurrency/Promise;", "refreshProject", "Ljava/lang/Void;", "project", "Lcom/intellij/openapi/project/Project;", "path", "", "adjustScope", "intellij.quarkus.gradle"})
public final class QsGradleExtensionsManager
implements QsExtensionsManager {
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return Intrinsics.areEqual((Object)GradleConstants.SYSTEM_ID.getId(), (Object)ExternalSystemModulePropertyManager.Companion.getInstance(module).getExternalSystemId());
    }

    public void addDependency(@NotNull Module module, @NotNull UnifiedDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.addDependencies(module, CollectionsKt.listOf((Object)dependency));
    }

    public void addDependencies(@NotNull Module module, @NotNull Collection<UnifiedDependency> dependencies) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DependencyModifierService modifierService = DependencyModifierService.Companion.getInstance(project);
        for (UnifiedDependency dependency : dependencies) {
            modifierService.addDependency(module, this.adjustScope(dependency));
        }
    }

    @NotNull
    public Promise<?> refresh(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        ExternalSystemModulePropertyManager propertyManager = ExternalSystemModulePropertyManager.Companion.getInstance(module);
        String string = propertyManager.getLinkedProjectPath();
        if (string == null) {
            return Promises.resolvedPromise();
        }
        String linkedProjectPath = string;
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.refreshProject(project, linkedProjectPath);
    }

    private final Promise<Void> refreshProject(Project project, String path) {
        AsyncPromise result = new AsyncPromise();
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, GradleConstants.SYSTEM_ID);
        importSpecBuilder.callback(new ExternalProjectRefreshCallback(importSpecBuilder, (AsyncPromise<Void>)result){
            private final ImportSpecBuilder.DefaultProjectRefreshCallback myDefaultCallback;
            final /* synthetic */ AsyncPromise<Void> $result;
            {
                this.$result = $result;
                this.myDefaultCallback = new ImportSpecBuilder.DefaultProjectRefreshCallback($importSpecBuilder.build());
            }

            public void onSuccess(DataNode<ProjectData> externalProject) {
                this.myDefaultCallback.onSuccess(externalProject);
                ApplicationManager.getApplication().invokeLater(() -> refreshProject.1.onSuccess$lambda$0(this.$result));
            }

            public void onFailure(String errorMessage, String errorDetails) {
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                this.myDefaultCallback.onFailure(errorMessage, errorDetails);
                this.$result.setError(errorMessage);
            }

            private static final void onSuccess$lambda$0(AsyncPromise $result) {
                $result.setResult(null);
            }
        });
        ExternalSystemUtil.refreshProject((String)path, (ImportSpecBuilder)importSpecBuilder);
        return (Promise)result;
    }

    private final UnifiedDependency adjustScope(UnifiedDependency dependency) {
        UnifiedCoordinates coordinates = dependency.getCoordinates();
        String gradleScope = dependency.getScope();
        String string = gradleScope;
        gradleScope = Intrinsics.areEqual((Object)string, (Object)"test") ? "testImplementation" : (Intrinsics.areEqual((Object)string, (Object)"runtime") ? "runtimeOnly" : "implementation");
        return new UnifiedDependency(coordinates, gradleScope);
    }
}

