/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.view.structure.DvFamilyId;
import com.intellij.database.view.structure.DvTransformDescriptor;
import com.intellij.database.view.structure.HostFamilyKin;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/view/structure/DvFamilySeparationDescriptor;", "Lcom/intellij/database/view/structure/DvTransformDescriptor;", "kin", "Lcom/intellij/database/view/structure/HostFamilyKin;", "filterDescriptors", "", "Lcom/intellij/database/view/structure/DvFamilySeparationDescriptor$Division;", "<init>", "(Lcom/intellij/database/view/structure/HostFamilyKin;Ljava/util/List;)V", "getFilterDescriptors", "()Ljava/util/List;", "humanReadableDescription", "", "getHumanReadableDescription", "()Ljava/lang/String;", "Division", "intellij.database.core.impl"})
public final class DvFamilySeparationDescriptor
extends DvTransformDescriptor {
    @NotNull
    private final List<Division> filterDescriptors;

    public DvFamilySeparationDescriptor(@NotNull HostFamilyKin kin, @NotNull List<Division> filterDescriptors) {
        Intrinsics.checkNotNullParameter((Object)kin, (String)"kin");
        Intrinsics.checkNotNullParameter(filterDescriptors, (String)"filterDescriptors");
        super(kin, null);
        this.filterDescriptors = filterDescriptors;
    }

    @NotNull
    public final List<Division> getFilterDescriptors() {
        return this.filterDescriptors;
    }

    @Override
    @NotNull
    public String getHumanReadableDescription() {
        return "family separation to " + CollectionsKt.joinToString$default((Iterable)this.filterDescriptors, null, null, null, (int)0, null, DvFamilySeparationDescriptor::_get_humanReadableDescription_$lambda$0, (int)31, null);
    }

    private static final CharSequence _get_humanReadableDescription_$lambda$0(Division it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.displayName;
        return string != null ? (CharSequence)string : (CharSequence)String.valueOf(it.orderNum);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0011\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH\u00c6\u0003J9\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0010\b\u0002\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u000eH\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/database/view/structure/DvFamilySeparationDescriptor$Division;", "", "kin", "Lcom/intellij/database/view/structure/HostFamilyKin;", "orderNum", "", "familyId", "Lcom/intellij/database/view/structure/DvFamilyId;", "predicate", "Ljava/util/function/Predicate;", "Lcom/intellij/database/model/basic/BasicElement;", "<init>", "(Lcom/intellij/database/view/structure/HostFamilyKin;ILcom/intellij/database/view/structure/DvFamilyId;Ljava/util/function/Predicate;)V", "displayName", "", "Lorg/jetbrains/annotations/Nls;", "compareTo", "other", "component1", "component2", "component3", "component4", "copy", "equals", "", "", "hashCode", "toString", "intellij.database.core.impl"})
    public static final class Division
    implements Comparable<Division> {
        @JvmField
        @NotNull
        public final HostFamilyKin kin;
        @JvmField
        public final int orderNum;
        @JvmField
        @NotNull
        public final DvFamilyId familyId;
        @JvmField
        @NotNull
        public final Predicate<? super BasicElement> predicate;
        @JvmField
        @Nullable
        public final String displayName;

        public Division(@NotNull HostFamilyKin kin, int orderNum, @NotNull DvFamilyId familyId, @NotNull Predicate<? super BasicElement> predicate) {
            Intrinsics.checkNotNullParameter((Object)kin, (String)"kin");
            Intrinsics.checkNotNullParameter((Object)familyId, (String)"familyId");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            this.kin = kin;
            this.orderNum = orderNum;
            this.familyId = familyId;
            this.predicate = predicate;
            this.displayName = this.familyId.getFakeKind().getPluralPresentableName();
        }

        @Override
        public int compareTo(@NotNull Division other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            int z = this.kin.compareTo(other.kin);
            if (z == 0) {
                z = Intrinsics.compare((int)this.orderNum, (int)other.orderNum);
            }
            if (z == 0) {
                z = StringUtil.compare((String)this.displayName, (String)other.displayName, (boolean)false);
            }
            return z;
        }

        @NotNull
        public final HostFamilyKin component1() {
            return this.kin;
        }

        public final int component2() {
            return this.orderNum;
        }

        @NotNull
        public final DvFamilyId component3() {
            return this.familyId;
        }

        @NotNull
        public final Predicate<? super BasicElement> component4() {
            return this.predicate;
        }

        @NotNull
        public final Division copy(@NotNull HostFamilyKin kin, int orderNum, @NotNull DvFamilyId familyId, @NotNull Predicate<? super BasicElement> predicate) {
            Intrinsics.checkNotNullParameter((Object)kin, (String)"kin");
            Intrinsics.checkNotNullParameter((Object)familyId, (String)"familyId");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            return new Division(kin, orderNum, familyId, predicate);
        }

        public static /* synthetic */ Division copy$default(Division division, HostFamilyKin hostFamilyKin, int n, DvFamilyId dvFamilyId, Predicate predicate, int n2, Object object) {
            if ((n2 & 1) != 0) {
                hostFamilyKin = division.kin;
            }
            if ((n2 & 2) != 0) {
                n = division.orderNum;
            }
            if ((n2 & 4) != 0) {
                dvFamilyId = division.familyId;
            }
            if ((n2 & 8) != 0) {
                predicate = division.predicate;
            }
            return division.copy(hostFamilyKin, n, dvFamilyId, predicate);
        }

        @NotNull
        public String toString() {
            return "Division(kin=" + this.kin + ", orderNum=" + this.orderNum + ", familyId=" + this.familyId + ", predicate=" + this.predicate + ")";
        }

        public int hashCode() {
            int result = this.kin.hashCode();
            result = result * 31 + Integer.hashCode(this.orderNum);
            result = result * 31 + this.familyId.hashCode();
            result = result * 31 + this.predicate.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Division)) {
                return false;
            }
            Division division = (Division)other;
            if (!Intrinsics.areEqual((Object)this.kin, (Object)division.kin)) {
                return false;
            }
            if (this.orderNum != division.orderNum) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.familyId, (Object)division.familyId)) {
                return false;
            }
            return Intrinsics.areEqual(this.predicate, division.predicate);
        }
    }
}

