/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfoImpl;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TypeScriptEnumLiteralType<TValue>
extends JSPrimitiveLiteralType<TValue>,
JSResolvableType {
    @NotNull
    public String getEnumFieldName();

    @NotNull
    public String getEnumQualifiedName();

    @Override
    @NotNull
    default public JSResolvedTypeInfo resolveType() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        String fieldQualifiedName = this.getEnumQualifiedName() + "." + this.getEnumFieldName();
        if (JSTypeImpl.isSourceElementNotValid(sourceElement)) {
            return new JSResolvedTypeInfoImpl(fieldQualifiedName, ContainerUtil.emptyList());
        }
        JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler();
        JSTypeResolveResult result = importHandler.resolveMainElementName(fieldQualifiedName, sourceElement, JSContext.INSTANCE);
        return new JSResolvedTypeInfoImpl(result.getQualifiedName(), result.getElements());
    }

    @NotNull
    default public JSType asNamedType() {
        return TypeScriptEnumLiteralType.createNamedType(this.getEnumQualifiedName(), this.getEnumFieldName(), this.getSourceElement());
    }

    @NotNull
    public static JSType createNamedType(@NotNull String enumName, @NotNull String enumFieldName, @Nullable PsiElement source) {
        if (enumName == null) {
            TypeScriptEnumLiteralType.$$$reportNull$$$0(0);
        }
        if (enumFieldName == null) {
            TypeScriptEnumLiteralType.$$$reportNull$$$0(1);
        }
        JSType jSType = JSNamedTypeFactory.createType(enumName + "." + enumFieldName, JSTypeSourceFactory.createTypeSource(source, true), JSTypeContext.INSTANCE, false);
        if (jSType == null) {
            TypeScriptEnumLiteralType.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumFieldName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/primitives/TypeScriptEnumLiteralType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/primitives/TypeScriptEnumLiteralType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNamedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNamedType";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

