/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.remote.ColoredRemoteProcessHandler;
import com.intellij.remote.DeferredRemoteProcess;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteProcess;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.ProcessBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import com.jetbrains.plugins.remotesdk.tools.RemoteTool;
import com.jetbrains.plugins.webDeployment.RemoteProjectMacro;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promises;

public class RemoteToolRunProfile
implements ModuleRunProfile {
    private static final Logger LOG = Logger.getInstance(RemoteToolRunProfile.class);
    private final RemoteTool myTool;
    private final RemoteCredentials myRemoteCredentials;
    private final DataContext myContext;
    private final GeneralCommandLine myCommandLine;

    public RemoteToolRunProfile(RemoteTool tool, RemoteCredentials remoteCredentials, DataContext context) {
        this.myTool = tool;
        this.myRemoteCredentials = remoteCredentials;
        this.myContext = SimpleDataContext.builder().add(RemoteProjectMacro.REMOTE_TOOL_CREDENTIALS, (Object)remoteCredentials).setParent(context).build();
        this.myCommandLine = this.myTool.createCommandLine(this.myContext);
    }

    @NotNull
    public String getName() {
        String string = RemoteToolRunProfile.expandMacrosInName(this.myTool, this.myContext);
        if (string == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static String expandMacrosInName(Tool tool, DataContext context) {
        String name = tool.getName();
        try {
            return MacroManager.getInstance().expandMacrosInString(name, true, context);
        }
        catch (Macro.ExecutionCancelledException e) {
            LOG.info((Throwable)e);
            return name;
        }
    }

    public Icon getIcon() {
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(1);
        }
        if (env == null) {
            RemoteToolRunProfile.$$$reportNull$$$0(2);
        }
        final Project project = env.getProject();
        if (this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return RemoteToolRunProfile.this.myCommandLine;
            }

            @NotNull
            protected ProcessHandler startProcess() {
                GeneralCommandLine commandLine = this.createCommandLine();
                ConnectionBuilder connectionBuilder = RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)RemoteToolRunProfile.this.myRemoteCredentials, (Project)project);
                ProcessBuilder builder = RemoteCredentialsUtil.processBuilder((ConnectionBuilder)connectionBuilder, (GeneralCommandLine)commandLine).withAllocatePty(true);
                RemoteSdkPropertiesHolder sdkProperties = new RemoteSdkPropertiesHolder(".idea_helpers");
                sdkProperties.setInterpreterPath("");
                String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)RemoteToolRunProfile.this.myRemoteCredentials, (RemoteSdkProperties)sdkProperties);
                ColoredRemoteProcessHandler processHandler = new ColoredRemoteProcessHandler((RemoteProcess)new DeferredRemoteProcess(Promises.runAsync(() -> ((ProcessBuilder)builder).start())), commandLine.getCommandLineString(fullInterpreterPath + ":" + commandLine.getExePath()), EncodingProjectManager.getInstance((Project)project).getDefaultCharset());
                ProcessTerminatedListener.attach((ProcessHandler)processHandler);
                ColoredRemoteProcessHandler coloredRemoteProcessHandler = processHandler;
                if (coloredRemoteProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return coloredRemoteProcessHandler;
            }

            @NotNull
            public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                ExecutionResult result;
                ProcessHandler processHandler;
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((processHandler = (result = super.execute(executor, runner)).getProcessHandler()) != null) {
                    processHandler.addProcessListener((ProcessListener)new ToolProcessAdapter(project, RemoteToolRunProfile.this.myTool.synchronizeAfterExecution(), RemoteToolRunProfile.this.getName()));
                    processHandler.addProcessListener(new ProcessListener(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (outputType == ProcessOutputTypes.STDOUT && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdOut() || outputType == ProcessOutputTypes.STDERR && RemoteToolRunProfile.this.myTool.isShowConsoleOnStdErr()) {
                                RunContentManager.getInstance((Project)project).toFrontRunContent(executor, processHandler);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                ExecutionResult executionResult = result;
                if (executionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return executionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
        TextConsoleBuilder builder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (FilterInfo outputFilter : this.myTool.getOutputFilters()) {
            builder.addFilter((Filter)new RegexpFilter(project, outputFilter.getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder);
        return commandLineState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/tools/RemoteToolRunProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

