/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.raster.mapping.svg;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.math.MathKt;
import org.jetbrains.letsPlot.core.canvas.Path2d;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgPathParser;", "", "pathData", "", "(Ljava/lang/String;)V", "index", "", "length", "parse", "Lorg/jetbrains/letsPlot/core/canvas/Path2d;", "readNumber", "", "skipWhitespaceAndComma", "", "Companion", "plot-raster"})
public final class SvgPathParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pathData;
    private int index;
    private final int length;

    public SvgPathParser(@NotNull String pathData) {
        Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
        this.pathData = pathData;
        this.length = this.pathData.length();
    }

    @NotNull
    public final Path2d parse() {
        Path2d path = new Path2d();
        double curX = 0.0;
        double curY = 0.0;
        Character currentCommand = null;
        while (this.index < this.length) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            boolean bl5;
            boolean bl6;
            boolean bl7;
            Character c;
            this.skipWhitespaceAndComma();
            if (this.index >= this.length) break;
            char c2 = this.pathData.charAt(this.index);
            if (Character.isLetter(c2)) {
                currentCommand = Character.valueOf(c2);
                int n = this.index;
                this.index = n + 1;
                this.skipWhitespaceAndComma();
            }
            Character c3 = c = currentCommand;
            char c4 = 'M';
            if (c3 != null && c3.charValue() == c4) {
                bl7 = true;
            } else {
                Character c5 = c;
                c4 = 'm';
                bl7 = c5 != null && c5.charValue() == c4;
            }
            if (bl7) {
                Character c6 = currentCommand;
                c4 = 'M';
                if (c6 != null && c6.charValue() == c4) {
                    curX = this.readNumber();
                    curY = this.readNumber();
                } else {
                    curX += this.readNumber();
                    curY += this.readNumber();
                }
                Path2d.moveTo$default((Path2d)path, (double)curX, (double)curY, null, (int)4, null);
                Character c7 = currentCommand;
                c4 = 'M';
                currentCommand = c7 != null && c7.charValue() == c4 ? Character.valueOf('L') : Character.valueOf('l');
                continue;
            }
            Character c8 = c;
            c4 = 'L';
            if (c8 != null && c8.charValue() == c4) {
                bl6 = true;
            } else {
                Character c9 = c;
                c4 = 'l';
                bl6 = c9 != null && c9.charValue() == c4;
            }
            if (bl6) {
                Character c10 = currentCommand;
                c4 = 'L';
                if (c10 != null && c10.charValue() == c4) {
                    curX = this.readNumber();
                    curY = this.readNumber();
                } else {
                    curX += this.readNumber();
                    curY += this.readNumber();
                }
                Path2d.lineTo$default((Path2d)path, (double)curX, (double)curY, null, (int)4, null);
                continue;
            }
            Character c11 = c;
            c4 = 'A';
            if (c11 != null && c11.charValue() == c4) {
                bl5 = true;
            } else {
                Character c12 = c;
                c4 = 'a';
                bl5 = c12 != null && c12.charValue() == c4;
            }
            if (bl5) {
                Pair pair;
                double rx = this.readNumber();
                double ry = this.readNumber();
                double angle = MathKt.toRadians((double)this.readNumber());
                boolean largeArcFlag = (int)this.readNumber() != 0;
                boolean sweepFlag = (int)this.readNumber() != 0;
                double x = this.readNumber();
                double y = this.readNumber();
                char c13 = currentCommand.charValue();
                if (c13 == 'A') {
                    pair = TuplesKt.to((Object)x, (Object)y);
                } else if (c13 == 'a') {
                    pair = TuplesKt.to((Object)(x + curX), (Object)(y + curY));
                } else {
                    throw new IllegalStateException("Should not happen".toString());
                }
                Pair pair2 = pair;
                double newX = ((Number)pair2.component1()).doubleValue();
                double newY = ((Number)pair2.component2()).doubleValue();
                Path2d.arc$default((Path2d)path, (Number)curX, (Number)curY, (Number)newX, (Number)newY, (Number)rx, (Number)ry, (Number)angle, (boolean)largeArcFlag, (boolean)sweepFlag, (boolean)false, null, (int)1024, null);
                curX = newX;
                curY = newY;
                continue;
            }
            Character c14 = c;
            c4 = 'H';
            if (c14 != null && c14.charValue() == c4) {
                bl4 = true;
            } else {
                Character c15 = c;
                c4 = 'h';
                bl4 = c15 != null && c15.charValue() == c4;
            }
            if (bl4) {
                Character c16 = currentCommand;
                c4 = 'H';
                curX = c16 != null && c16.charValue() == c4 ? this.readNumber() : (curX += this.readNumber());
                Path2d.lineTo$default((Path2d)path, (double)curX, (double)curY, null, (int)4, null);
                continue;
            }
            Character c17 = c;
            c4 = 'V';
            if (c17 != null && c17.charValue() == c4) {
                bl3 = true;
            } else {
                Character c18 = c;
                c4 = 'v';
                bl3 = c18 != null && c18.charValue() == c4;
            }
            if (bl3) {
                Character c19 = currentCommand;
                c4 = 'V';
                curY = c19 != null && c19.charValue() == c4 ? this.readNumber() : (curY += this.readNumber());
                Path2d.lineTo$default((Path2d)path, (double)curX, (double)curY, null, (int)4, null);
                continue;
            }
            Character c20 = c;
            c4 = 'C';
            if (c20 != null && c20.charValue() == c4) {
                bl2 = true;
            } else {
                Character c21 = c;
                c4 = 'c';
                bl2 = c21 != null && c21.charValue() == c4;
            }
            if (bl2) {
                Character c22 = currentCommand;
                char c23 = 'C';
                Pair pair = c22 != null && c22.charValue() == c23 ? TuplesKt.to((Object)0.0, (Object)0.0) : TuplesKt.to((Object)curX, (Object)curY);
                double dx = ((Number)pair.component1()).doubleValue();
                double dy = ((Number)pair.component2()).doubleValue();
                double x1 = this.readNumber() + dx;
                double y1 = this.readNumber() + dy;
                double x2 = this.readNumber() + dx;
                double y2 = this.readNumber() + dy;
                double x = this.readNumber() + dx;
                double y = this.readNumber() + dy;
                Path2d.bezierCurveTo$default((Path2d)path, (double)x1, (double)y1, (double)x2, (double)y2, (double)x, (double)y, null, (int)64, null);
                curX = x;
                curY = y;
                continue;
            }
            Character c24 = c;
            c4 = 'Z';
            if (c24 != null && c24.charValue() == c4) {
                bl = true;
            } else {
                Character c25 = c;
                c4 = 'z';
                bl = c25 != null && c25.charValue() == c4;
            }
            if (bl) {
                path.closePath();
                continue;
            }
            throw new IllegalStateException(("Unsupported command: " + currentCommand + " at position " + this.index).toString());
        }
        return path;
    }

    private final void skipWhitespaceAndComma() {
        while (this.index < this.length && (CharsKt.isWhitespace((char)this.pathData.charAt(this.index)) || this.pathData.charAt(this.index) == ',')) {
            int n = this.index;
            this.index = n + 1;
        }
    }

    private final double readNumber() {
        int n;
        this.skipWhitespaceAndComma();
        int start = this.index;
        if (this.index < this.length && (this.pathData.charAt(this.index) == '-' || this.pathData.charAt(this.index) == '+')) {
            n = this.index;
            this.index = n + 1;
        }
        while (this.index < this.length && (Character.isDigit(this.pathData.charAt(this.index)) || this.pathData.charAt(this.index) == '.')) {
            n = this.index;
            this.index = n + 1;
        }
        if (this.index < this.length && (this.pathData.charAt(this.index) == 'e' || this.pathData.charAt(this.index) == 'E')) {
            n = this.index;
            this.index = n + 1;
            if (this.index < this.length && (this.pathData.charAt(this.index) == '-' || this.pathData.charAt(this.index) == '+')) {
                n = this.index;
                this.index = n + 1;
            }
            while (this.index < this.length && Character.isDigit(this.pathData.charAt(this.index))) {
                n = this.index;
                this.index = n + 1;
            }
        }
        String string = this.pathData.substring(start, this.index);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String numberStr = string;
        Double d = StringsKt.toDoubleOrNull((String)numberStr);
        if (d == null) {
            throw new IllegalStateException(("Expected number at position " + start + ". Found: '" + StringsKt.take((String)numberStr, (int)RangesKt.coerceAtMost((int)numberStr.length(), (int)40)) + '\'').toString());
        }
        return d;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/letsPlot/raster/mapping/svg/SvgPathParser$Companion;", "", "()V", "parse", "Lorg/jetbrains/letsPlot/core/canvas/Path2d;", "pathData", "", "plot-raster"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Path2d parse(@NotNull String pathData) {
            Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
            return new SvgPathParser(pathData).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

