/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.deleteattribute;

import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.sixrr.xrp.base.BaseRefactoringDialog;
import com.sixrr.xrp.ui.ScopePanel;
import com.sixrr.xrp.utils.RefactorXBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;

class DeleteAttributeDialog
extends BaseRefactoringDialog {
    private final JLabel attributeNameLabel = new JLabel();
    private final XmlAttribute attribute;
    private final XmlTag tag;

    DeleteAttributeDialog(XmlAttribute attribute) {
        super(attribute.getProject(), true);
        this.setTitle(RefactorXBundle.message("dialog.title.delete.attribute", new Object[0]));
        this.attribute = attribute;
        this.tag = attribute.getParent();
        XmlFile containingFile = (XmlFile)this.tag.getContainingFile();
        this.scopePanel = new ScopePanel(containingFile, this);
        this.init();
        String attributeName = this.attribute.getName();
        String tagName = this.tag.getName();
        this.attributeNameLabel.setText(RefactorXBundle.message("label.text.delete.attribute.0.from.tag.1", attributeName, tagName));
    }

    @Override
    protected String getDimensionServiceKey() {
        return "RefactorX.DeleteAttribute";
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    protected JComponent createNorthPanel() {
        return this.attributeNameLabel;
    }

    @Override
    protected boolean isValid() {
        return this.scopePanel.isScopeValid();
    }

    @Override
    protected String calculateXSLT() {
        String attributeName = this.attribute.getName();
        String tagName = this.tag.getName();
        return " <xsl:template match=\"@" + attributeName + "[parent::" + tagName + "]\"/>";
    }

    @Override
    @NotNull
    protected String getHelpId() {
        return "refactoring.deleteAttribute";
    }
}

