/*
 * This file is part of roccat-tools.
 *
 * roccat-tools is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * roccat-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with roccat-tools. If not, see <http://www.gnu.org/licenses/>.
 */

#include "sova_gui_key_relations.h"
#include <string.h>

SovaGuiKeyPosition const sova_gui_key_positions_general[] = {
		{  0,  0, 4,  0, 4},
		{  1,  0, 4,  4, 4},
		{  2,  0, 4,  8, 4},
		{  3,  0, 4, 12, 4},
		{  4,  0, 4, 16, 4},
		{  5,  0, 4, 20, 4},
		{  6,  0, 4, 24, 4},
		{  7,  0, 4, 28, 4},
		{  8,  0, 4, 32, 4},
		{  9,  0, 4, 36, 4},
		{ 10,  0, 4, 40, 4},
		{ 11,  0, 4, 44, 4},
		{ 12,  0, 4, 48, 4},
		{ 13,  0, 4, 52, 4},
		{ 14,  0, 4, 56, 4},
		{ 15,  0, 4, 60, 4},

		{ 16,  5, 4,  0, 4},
		{ 17,  5, 4,  4, 4},
		{ 18,  5, 4,  8, 4},
		{ 19,  5, 4, 12, 4},
		{ 20,  5, 4, 16, 4},
		{ 21,  5, 4, 20, 4},
		{ 22,  5, 4, 24, 4},
		{ 23,  5, 4, 28, 4},
		{ 24,  5, 4, 32, 4},
		{ 25,  5, 4, 36, 4},
		{ 26,  5, 4, 40, 4},
		{ 27,  5, 4, 44, 4},
		{ 28,  5, 4, 48, 4},
		{ 29,  5, 4, 52, 8},
		{ 30,  5, 4, 60, 4},

		{ 31,  9, 4,  0, 6},
		{ 32,  9, 4,  6, 4},
		{ 33,  9, 4, 10, 4},
		{ 34,  9, 4, 14, 4},
		{ 35,  9, 4, 18, 4},
		{ 36,  9, 4, 22, 4},
		{ 37,  9, 4, 26, 4},
		{ 38,  9, 4, 30, 4},
		{ 39,  9, 4, 34, 4},
		{ 40,  9, 4, 38, 4},
		{ 41,  9, 4, 42, 4},
		{ 42,  9, 4, 46, 4},
		{ 43,  9, 4, 50, 4},
		{ 44,  9, 8, 55, 5},
		{ 45,  9, 4, 60, 4},

		{ 46, 13, 4,  0, 7},
		{ 47, 13, 4,  7, 4},
		{ 48, 13, 4, 11, 4},
		{ 49, 13, 4, 15, 4},
		{ 50, 13, 4, 19, 4},
		{ 51, 13, 4, 23, 4},
		{ 52, 13, 4, 27, 4},
		{ 53, 13, 4, 31, 4},
		{ 54, 13, 4, 35, 4},
		{ 55, 13, 4, 39, 4},
		{ 56, 13, 4, 43, 4},
		{ 57, 13, 4, 47, 4},
		{ 58, 13, 4, 51, 4},
		{ 59, 13, 4, 60, 4},

		{ 60, 17, 4,  0, 5},
		{ 61, 17, 4,  5, 4},
		{ 62, 17, 4,  9, 4},
		{ 63, 17, 4, 13, 4},
		{ 64, 17, 4, 17, 4},
		{ 65, 17, 4, 21, 4},
		{ 66, 17, 4, 25, 4},
		{ 67, 17, 4, 29, 4},
		{ 68, 17, 4, 33, 4},
		{ 69, 17, 4, 37, 4},
		{ 70, 17, 4, 41, 4},
		{ 71, 17, 4, 45, 4},
		{ 72, 17, 4, 49, 7},
		{ 73, 17, 4, 56, 4},
		{ 74, 17, 4, 60, 4},

		{ 75, 21, 4,  0,  5},
		{ 76, 21, 4,  5,  4},
		{ 77, 21, 4,  9,  5},
		{ 78, 21, 4, 14, 25},
		{ 79, 21, 4, 39,  5},
		{ 80, 21, 4, 44,  4},
		{ 81, 21, 4, 48,  4},
		{ 82, 21, 4, 52,  4},
		{ 83, 21, 4, 56,  4},
		{ 84, 21, 4, 60,  4},

		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_de[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_us[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_fr[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_nr[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_kr[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_jp[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_cz[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const sova_gui_key_positions_empty[] = {
		{SOVA_GUI_KEY_POSITION_INDEX_END, 0, 0, 0}
};

SovaGuiKeyPosition const *sova_gui_key_positions_get(gchar const *layout) {
	if (!strcmp(layout, "DE"))
		return sova_gui_key_positions_de;
	else if (!strcmp(layout, "US"))
		return sova_gui_key_positions_us;
	else if (!strcmp(layout, "FR"))
		return sova_gui_key_positions_fr;
	else if (!strcmp(layout, "NR"))
		return sova_gui_key_positions_nr;
	else if (!strcmp(layout, "KR"))
		return sova_gui_key_positions_kr;
	else if (!strcmp(layout, "JP"))
		return sova_gui_key_positions_jp;
	else if (!strcmp(layout, "CZ"))
		return sova_gui_key_positions_cz;
	else
		return sova_gui_key_positions_empty;
}
