// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Content block start event.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct ContentBlockStartEvent {
    /// <p>Start information about a content block start event.</p>
    pub start: ::std::option::Option<crate::types::ContentBlockStart>,
    /// <p>The index for a content block start event.</p>
    pub content_block_index: i32,
}
impl ContentBlockStartEvent {
    /// <p>Start information about a content block start event.</p>
    pub fn start(&self) -> ::std::option::Option<&crate::types::ContentBlockStart> {
        self.start.as_ref()
    }
    /// <p>The index for a content block start event.</p>
    pub fn content_block_index(&self) -> i32 {
        self.content_block_index
    }
}
impl ContentBlockStartEvent {
    /// Creates a new builder-style object to manufacture [`ContentBlockStartEvent`](crate::types::ContentBlockStartEvent).
    pub fn builder() -> crate::types::builders::ContentBlockStartEventBuilder {
        crate::types::builders::ContentBlockStartEventBuilder::default()
    }
}

/// A builder for [`ContentBlockStartEvent`](crate::types::ContentBlockStartEvent).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct ContentBlockStartEventBuilder {
    pub(crate) start: ::std::option::Option<crate::types::ContentBlockStart>,
    pub(crate) content_block_index: ::std::option::Option<i32>,
}
impl ContentBlockStartEventBuilder {
    /// <p>Start information about a content block start event.</p>
    /// This field is required.
    pub fn start(mut self, input: crate::types::ContentBlockStart) -> Self {
        self.start = ::std::option::Option::Some(input);
        self
    }
    /// <p>Start information about a content block start event.</p>
    pub fn set_start(mut self, input: ::std::option::Option<crate::types::ContentBlockStart>) -> Self {
        self.start = input;
        self
    }
    /// <p>Start information about a content block start event.</p>
    pub fn get_start(&self) -> &::std::option::Option<crate::types::ContentBlockStart> {
        &self.start
    }
    /// <p>The index for a content block start event.</p>
    /// This field is required.
    pub fn content_block_index(mut self, input: i32) -> Self {
        self.content_block_index = ::std::option::Option::Some(input);
        self
    }
    /// <p>The index for a content block start event.</p>
    pub fn set_content_block_index(mut self, input: ::std::option::Option<i32>) -> Self {
        self.content_block_index = input;
        self
    }
    /// <p>The index for a content block start event.</p>
    pub fn get_content_block_index(&self) -> &::std::option::Option<i32> {
        &self.content_block_index
    }
    /// Consumes the builder and constructs a [`ContentBlockStartEvent`](crate::types::ContentBlockStartEvent).
    /// This method will fail if any of the following fields are not set:
    /// - [`content_block_index`](crate::types::builders::ContentBlockStartEventBuilder::content_block_index)
    pub fn build(self) -> ::std::result::Result<crate::types::ContentBlockStartEvent, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::ContentBlockStartEvent {
            start: self.start,
            content_block_index: self.content_block_index.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "content_block_index",
                    "content_block_index was not specified but it is required when building ContentBlockStartEvent",
                )
            })?,
        })
    }
}
