// RUN: %clang_cc1 -triple aarch64-linux-gnu -mbranch-target-enforce -msign-return-address=all      -emit-llvm %s -o - | FileCheck --check-prefixes=CHECK,BTI-SIGNRA %s
// RUN: %clang_cc1 -triple arm64-apple-ios   -mbranch-target-enforce -msign-return-address=all      -emit-llvm %s -o - | FileCheck --check-prefixes=CHECK,BTI-SIGNRA %s
// RUN: %clang_cc1 -triple aarch64-linux-gnu -fptrauth-calls -fptrauth-returns -fptrauth-auth-traps -emit-llvm %s -o - | FileCheck --check-prefixes=CHECK,PAUTHTEST  %s
// RUN: %clang_cc1 -triple arm64-apple-ios   -fptrauth-calls -fptrauth-returns -fptrauth-auth-traps -emit-llvm %s -o - | FileCheck --check-prefixes=CHECK,PAUTHTEST  %s

// Check that both multi-versioned functions themselves and corresponding
// resolvers generated by Clang have the correct PAC/BTI attributes.

int __attribute__((target_clones("crc", "default"))) global_target_clones(void) { return 0; }

int __attribute__((target_version("crc")))     global_target_version(void) { return 0; }
int __attribute__((target_version("default"))) global_target_version(void) { return 0; }

static int __attribute__((target_clones("crc", "default"))) static_target_clones(void) { return 0; }

static int __attribute__((target_version("crc")))     static_target_version(void) { return 0; }
static int __attribute__((target_version("default"))) static_target_version(void) { return 0; }

// Force emission of static_* functions.
void *get_ptr1(void) { return static_target_clones; }
void *get_ptr2(void) { return static_target_version; }

// CHECK-DAG: define{{( dso_local)?}} i32 @global_target_clones._Mcrc()    #[[ATTR_CRC:[0-9]+]]
// CHECK-DAG: define{{( dso_local)?}} i32 @global_target_clones.default()  #[[ATTR_DEFAULT:[0-9]+]]
// CHECK-DAG: define weak_odr         ptr @global_target_clones.resolver() #[[ATTR_RESOLVER:[0-9]+]]
// CHECK-DAG: define{{( dso_local)?}} i32 @global_target_version._Mcrc()    #[[ATTR_CRC]]
// CHECK-DAG: define{{( dso_local)?}} i32 @global_target_version.default()  #[[ATTR_DEFAULT]]
// CHECK-DAG: define weak_odr         ptr @global_target_version.resolver() #[[ATTR_RESOLVER]]

// CHECK-DAG: define internal i32 @static_target_clones._Mcrc()    #[[ATTR_CRC:[0-9]+]]
// CHECK-DAG: define internal i32 @static_target_clones.default()  #[[ATTR_DEFAULT:[0-9]+]]
// CHECK-DAG: define internal ptr @static_target_clones.resolver() #[[ATTR_RESOLVER:[0-9]+]]
// CHECK-DAG: define internal i32 @static_target_version._Mcrc()    #[[ATTR_CRC]]
// CHECK-DAG: define internal i32 @static_target_version.default()  #[[ATTR_DEFAULT]]
// CHECK-DAG: define internal ptr @static_target_version.resolver() #[[ATTR_RESOLVER]]

// BTI-SIGNRA-DAG: attributes #[[ATTR_CRC]]      = { {{.*}}"branch-target-enforcement" {{.*}}"sign-return-address"="all" "sign-return-address-key"="a_key"{{.*}} }
// BTI-SIGNRA-DAG: attributes #[[ATTR_RESOLVER]] = { {{.*}}"branch-target-enforcement" {{.*}}"sign-return-address"="all" "sign-return-address-key"="a_key"{{.*}} }
// BTI-SIGNRA-DAG: attributes #[[ATTR_DEFAULT]]  = { {{.*}}"branch-target-enforcement" {{.*}}"sign-return-address"="all" "sign-return-address-key"="a_key"{{.*}} }
// PAUTHTEST-DAG:  attributes #[[ATTR_CRC]]      = { {{.*}}"ptrauth-auth-traps" "ptrauth-calls" "ptrauth-returns"{{.*}} }
// PAUTHTEST-DAG:  attributes #[[ATTR_RESOLVER]] = { {{.*}}"ptrauth-auth-traps" "ptrauth-calls" "ptrauth-returns"{{.*}} }
// PAUTHTEST-DAG:  attributes #[[ATTR_DEFAULT]]  = { {{.*}}"ptrauth-auth-traps" "ptrauth-calls" "ptrauth-returns"{{.*}} }
