/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.ui.link;

import com.intellij.openapi.project.Project;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloud.QodanaCloudStateService;
import org.jetbrains.qodana.cloud.UserState;
import org.jetbrains.qodana.cloud.project.CloudProjectData;
import org.jetbrains.qodana.cloud.project.LinkKt;
import org.jetbrains.qodana.cloud.project.LinkState;
import org.jetbrains.qodana.cloud.project.QodanaCloudProjectLinkService;
import org.jetbrains.qodana.coroutines.LifetimeKt;
import org.jetbrains.qodana.coroutines.QodanaDispatchersKt;
import org.jetbrains.qodana.settings.QodanaSettingsKt;
import org.jetbrains.qodana.stats.SourceLinkState;
import org.jetbrains.qodana.ui.link.LinkCloudProjectViewModel;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0010\u0010\u001d\u001a\u00020\u001a2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011J\u0006\u0010\u001e\u001a\u00020\u001aJ\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0011J\u001a\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015\u00a8\u0006\""}, d2={"Lorg/jetbrains/qodana/ui/link/LinkCloudProjectViewModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "userAndLinkStatesFlow", "Lkotlinx/coroutines/flow/Flow;", "Lkotlin/Pair;", "Lorg/jetbrains/qodana/cloud/UserState;", "Lorg/jetbrains/qodana/cloud/project/LinkState;", "getUserAndLinkStatesFlow", "()Lkotlinx/coroutines/flow/Flow;", "_selectedProject", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/jetbrains/qodana/cloud/project/CloudProjectData;", "selectedProject", "Lkotlinx/coroutines/flow/StateFlow;", "getSelectedProject", "()Lkotlinx/coroutines/flow/StateFlow;", "_isAutoLoadReportEnabled", "", "isAutoLoadReportEnabled", "setAutoLoadReportEnabled", "", "isEnabled", "isModified", "setSelectedProject", "finishAndLinkWithSelectedCloudProject", "linkWithCloudProject", "cloudProjectData", "createUserAndLinkStatesFlow", "intellij.qodana"})
public final class LinkCloudProjectViewModel {
    @NotNull
    private final Project project;
    @NotNull
    private final Flow<Pair<UserState, LinkState>> userAndLinkStatesFlow;
    @NotNull
    private final MutableStateFlow<CloudProjectData> _selectedProject;
    @NotNull
    private final StateFlow<CloudProjectData> selectedProject;
    @NotNull
    private final MutableStateFlow<Boolean> _isAutoLoadReportEnabled;
    @NotNull
    private final StateFlow<Boolean> isAutoLoadReportEnabled;

    public LinkCloudProjectViewModel(@NotNull Project project, @NotNull CoroutineScope scope2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.project = project;
        this.userAndLinkStatesFlow = this.createUserAndLinkStatesFlow();
        this._selectedProject = StateFlowKt.MutableStateFlow(null);
        this.selectedProject = FlowKt.asStateFlow(this._selectedProject);
        this._isAutoLoadReportEnabled = StateFlowKt.MutableStateFlow((Object)QodanaSettingsKt.qodanaSettings(this.project).getLoadMatchingCloudReportAutomatically().getValue());
        this.isAutoLoadReportEnabled = FlowKt.asStateFlow(this._isAutoLoadReportEnabled);
        BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LinkCloudProjectViewModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = QodanaSettingsKt.qodanaSettings(this.this$0.project).getLoadMatchingCloudReportAutomatically().collect(new FlowCollector(){

                            public final Object emit(boolean it, Continuation<? super Unit> $completion) {
                                this$0._isAutoLoadReportEnabled.setValue((Object)Boxing.boxBoolean((boolean)it));
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object2 != object) throw new KotlinNothingValueException();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final Flow<Pair<UserState, LinkState>> getUserAndLinkStatesFlow() {
        return this.userAndLinkStatesFlow;
    }

    @NotNull
    public final StateFlow<CloudProjectData> getSelectedProject() {
        return this.selectedProject;
    }

    @NotNull
    public final StateFlow<Boolean> isAutoLoadReportEnabled() {
        return this.isAutoLoadReportEnabled;
    }

    public final void setAutoLoadReportEnabled(boolean isEnabled) {
        this._isAutoLoadReportEnabled.setValue((Object)isEnabled);
    }

    public final boolean isModified() {
        return this.selectedProject.getValue() != null || ((Boolean)QodanaSettingsKt.qodanaSettings(this.project).getLoadMatchingCloudReportAutomatically().getValue()).booleanValue() != ((Boolean)this.isAutoLoadReportEnabled.getValue()).booleanValue();
    }

    public final void setSelectedProject(@Nullable CloudProjectData selectedProject) {
        this._selectedProject.setValue((Object)selectedProject);
    }

    public final void finishAndLinkWithSelectedCloudProject() {
        QodanaSettingsKt.qodanaSettings(this.project).setLoadMatchingCloudReportAutomatically((Boolean)this.isAutoLoadReportEnabled.getValue());
        CloudProjectData cloudProjectData = (CloudProjectData)this.selectedProject.getValue();
        if (cloudProjectData == null) {
            return;
        }
        CloudProjectData selectedQodanaCloudProject = cloudProjectData;
        this.linkWithCloudProject(LifetimeKt.getQodanaProjectScope(this.project), selectedQodanaCloudProject);
    }

    public final void linkWithCloudProject(@NotNull CoroutineScope scope2, @NotNull CloudProjectData cloudProjectData) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)cloudProjectData, (String)"cloudProjectData");
        BuildersKt.launch$default((CoroutineScope)scope2, (CoroutineContext)QodanaDispatchersKt.getQodanaDispatchers().getDefault(), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, cloudProjectData, null){
            int label;
            final /* synthetic */ LinkCloudProjectViewModel this$0;
            final /* synthetic */ CloudProjectData $cloudProjectData;
            {
                this.this$0 = $receiver;
                this.$cloudProjectData = $cloudProjectData;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = LinkKt.linkWithCloudProjectAndApply(LinkCloudProjectViewModel.access$getProject$p(this.this$0), this.$cloudProjectData, SourceLinkState.LINK_VIEW, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final Flow<Pair<UserState, LinkState>> createUserAndLinkStatesFlow() {
        StateFlow<UserState> userState = QodanaCloudStateService.Companion.getInstance().getUserState();
        StateFlow<LinkState> linkState = QodanaCloudProjectLinkService.Companion.getInstance(this.project).getLinkState();
        return FlowKt.combine((Flow)((Flow)userState), (Flow)((Flow)linkState), (Function3)createUserAndLinkStatesFlow.3.INSTANCE);
    }

    private static final /* synthetic */ Object createUserAndLinkStatesFlow$lambda$0(UserState p0, LinkState p1, Continuation $completion) {
        return new Pair((Object)p0, (Object)p1);
    }

    public static final /* synthetic */ Object access$createUserAndLinkStatesFlow$lambda$0(UserState p0, LinkState p1, Continuation $completion) {
        return LinkCloudProjectViewModel.createUserAndLinkStatesFlow$lambda$0(p0, p1, $completion);
    }
}

