/*
 * Decompiled with CFR 0.152.
 */
package git4idea.config;

import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.Topic;
import git4idea.config.GitExecutable;
import git4idea.config.GitExecutableDetector;
import git4idea.config.GitExecutableFileTester;
import git4idea.config.GitExecutableListener;
import git4idea.config.GitExecutableProblemHandlersKt;
import git4idea.config.GitExecutableProblemsNotifier;
import git4idea.config.GitNotInstalledException;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionIdentificationException;
import git4idea.config.NotificationErrorNotifier;
import git4idea.i18n.GitBundle;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitExecutableManager {
    private static final Logger LOG = Logger.getInstance(GitExecutableManager.class);
    @NotNull
    private final GitExecutableDetector myExecutableDetector = new GitExecutableDetector();
    @NotNull
    private final GitExecutableFileTester myVersionCache = new GitExecutableFileTester();
    @Topic.AppLevel
    public static final Topic<GitExecutableListener> TOPIC = new Topic(GitExecutableListener.class, Topic.BroadcastDirection.NONE);

    public static GitExecutableManager getInstance() {
        return (GitExecutableManager)ApplicationManager.getApplication().getService(GitExecutableManager.class);
    }

    @NotNull
    public String getPathToGit() {
        String string = this.getPathToGit(null);
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPathToGit(@Nullable Project project) {
        String pathToGit = this.getPathToGit(project, null, true);
        if (pathToGit == null) {
            pathToGit = GitExecutableDetector.getDefaultExecutable();
        }
        String string = pathToGit;
        if (string == null) {
            GitExecutableManager.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private String getPathToGit(@Nullable Project project, @Nullable Path gitDirectory, boolean detectIfNeeded) {
        String path = null;
        if (project != null && (project.isDefault() || TrustedProjects.isProjectTrusted((Project)project))) {
            path = GitVcsSettings.getInstance((Project)project).getPathToGit();
        }
        if (path == null) {
            path = GitVcsApplicationSettings.getInstance().getSavedPathToGit();
        }
        if (path == null) {
            path = this.myExecutableDetector.getExecutable(project, gitDirectory, detectIfNeeded);
        }
        return path;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project) {
        GitExecutable gitExecutable = this.getExecutable(project, (Path)null);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(2);
        }
        return gitExecutable;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project, @Nullable Path gitDirectory) {
        String path = this.getPathToGit(project, gitDirectory, true);
        if (path == null) {
            path = GitExecutableDetector.getDefaultExecutable();
        }
        GitExecutable gitExecutable = this.getExecutable(project, path);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(3);
        }
        return gitExecutable;
    }

    @NotNull
    public GitExecutable getExecutable(@Nullable Project project, @NotNull String pathToGit) {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(4);
        }
        GitExecutable gitExecutable = GitExecutableDetector.getGitExecutable(project, pathToGit);
        if (gitExecutable == null) {
            GitExecutableManager.$$$reportNull$$$0(5);
        }
        return gitExecutable;
    }

    @Nullable
    public String getDetectedExecutable(@Nullable Project project, boolean detectIfNeeded) {
        return this.myExecutableDetector.getExecutable(project, null, detectIfNeeded);
    }

    @RequiresBackgroundThread
    public void dropExecutableCache() {
        ThreadingAssertions.assertBackgroundThread();
        this.myExecutableDetector.clear();
    }

    @NotNull
    public GitVersion getVersion(@NotNull Project project) {
        String pathToGit;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(6);
        }
        if ((pathToGit = this.getPathToGit(project, null, false)) == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(7);
            }
            return gitVersion;
        }
        GitExecutable executable = this.getExecutable(project, pathToGit);
        GitVersion gitVersion = this.getVersion(executable);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(8);
        }
        return gitVersion;
    }

    @NotNull
    public GitVersion getVersion(@NotNull GitExecutable executable) {
        GitExecutableFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(9);
        }
        if ((result2 = this.myVersionCache.getCachedResultFor(executable)) == null || result2.getResult() == null) {
            GitVersion gitVersion = GitVersion.NULL;
            if (gitVersion == null) {
                GitExecutableManager.$$$reportNull$$$0(10);
            }
            return gitVersion;
        }
        GitVersion gitVersion = result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(11);
        }
        return gitVersion;
    }

    @RequiresEdt
    @NotNull
    public GitVersion getVersionUnderModalProgressOrCancel(@NotNull Project project) throws ProcessCanceledException {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.assertEventDispatchThread();
        GitVersion gitVersion = (GitVersion)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GitVersion version;
            GitExecutable executable = this.getExecutable(project);
            try {
                version = this.identifyVersion(project, executable);
            }
            catch (GitVersionIdentificationException e) {
                throw new ProcessCanceledException();
            }
            return version;
        }, GitBundle.message((String)"git.executable.version.progress.title", (Object[])new Object[0]), true, project);
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(13);
        }
        return gitVersion;
    }

    @Nullable
    public GitVersion tryGetVersion(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(14);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message((String)"git.executable.version.progress.title", (Object[])new Object[0]), () -> {
            try {
                GitExecutable executable = this.getExecutable(project);
                return this.identifyVersion(project, executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    @Nullable
    public GitVersion tryGetVersion(@Nullable Project project, @NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(15);
        }
        return (GitVersion)GitExecutableManager.runUnderProgressIfNeeded(project, GitBundle.message((String)"git.executable.version.progress.title", (Object[])new Object[0]), () -> {
            try {
                return this.identifyVersion(project, executable);
            }
            catch (ProcessCanceledException | GitVersionIdentificationException e) {
                return null;
            }
        });
    }

    static <T> T runUnderProgressIfNeeded(@Nullable Project project, @NlsContexts.ProgressTitle @NotNull String title, @NotNull ThrowableComputable<T, RuntimeException> task) {
        if (title == null) {
            GitExecutableManager.$$$reportNull$$$0(16);
        }
        if (task == null) {
            GitExecutableManager.$$$reportNull$$$0(17);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(task, title, true, project);
        }
        return (T)task.compute();
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion getVersionOrIdentifyIfNeeded(@NotNull Project project) {
        GitVersion version;
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(18);
        }
        if ((version = this.getVersion(project)).isNull()) {
            version = this.tryGetVersion(project);
        }
        GitVersion gitVersion = version != null ? version : GitVersion.NULL;
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(19);
        }
        return gitVersion;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@NotNull String pathToGit) throws GitVersionIdentificationException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(20);
        }
        GitVersion gitVersion = this.identifyVersion(null, this.getExecutable(null, pathToGit));
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(21);
        }
        return gitVersion;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@Nullable Project project, @NotNull String pathToGit) throws GitVersionIdentificationException {
        if (pathToGit == null) {
            GitExecutableManager.$$$reportNull$$$0(22);
        }
        GitVersion gitVersion = this.identifyVersion(project, this.getExecutable(project, pathToGit));
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(23);
        }
        return gitVersion;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public GitVersion identifyVersion(@Nullable Project project, @NotNull GitExecutable executable) throws GitVersionIdentificationException {
        GitExecutableFileTester.TestResult result2;
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(24);
        }
        if ((result2 = this.myVersionCache.getResultFor(project, executable)).getResult() == null) {
            Exception e = result2.getException();
            if (e instanceof NoSuchFileException && executable.getExePath().equals(GitExecutableDetector.getDefaultExecutable())) {
                throw new GitNotInstalledException(GitBundle.message((String)"executable.error.git.not.installed", (Object[])new Object[0]), e);
            }
            throw new GitVersionIdentificationException(GitBundle.message((String)"git.executable.validation.cant.identify.executable.message", (Object[])new Object[]{executable}), e);
        }
        GitVersion gitVersion = result2.getResult();
        if (gitVersion == null) {
            GitExecutableManager.$$$reportNull$$$0(25);
        }
        return gitVersion;
    }

    public void dropVersionCache(@NotNull GitExecutable executable) {
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(26);
        }
        this.myVersionCache.dropCache(executable);
    }

    public void dropVersionCache() {
        this.myVersionCache.dropCache();
    }

    @RequiresBackgroundThread
    public boolean testGitExecutableVersionValid(@NotNull Project project) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(27);
        }
        ThreadingAssertions.assertBackgroundThread();
        GitExecutable executable = this.getExecutable(project);
        GitVersion version = this.identifyVersionOrDisplayError(project, executable);
        if (version == null) {
            return false;
        }
        GitExecutableProblemsNotifier executableProblemsNotifier = GitExecutableProblemsNotifier.getInstance(project);
        if (version.isSupported()) {
            executableProblemsNotifier.expireNotifications();
            return true;
        }
        GitExecutableProblemHandlersKt.showUnsupportedVersionError(project, version, new NotificationErrorNotifier(project));
        return false;
    }

    @RequiresBackgroundThread
    @Nullable
    private GitVersion identifyVersionOrDisplayError(@NotNull Project project, @NotNull GitExecutable executable) {
        if (project == null) {
            GitExecutableManager.$$$reportNull$$$0(28);
        }
        if (executable == null) {
            GitExecutableManager.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertBackgroundThread();
        try {
            return this.identifyVersion(project, executable);
        }
        catch (GitVersionIdentificationException e) {
            GitExecutableProblemsNotifier.getInstance(project).notifyExecutionError(e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 9, 12, 14, 15, 16, 17, 18, 20, 22, 24, 26, 27, 28, 29 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 4: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToGit";
                break;
            }
            case 6: 
            case 12: 
            case 14: 
            case 18: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 15: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToGit";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutable";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/config/GitExecutableManager";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersion";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionOrIdentifyIfNeeded";
                break;
            }
            case 21: 
            case 23: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "identifyVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getExecutable";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVersionUnderModalProgressOrCancel";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryGetVersion";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "runUnderProgressIfNeeded";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getVersionOrIdentifyIfNeeded";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "dropVersionCache";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "testGitExecutableVersionValid";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "identifyVersionOrDisplayError";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 9, 12, 14, 15, 16, 17, 18, 20, 22, 24, 26, 27, 28, 29 -> new IllegalArgumentException(string);
        };
    }
}

