/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.xml.XmlAttributeDelegate;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlAttributeImpl
extends XmlElementImpl
implements XmlAttribute,
HintedReferenceHost {
    private static final Logger LOG = Logger.getInstance(XmlAttributeImpl.class);
    private final int myHC;
    @Nullable
    private volatile XmlAttributeDelegate myImpl;

    public final int hashCode() {
        return this.myHC;
    }

    public XmlAttributeImpl() {
        super(XmlElementType.XML_ATTRIBUTE);
        this.myHC = ourHC++;
    }

    protected XmlAttributeImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            XmlAttributeImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myHC = ourHC++;
    }

    @NotNull
    private XmlAttributeDelegate getImpl() {
        XmlAttributeDelegate impl = this.myImpl;
        if (impl != null) {
            XmlAttributeDelegate xmlAttributeDelegate = impl;
            if (xmlAttributeDelegate == null) {
                XmlAttributeImpl.$$$reportNull$$$0(1);
            }
            return xmlAttributeDelegate;
        }
        this.myImpl = impl = this.createDelegate();
        XmlAttributeDelegate xmlAttributeDelegate = impl;
        if (xmlAttributeDelegate == null) {
            XmlAttributeImpl.$$$reportNull$$$0(2);
        }
        return xmlAttributeDelegate;
    }

    @NotNull
    protected XmlAttributeDelegate createDelegate() {
        return new XmlAttributeImplDelegate();
    }

    public XmlAttributeValue getValueElement() {
        return (XmlAttributeValue)XmlChildRole.ATTRIBUTE_VALUE_FINDER.findChild((ASTNode)this);
    }

    public void setValue(@NotNull String valueText) throws IncorrectOperationException {
        if (valueText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(3);
        }
        this.getImpl().setValue(valueText);
    }

    @Nullable
    public XmlElement getNameElement() {
        ASTNode child = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild((ASTNode)this);
        return child == null ? null : (XmlElement)child.getPsi();
    }

    @NotNull
    public String getNamespace() {
        String string = this.getImpl().getNamespace();
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getNamespacePrefix() {
        String string = XmlUtil.findPrefixByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public XmlTag getParent() {
        PsiElement parentTag = super.getParent();
        return parentTag instanceof XmlTag ? (XmlTag)parentTag : null;
    }

    @NotNull
    public String getLocalName() {
        String string = XmlUtil.findLocalNameByQualifiedName(this.getName());
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            XmlAttributeImpl.$$$reportNull$$$0(7);
        }
        if (visitor instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor).visitXmlAttribute((XmlAttribute)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getValue() {
        XmlAttributeValue valueElement = this.getValueElement();
        return valueElement != null ? valueElement.getValue() : null;
    }

    @Nullable
    public String getDisplayValue() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        return state == null ? null : state.myDisplayText;
    }

    public int physicalToDisplay(int physicalIndex) {
        return this.getImpl().physicalToDisplay(physicalIndex);
    }

    public int displayToPhysical(int displayIndex) {
        return this.getImpl().displayToPhysical(displayIndex);
    }

    @NotNull
    public TextRange getValueTextRange() {
        XmlAttributeDelegate.VolatileState state = this.getImpl().getFreshState();
        TextRange textRange = state == null ? TextRange.EMPTY_RANGE : state.myValueTextRange;
        if (textRange == null) {
            XmlAttributeImpl.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myImpl = null;
    }

    @NotNull
    public String getName() {
        XmlElement element = this.getNameElement();
        return element != null ? element.getText() : "";
    }

    public boolean isNamespaceDeclaration() {
        @NonNls String name = this.getName();
        return name.startsWith("xmlns:") || name.equals("xmlns");
    }

    @NotNull
    public PsiElement setName(@NotNull String nameText) throws IncorrectOperationException {
        if (nameText == null) {
            XmlAttributeImpl.$$$reportNull$$$0(9);
        }
        PsiElement psiElement = this.getImpl().setName(nameText);
        if (psiElement == null) {
            XmlAttributeImpl.$$$reportNull$$$0(10);
        }
        return psiElement;
    }

    public PsiReference getReference() {
        return (PsiReference)ArrayUtil.getFirstElement((Object[])this.getReferences(PsiReferenceService.Hints.NO_HINTS));
    }

    public boolean shouldAskParentForReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Deprecated
    public final PsiReference @NotNull [] getReferences() {
        PsiReference[] psiReferenceArray = this.getReferences(PsiReferenceService.Hints.NO_HINTS);
        if (psiReferenceArray == null) {
            XmlAttributeImpl.$$$reportNull$$$0(12);
        }
        return psiReferenceArray;
    }

    public PsiReference @NotNull [] getReferences(@NotNull PsiReferenceService.Hints hints) {
        if (hints == null) {
            XmlAttributeImpl.$$$reportNull$$$0(13);
        }
        PsiReference[] psiReferenceArray = this.getImpl().getDefaultReferences(hints);
        if (psiReferenceArray == null) {
            XmlAttributeImpl.$$$reportNull$$$0(14);
        }
        return psiReferenceArray;
    }

    @Nullable
    public XmlAttributeDescriptor getDescriptor() {
        return this.getImpl().getDescriptor();
    }

    @NotNull
    public static String getRealName(@NotNull XmlAttribute attribute) {
        String name;
        if (attribute == null) {
            XmlAttributeImpl.$$$reportNull$$$0(15);
        }
        String string = (name = attribute.getLocalName()).endsWith("IntellijIdeaRulezzz") ? name.substring(0, name.length() - "IntellijIdeaRulezzz".length()) : name;
        if (string == null) {
            XmlAttributeImpl.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 8, 10, 12, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameText";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hints";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlAttributeImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespace";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespacePrefix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueTextRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "setName";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldAskParentForReferences";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRealName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 8, 10, 12, 14, 16 -> new IllegalStateException(string);
        };
    }

    protected class XmlAttributeImplDelegate
    extends XmlAttributeDelegate {
        public XmlAttributeImplDelegate() {
            super(XmlAttributeImpl.this);
        }
    }
}

