/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.simple.extend;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;

public class ReplacedElementScaleHelper {
    public static AffineTransform createScaleTransform(double dotsPerPixel, Rectangle contentBounds, float width, float height) {
        double intrinsicWidth = width;
        double intrinsicHeight = height;
        double desiredWidth = contentBounds.getWidth() / dotsPerPixel;
        double desiredHeight = contentBounds.getHeight() / dotsPerPixel;
        AffineTransform scale = null;
        if (width != 0.0f && height != 0.0f) {
            if (desiredWidth > intrinsicWidth || desiredHeight > intrinsicHeight) {
                double rw = desiredWidth / (double)width;
                double rh = desiredHeight / (double)height;
                double factor = Math.min(rw, rh);
                scale = AffineTransform.getScaleInstance(factor, factor);
            } else if (desiredWidth < intrinsicWidth && desiredHeight < intrinsicHeight) {
                double rw = desiredWidth / (double)width;
                double rh = desiredHeight / (double)height;
                double factor = Math.max(rw, rh);
                scale = AffineTransform.getScaleInstance(factor, factor);
            }
        }
        return scale;
    }

    public static AffineTransform inverseOrNull(AffineTransform in) {
        if (in == null) {
            return null;
        }
        try {
            return in.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return null;
        }
    }
}

