/*

luise.h
copyright by Wallbraun Electronics

libluise is freeware. it uses libusb and based on libftdi from intra2net.com .

*/


#ifndef __libluise_h__
#define __libluise_h__

#ifdef __cplusplus
extern "C" {
#endif

unsigned char  LUI_OpenDevice		(int DevNum);
unsigned char  LUI_CloseDevice		(int DevNum);
unsigned char  LUI_DispOnOff		(int DevNum, char onoff);
unsigned char  LUI_CCFL			(int DevNum, char onoff);
unsigned char  LUI_GetContrast		(int DevNum, unsigned char *cvalue);
unsigned char  LUI_SetContrast		(int DevNum, unsigned char cvalue);
unsigned char  LUI_OutPort		(int DevNum, unsigned char pvalue);
unsigned char  LUI_InPort		(int DevNum, unsigned char *pdaten);
unsigned char  LUI_LCDmode		(int DevNum, unsigned char gfxmode, unsigned char gfxinvert, unsigned char LCDorientation, unsigned char IOrefreshValue);
unsigned char  LUI_Bitmap		(int DevNum, unsigned char ScreenNr, int ScreenPosX, int ScreenPosY, int BMPoffsetX, int BMPoffsetY, int BMPWide, int BMPHigh, int BMPdataWide, int BMPdataHigh, unsigned char *Bild);
unsigned char  LUI_Text			(int DevNum, int ScreenPosX, int ScreenPosY, int TextFieldWide, int TextFieldHight, unsigned char transparency, char *FontFile, unsigned char WideSpace, unsigned char HightSpace, char *textdata);
unsigned char  LUI_TouchScreen		(int DevNum, int *TPdata);
unsigned char  LUI_BMPfile		(int DevNum, unsigned char ScreenNr, int ScreenPosX, int ScreenPosY, int BMPoffsetX, int BMPoffsetY, int BMPWide, int BMPHigh, char *file);
unsigned char  LUI_SetPixel		(int DevNum, unsigned char ScreenNr, int ScreenPosX, int ScreenPosY, char BitValue);
unsigned char  LUI_GetPixel		(int DevNum, unsigned char ScreenNr, int ScreenPosX, int ScreenPosY, char *BitValue);
int	       GetDllVersion		(void);
unsigned char  LUI_GetSerial		(int DevNum, unsigned int *serial);
unsigned char  LUI_ScreenRefreshControl	(int DevNum, unsigned char s0, unsigned char s1, unsigned char sTXT);

#ifdef __cplusplus
}
#endif

#endif

