/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.ModelSerializationFun;
import com.intellij.database.model.serialization.MutableNameAndValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_45;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "convertSequenceReferences", "convertRelations", "intellij.database.core.impl"})
@SourceDebugExtension(value={"SMAP\nConverter_4_45.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Converter_4_45.kt\ncom/intellij/database/model/serialization/converters/Converter_4_45\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,66:1\n1321#2,2:67\n*S KotlinDebug\n*F\n+ 1 Converter_4_45.kt\ncom/intellij/database/model/serialization/converters/Converter_4_45\n*L\n21#1:67,2\n*E\n"})
public final class Converter_4_45
extends Converter {
    @NotNull
    public static final Converter_4_45 INSTANCE = new Converter_4_45();

    private Converter_4_45() {
        int[] nArray = new int[]{4, 45};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        Object[] objectArray = new Dbms[]{Dbms.POSTGRES, Dbms.GREENPLUM, Dbms.COCKROACH};
        if (!ArraysKt.contains((Object[])objectArray, (Object)modelMem.getDbms())) {
            return;
        }
        this.convertSequenceReferences(modelMem);
        this.convertRelations(modelMem);
    }

    private final void convertSequenceReferences(ModelMem modelMem) {
        String columnCode = ObjectKind.COLUMN.code();
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)modelMem.getNodes()), arg_0 -> Converter_4_45.convertSequenceReferences$lambda$0(columnCode, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModelElementMem it = (ModelElementMem)element$iv;
            boolean bl = false;
            ModelSerializationFun.remove(it.getProperties(), "SequenceIdentity");
            MutableNameAndValue mutableNameAndValue = ModelSerializationFun.find(it.getProperties(), "BelongingSequenceId");
            if (mutableNameAndValue == null) continue;
            mutableNameAndValue.setName("SequenceId");
        }
    }

    private final void convertRelations(ModelMem modelMem) {
        HashMap relations = new HashMap();
        for (ModelElementMem node : modelMem.getNodes()) {
            Object object;
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)ObjectKind.DATABASE.code()) || (object = ModelSerializationFun.find(node.getProperties(), "Relations")) == null || (object = ((MutableNameAndValue)object).getValue()) == null) continue;
            Object relationsSerialized = object;
            for (String r : StringsKt.lineSequence((CharSequence)((CharSequence)relationsSerialized))) {
                String[] stringArray;
                List relFields = StringsKt.split$default((CharSequence)r, (String[])(stringArray = new String[]{"|"}), (boolean)false, (int)0, (int)6, null);
                if (relFields.size() != 5) continue;
                String seqId = (String)relFields.get(2);
                String tableId = (String)relFields.get(3);
                String colPos = (String)relFields.get(4);
                Pair key2 = TuplesKt.to((Object)tableId, (Object)colPos);
                ((Map)relations).put(key2, seqId);
            }
        }
        HashMap tables = new HashMap();
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)ObjectKind.TABLE.code())) continue;
            Integer n = node.getId();
            if (n == null) {
                continue;
            }
            int id = n;
            ((Map)tables).put(id, node);
        }
        for (ModelElementMem node : modelMem.getNodes()) {
            Object colPos;
            Pair key3;
            String seqId;
            ModelElementMem tableElement;
            Object object;
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)ObjectKind.COLUMN.code())) continue;
            Integer n = node.getParentId();
            if (n == null) {
                continue;
            }
            int parentId = n;
            if ((ModelElementMem)tables.get(parentId) == null || (object = ModelSerializationFun.find(tableElement.getProperties(), "ObjectId")) == null || (object = ((MutableNameAndValue)object).getValue()) == null) continue;
            Object tableId = object;
            Object object2 = ModelSerializationFun.find(node.getProperties(), "Position");
            if (object2 == null) continue;
            if ((object2 = ((MutableNameAndValue)object2).getValue()) == null || (seqId = (String)relations.get(key3 = TuplesKt.to((Object)tableId, (Object)(colPos = object2)))) == null) continue;
            node.getProperties().add(new MutableNameAndValue("SequenceId", seqId));
        }
    }

    private static final boolean convertSequenceReferences$lambda$0(String $columnCode, ModelElementMem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getKind(), (Object)$columnCode);
    }
}

