/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionInterceptor;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J,\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dataSource/NoCredentialsAuthProvider;", "Lcom/intellij/database/dataSource/DatabaseAuthProvider;", "<init>", "()V", "getId", "", "getDisplayName", "getApplicability", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel$Result;", "point", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "level", "Lcom/intellij/database/dataSource/DatabaseAuthProvider$ApplicabilityLevel;", "interceptConnection", "", "proto", "Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;", "silent", "(Lcom/intellij/database/dataSource/DatabaseConnectionInterceptor$ProtoConnection;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadAuthConfig", "", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "external", "saveAuthConfig", "", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "data", "Companion", "intellij.database.core.impl"})
public final class NoCredentialsAuthProvider
implements DatabaseAuthProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getId() {
        return "no-auth";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = DatabaseBundle.message("database.auth.type.no.auth", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Override
    @NotNull
    public DatabaseAuthProvider.ApplicabilityLevel.Result getApplicability(@NotNull DatabaseConnectionPoint point, @NotNull DatabaseAuthProvider.ApplicabilityLevel level) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return DatabaseAuthProvider.ApplicabilityLevel.Result.DEFAULT.clamp(level);
    }

    @Override
    @Nullable
    public Object interceptConnection(@NotNull DatabaseConnectionInterceptor.ProtoConnection proto, boolean silent, @NotNull Continuation<? super Boolean> $completion) {
        return Boxing.boxBoolean((boolean)true);
    }

    @Override
    @Nullable
    public Object loadAuthConfig(@NotNull DatabaseConnectionPoint point, @Nullable DatabaseCredentials credentials, boolean external) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return DatabaseAuthProvider.super.loadAuthConfig(point, credentials, external);
    }

    @Override
    public void saveAuthConfig(@NotNull DatabaseConnectionConfig config, @Nullable DatabaseCredentials credentials, @Nullable Object data, boolean external) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        DatabaseAuthProvider.super.saveAuthConfig(config, credentials, data, external);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lcom/intellij/database/dataSource/NoCredentialsAuthProvider$Companion;", "", "<init>", "()V", "isAuthRequired", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "any", "required", "intellij.database.core.impl"})
    @SourceDebugExtension(value={"SMAP\nNoCredentialsAuthProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoCredentialsAuthProvider.kt\ncom/intellij/database/dataSource/NoCredentialsAuthProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1761#2,3:49\n1740#2,3:52\n*S KotlinDebug\n*F\n+ 1 NoCredentialsAuthProvider.kt\ncom/intellij/database/dataSource/NoCredentialsAuthProvider$Companion\n*L\n44#1:49,3\n44#1:52,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAuthRequired(@NotNull LocalDataSource dataSource, boolean any, boolean required) {
            boolean bl;
            block10: {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                DatabaseDriver driver = dataSource.getDatabaseDriver();
                if (driver == null) {
                    return required;
                }
                List<StatelessJdbcUrlParser> list = driver.getJDBCUrlParsers();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getJDBCUrlParsers(...)");
                List<StatelessJdbcUrlParser> parsers = list;
                if (parsers.isEmpty()) {
                    return required;
                }
                Function1 condition = arg_0 -> Companion.isAuthRequired$lambda$0(required, arg_0);
                if (any) {
                    Iterable $this$any$iv = parsers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            if (!((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                            bl = true;
                            break block10;
                        }
                        bl = false;
                    }
                } else {
                    Iterable $this$all$iv = parsers;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            if (((Boolean)condition.invoke(element$iv)).booleanValue()) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
            }
            return bl;
        }

        private static final boolean isAuthRequired$lambda$0(boolean $required, StatelessJdbcUrlParser p2) {
            Intrinsics.checkNotNullParameter((Object)p2, (String)"p");
            return JdbcUrlParserUtil.isAuthSupported(p2) == $required;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

