/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.DatabaseAccessController;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.SearchPathReceiver;
import com.intellij.database.console.SearchPathSender;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.MutationsStorage;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TripleFunction;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleGridDataHookUp
extends DatabaseGridDataHookUp
implements SearchPathReceiver,
DataRequest.CrossSessionOwner {
    private static final Logger LOG = Logger.getInstance(ConsoleGridDataHookUp.class);
    private volatile AtomicReference<SearchPath> mySearchPath;
    private volatile DatabaseAccessController myController;
    private volatile DataRequest.OwnerEx myParent;
    private volatile boolean myValid;
    private volatile MyPathAuditor myPathAuditor;
    private volatile Disposable myTxParent;

    public ConsoleGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session, @NotNull DatabaseDepartment department, @NotNull SearchPathSender sender, @Nullable DataRequest.OwnerEx parent, @NotNull TripleFunction<Object, Object, GridDataHookUp<GridRow, GridColumn>, Boolean> valuesEqual, @Nullable Function<GridModel<GridRow, GridColumn>, MutationsStorage> storageProvider) {
        if (project == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(1);
        }
        if (department == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(2);
        }
        if (sender == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(3);
        }
        if (valuesEqual == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(4);
        }
        super(project, session, department, valuesEqual, storageProvider);
        this.myParent = parent;
        this.updateTxParent();
        this.updatePathAuditor(session);
        sender.subscribe(this);
        this.createController(session);
    }

    @NotNull
    public Disposable getTxDisposable() {
        Disposable disposable = this.myTxParent;
        if (disposable == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(5);
        }
        return disposable;
    }

    @NotNull
    public DataRequest.Owner getParentOwner() {
        DatabaseSession databaseSession = this.getSession();
        if (databaseSession == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(6);
        }
        return databaseSession;
    }

    @Override
    public boolean isChildOf(@NotNull DataRequest.Owner owner) {
        if (owner == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(7);
        }
        return this.myParent != null && this.myParent.isChildOf(owner) || super.isChildOf(owner);
    }

    @Override
    @NotNull
    protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
        return new MyLoader();
    }

    public void setParent(@Nullable DataRequest.OwnerEx parent) {
        this.myParent = parent;
        if (parent instanceof SearchPathReceiver.Listener) {
            ((SearchPathReceiver.Listener)parent).addSearchPathReceiver(this, this);
        }
    }

    @Override
    public void setSession(@NotNull DatabaseSession session) {
        if (session == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(8);
        }
        super.setSession(session);
        Disposer.dispose((Disposable)this.myPathAuditor);
        this.updatePathAuditor(session);
        this.updateTxParent();
        this.createController(session);
    }

    public boolean isValid() {
        return this.myValid;
    }

    @Override
    public void receive(@Nullable SearchPath path) {
        this.validate(path, false);
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath == null ? null : this.mySearchPath.get();
    }

    @Override
    @NotNull
    protected DataAuditor createAuditor() {
        return new MyBusAuditor();
    }

    private void updatePathAuditor(@NotNull DatabaseSession session) {
        if (session == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(9);
        }
        this.myPathAuditor = new MyPathAuditor();
        Disposer.register((Disposable)this, (Disposable)this.myPathAuditor);
        session.getMessageBus().addAuditor((DataAuditor)this.myPathAuditor);
    }

    private void createController(@NotNull DatabaseSession session) {
        if (session == null) {
            ConsoleGridDataHookUp.$$$reportNull$$$0(10);
        }
        this.myController = new DatabaseAccessController.PsiBasedReadOnly(this.getProject(), DbSqlUtilCore.getLanguage((LocalDataSource)((DatabaseConnectionPoint)session.getTarget()).getDataSource()), this.getDataSource(), () -> this.mySearchPath.get());
    }

    private void validate(@Nullable SearchPath path, boolean supportSavepoints) {
        this.myValid = this.isStateValid(path, supportSavepoints);
    }

    private boolean isStateValid(@Nullable SearchPath path, boolean supportsSavepoints) {
        if (this.mySearchPath == null) {
            LOG.debug("My search path reference is null");
            return false;
        }
        if (Comparing.equal((Object)this.mySearchPath.get(), (Object)path)) {
            return true;
        }
        if (this.mySearchPath.get() == null || path == null) {
            LOG.debug(this.mySearchPath.get() == null ? "My path is null" : "Current path is null");
            return false;
        }
        DbDataSource dbDataSource = this.getDataSource();
        RawDataSource rawDataSource = dbDataSource.getDelegate();
        if (!(rawDataSource instanceof DatabaseConnectionPoint)) {
            LOG.debug("Delegate is not instance of connection point: " + dbDataSource.getDelegate().getClass().getName());
            return false;
        }
        DatabaseConnectionPoint point = (DatabaseConnectionPoint)rawDataSource;
        DatabaseDriver driver = point.getDatabaseDriver();
        boolean readOnly = point.isReadOnly();
        ObjectPath current = path.getCurrent();
        ObjectPath needed = this.mySearchPath.get().getCurrent();
        if (JdbcUrlParserUtil.outOfBounds((DatabaseDriver)driver, (boolean)readOnly, (ObjectPath)current, (ObjectPath)needed)) {
            LOG.debug("Database changed");
            return false;
        }
        DataRequest.TxMarker tx = this.getCurrentTx();
        return supportsSavepoints || !tx.isTransactionInProgress();
    }

    private void updateTxParent() {
        if (this.myTxParent != null) {
            Disposer.dispose((Disposable)this.myTxParent);
        }
        this.myTxParent = Disposer.newDisposable();
        Disposer.register((Disposable)this, (Disposable)this.myTxParent);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesEqual";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/ConsoleGridDataHookUp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTxDisposable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentOwner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isChildOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSession";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatePathAuditor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createController";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }

    private class MyLoader
    extends DatabaseGridDataHookUp.DatabaseLoader {
        private MyLoader() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        public void setColumns(@NotNull GridDataRequest.Context context, int subQueryIndex, int resultSetIndex, GridColumn @NotNull [] columns, int firstRowNum) {
            if (context == null) {
                MyLoader.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                MyLoader.$$$reportNull$$$0(1);
            }
            super.setColumns(context, subQueryIndex, resultSetIndex, columns, firstRowNum);
            DataRequest.Context c2 = (DataRequest.Context)ObjectUtils.tryCast((Object)context, DataRequest.Context.class);
            if (c2 != null) {
                ConsoleGridDataHookUp.this.mySearchPath = new AtomicReference<SearchPath>(c2.getSearchPath());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columns";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyLoader";
            objectArray[2] = "setColumns";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPathAuditor
    implements DataAuditor,
    Disposable {
        private MyPathAuditor() {
        }

        public void requestFinished(@NotNull DataRequest.Context context) {
            if (context == null) {
                MyPathAuditor.$$$reportNull$$$0(0);
            }
            Boolean supportSavepoints = (Boolean)JdbcEngine.SUPPORTS_SAVEPOINTS_KEY.get((UserDataHolder)context);
            ConsoleGridDataHookUp.this.validate(context.getSearchPath(), supportSavepoints != null && supportSavepoints != false);
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/ConsoleGridDataHookUp$MyPathAuditor", "requestFinished"));
        }
    }

    private class MyBusAuditor
    extends DataBusGridDataHookUp.BusAuditor {
        private MyBusAuditor() {
            super(ConsoleGridDataHookUp.this);
        }

        @Override
        protected boolean reloadOnRollback() {
            DbDataSource source = ConsoleGridDataHookUp.this.getDataSource();
            if (!source.isWritable()) {
                return true;
            }
            String query = ConsoleGridDataHookUp.this.getQueryText();
            return StringUtil.isEmptyOrSpaces((String)query) || ConsoleGridDataHookUp.this.myController.requestAccess((String)query).success;
        }
    }
}

