/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.run.producer;

import com.intellij.database.console.runConfiguration.DatabaseScriptRunConfiguration;
import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.dbt.run.DbtRunConfiguration;
import com.intellij.dbt.run.DbtRunConfigurationKt;
import com.intellij.dbt.run.DbtRunConfigurationType;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.jinja.template.psi.impl.DjangoTemplateFileImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlFileType;
import com.intellij.sql.psi.SqlLanguage;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H&J&\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/dbt/run/producer/DbtBaseRunConfigurationProducer;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "Lcom/intellij/dbt/run/DbtRunConfiguration;", "dbtCommand", "Lcom/intellij/dbt/console/commands/DbtCommand;", "<init>", "(Lcom/intellij/dbt/console/commands/DbtCommand;)V", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "shouldReplace", "", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "isConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "acceptLocation", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtRunConfigurationProducer.kt\ncom/intellij/dbt/run/producer/DbtBaseRunConfigurationProducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n295#2,2:84\n*S KotlinDebug\n*F\n+ 1 DbtRunConfigurationProducer.kt\ncom/intellij/dbt/run/producer/DbtBaseRunConfigurationProducer\n*L\n60#1:84,2\n*E\n"})
public abstract class DbtBaseRunConfigurationProducer
extends LazyRunConfigurationProducer<DbtRunConfiguration> {
    @NotNull
    private final DbtCommand dbtCommand;

    public DbtBaseRunConfigurationProducer(@NotNull DbtCommand dbtCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)dbtCommand), (String)"dbtCommand");
        this.dbtCommand = dbtCommand;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        return DbtRunConfigurationType.Companion.getInstance().getFactory();
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return self.getConfiguration() instanceof DbtRunConfiguration && other.getConfiguration() instanceof DatabaseScriptRunConfiguration;
    }

    public boolean isConfigurationFromContext(@NotNull DbtRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getModule() == null || !DbtUtils.Companion.isDbtModule(context.getModule())) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null || (location = location.getVirtualFile()) == null) {
            return false;
        }
        Location file = location;
        if (!Intrinsics.areEqual((Object)configuration.getConfigurationModule().getModule(), (Object)context.getModule())) {
            return false;
        }
        if (!configuration.isForFile((VirtualFile)file)) {
            return false;
        }
        if (configuration.getDbtCommand() == this.dbtCommand) {
            return true;
        }
        return configuration.getDbtCommand() == DbtCommand.BUILD && this.dbtCommand == DbtCommand.RUN;
    }

    public abstract boolean acceptLocation(@NotNull PsiFile var1, @NotNull Module var2);

    protected boolean setupConfigurationFromContext(@NotNull DbtRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        PsiFile psiFile = ((PsiElement)sourceElement.get()).getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        Module module = context.getModule();
        if (module == null) {
            return false;
        }
        Module module2 = module;
        if (!this.acceptLocation(file, module2)) {
            return false;
        }
        if (file instanceof DjangoTemplateFileImpl) {
            Object v3;
            block8: {
                Set set = ((DjangoTemplateFileImpl)file).getViewProvider().getLanguages();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getLanguages(...)");
                Iterable $this$firstOrNull$iv = set;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Language it = (Language)element$iv;
                    boolean bl = false;
                    if (!it.isKindOf((Language)SqlLanguage.INSTANCE)) continue;
                    v3 = element$iv;
                    break block8;
                }
                v3 = null;
            }
            Language language = v3;
            if (language == null) {
                return false;
            }
            Language sqlDialect = language;
            PsiFile psiFile2 = ((DjangoTemplateFileImpl)file).getViewProvider().getPsi(sqlDialect);
            if (psiFile2 == null) {
                return false;
            }
            file = psiFile2;
        }
        if (!Intrinsics.areEqual((Object)file.getFileType(), (Object)SqlFileType.INSTANCE)) {
            return false;
        }
        configuration.setName(this.dbtCommand.getCommandName() + ": " + file.getName());
        configuration.setModule(context.getModule());
        configuration.setDbtCommand(this.dbtCommand);
        Object[] objectArray = new String[2];
        objectArray[0] = DbtRunConfigurationKt.getDBT_COMMAND_ARGUMENT_SELECT();
        Intrinsics.checkNotNullExpressionValue((Object)file.getName(), (String)"getName(...)");
        configuration.setDbtArguments(CollectionsKt.listOf((Object[])objectArray));
        return true;
    }
}

