/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.bridge;

import java.awt.font.FontRenderContext;
import java.text.AttributedCharacterIterator;
import org.jetbrains.relocated.apache.batik.bridge.BridgeContext;
import org.jetbrains.relocated.apache.batik.bridge.SVGAltGlyphElementBridge;
import org.jetbrains.relocated.apache.batik.gvt.font.AltGlyphHandler;
import org.jetbrains.relocated.apache.batik.gvt.font.GVTGlyphVector;
import org.jetbrains.relocated.apache.batik.gvt.font.Glyph;
import org.jetbrains.relocated.apache.batik.gvt.font.SVGGVTGlyphVector;
import org.jetbrains.relocated.apache.batik.util.SVGConstants;
import org.w3c.dom.Element;

public class SVGAltGlyphHandler
implements AltGlyphHandler,
SVGConstants {
    private BridgeContext ctx;
    private Element textElement;

    public SVGAltGlyphHandler(BridgeContext ctx2, Element textElement) {
        this.ctx = ctx2;
        this.textElement = textElement;
    }

    @Override
    public GVTGlyphVector createGlyphVector(FontRenderContext frc, float fontSize, AttributedCharacterIterator aci) {
        try {
            SVGAltGlyphElementBridge altGlyphBridge;
            Glyph[] glyphArray;
            if ("http://www.w3.org/2000/svg".equals(this.textElement.getNamespaceURI()) && "altGlyph".equals(this.textElement.getLocalName()) && (glyphArray = (altGlyphBridge = (SVGAltGlyphElementBridge)this.ctx.getBridge(this.textElement)).createAltGlyphArray(this.ctx, this.textElement, fontSize, aci)) != null) {
                return new SVGGVTGlyphVector(null, glyphArray, frc);
            }
        }
        catch (SecurityException e) {
            this.ctx.getUserAgent().displayError(e);
            throw e;
        }
        return null;
    }
}

