/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.psi.PsiPuppetHashArgument;
import com.intellij.lang.puppet.psi.PsiPuppetResourceDeclaration;
import com.intellij.lang.puppet.psi.PsiPuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.PsiPuppetVisitor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public class PuppetMultipleHashSetParamsPerResourceInstanceInspection
extends LocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(PuppetMultipleHashSetParamsPerResourceInstanceInspection.class);
    private static final Key<Map<PsiElement, PsiPuppetHashArgument>> RESOURCE_TO_PARAM_KEY = Key.create((String)"NUM_OF_PARAMS");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, final @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(1);
        }
        session.putUserDataIfAbsent(RESOURCE_TO_PARAM_KEY, new ConcurrentHashMap(1, 0.75f, 1));
        return new PsiPuppetVisitor(){

            @Override
            public void visitHashArgument(@NotNull PsiPuppetHashArgument hashParam) {
                PsiElement enclosingResource;
                if (hashParam == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((enclosingResource = PsiTreeUtil.getParentOfType((PsiElement)hashParam, (Class[])new Class[]{PsiPuppetResourceDeclaration.class, PsiPuppetResourceInstanceDeclaration.class})) == null) {
                    LOG.error("Enclosing resource expected: " + PuppetMultipleHashSetParamsPerResourceInstanceInspection.dumpParents(hashParam));
                    return;
                }
                Map data = (Map)session.getUserData(RESOURCE_TO_PARAM_KEY);
                LOG.assertTrue(data != null);
                PsiPuppetHashArgument oldValue = (PsiPuppetHashArgument)data.get(enclosingResource);
                if (oldValue != null && oldValue != hashParam) {
                    PuppetMultipleHashSetParamsPerResourceInstanceInspection.register(holder, hashParam);
                    PuppetMultipleHashSetParamsPerResourceInstanceInspection.register(holder, oldValue);
                } else {
                    data.put(enclosingResource, hashParam);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashParam", "com/intellij/lang/puppet/ide/inspections/PuppetMultipleHashSetParamsPerResourceInstanceInspection$1", "visitHashArgument"));
            }
        };
    }

    @NotNull
    private static String dumpParents(@NotNull PsiElement run) {
        if (run == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder();
        while (run != null) {
            sb.append(run.getClass().getSimpleName()).append("\n\t");
            if (run instanceof PsiFile) break;
            run = run.getParent();
        }
        String string = sb.toString();
        if (string == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void register(@NotNull ProblemsHolder holder, @NotNull PsiPuppetHashArgument hashParam) {
        if (holder == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(4);
        }
        if (hashParam == null) {
            PuppetMultipleHashSetParamsPerResourceInstanceInspection.$$$reportNull$$$0(5);
        }
        holder.registerProblem((PsiElement)hashParam, PuppetBundle.message("inspections.multiple.hash.param.description", new Object[0]), new LocalQuickFix[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "run";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/inspections/PuppetMultipleHashSetParamsPerResourceInstanceInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashParam";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/inspections/PuppetMultipleHashSetParamsPerResourceInstanceInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpParents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dumpParents";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

