/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.manage;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.commandInterface.command.Command;
import com.intellij.commandInterface.command.CommandExecutor;
import com.intellij.commandInterface.command.Help;
import com.intellij.commandInterface.command.NoArgumentsInfo;
import com.intellij.commandInterface.command.SimpleCommand;
import com.intellij.openapi.module.Module;
import com.intellij.python.django.manage.DjangoConsoleExecutor;
import com.intellij.python.django.manage.DjangoManageCommandType;
import com.intellij.python.django.manage.DjangoStatisticsCommandWrapper;
import com.intellij.python.django.manage.FailedToProvideCommandsException;
import com.intellij.python.django.manage.RealCommandsProvider;
import com.intellij.python.django.manage.SpecialCaseCommandsProvider;
import com.intellij.python.django.manage.SpecialCaseInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class DjangoManageCommandsApi {
    private static final SimpleCommand[] SPECIAL_COMMANDS = new SimpleCommand[]{new SimpleCommand(DjangoManageCommandType.VERSION.getCommandName(), new Help("Show Django version"), NoArgumentsInfo.INSTANCE, DjangoConsoleExecutor.INSTANCE, Collections.emptyList())};

    private DjangoManageCommandsApi() {
    }

    @NotNull
    public static Collection<Command> getCommands(@NotNull Module module, @NotNull Consumer<String> errorStream) throws FailedToProvideCommandsException {
        if (module == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(0);
        }
        if (errorStream == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(1);
        }
        Collection collection = DjangoManageCommandsApi.wrapWithDjangoStatistics(Stream.concat(Collections2.transform(RealCommandsProvider.getCommands(module, errorStream), (Function)new CommandsTransformer(new SpecialCaseCommandsProvider(module))).stream(), Arrays.stream(SPECIAL_COMMANDS))).collect(Collectors.toList());
        if (collection == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private static Stream<Command> wrapWithDjangoStatistics(Stream<Command> commands) {
        return commands.map(DjangoStatisticsCommandWrapper::new);
    }

    @NotNull
    public static CommandExecutor getDefaultExecutor() {
        CommandExecutor commandExecutor = DjangoConsoleExecutor.INSTANCE;
        if (commandExecutor == null) {
            DjangoManageCommandsApi.$$$reportNull$$$0(3);
        }
        return commandExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorStream";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/manage/DjangoManageCommandsApi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/manage/DjangoManageCommandsApi";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommands";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCommands";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class CommandsTransformer
    implements Function<SimpleCommand, SimpleCommand> {
        @NotNull
        private final SpecialCaseCommandsProvider myProvider;

        CommandsTransformer(@NotNull SpecialCaseCommandsProvider provider) {
            if (provider == null) {
                CommandsTransformer.$$$reportNull$$$0(0);
            }
            this.myProvider = provider;
        }

        public SimpleCommand apply(SimpleCommand input) {
            SpecialCaseInfo specialCaseInfo = this.myProvider.getSpecialCaseInfo(input.getName());
            if (specialCaseInfo != null) {
                return specialCaseInfo.apply(input);
            }
            return input;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/python/django/manage/DjangoManageCommandsApi$CommandsTransformer", "<init>"));
        }
    }
}

