/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.utils.EelProcessExecutionResultInfo;
import com.intellij.platform.eel.provider.utils.EelProcessUtilsKt;
import com.jetbrains.python.errorProcessing.ExecError;
import com.jetbrains.python.errorProcessing.ExecErrorReason;
import com.jetbrains.python.errorProcessing.MessageError;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.PyExecutionException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u00a8\u0006\u0006"}, d2={"copyWith", "Lcom/jetbrains/python/packaging/PyExecutionException;", "newCommand", "", "newArgs", "", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nPyExecutionExceptionExt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyExecutionExceptionExt.kt\ncom/jetbrains/python/packaging/PyExecutionExceptionExtKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,34:1\n37#2:35\n36#2,3:36\n*S KotlinDebug\n*F\n+ 1 PyExecutionExceptionExt.kt\ncom/jetbrains/python/packaging/PyExecutionExceptionExtKt\n*L\n25#1:35\n25#1:36,3\n*E\n"})
public final class PyExecutionExceptionExtKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final PyExecutionException copyWith(@NotNull PyExecutionException $this$copyWith, @NotNull String newCommand, @NotNull List<String> newArgs) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$copyWith), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newCommand, (String)"newCommand");
        Intrinsics.checkNotNullParameter(newArgs, (String)"newArgs");
        PyError err = $this$copyWith.getPyError();
        if (err instanceof ExecError) {
            PyExecutionException pyExecutionException;
            ExecErrorReason reason = ((ExecError)err).getErrorReason();
            if (reason instanceof ExecErrorReason.CantStart) {
                pyExecutionException = new PyExecutionException(new IOException(((ExecErrorReason.CantStart)reason).getCantExecProcessError()), err.getMessage(), newCommand, newArgs, $this$copyWith.getFixes());
                return pyExecutionException;
            } else if (Intrinsics.areEqual((Object)reason, (Object)ExecErrorReason.Timeout.INSTANCE)) {
                Path path2 = Paths.get(newCommand, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                Collection $this$toTypedArray$iv = newArgs;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                PyExecutionException pyExecutionException2 = new PyExecutionException(new ExecError(EelNioBridgeServiceKt.asEelPath((Path)path2), thisCollection$iv.toArray(new String[0]), ExecErrorReason.Timeout.INSTANCE, err.getMessage()), null, 2, null);
                pyExecutionException = pyExecutionException2;
                return pyExecutionException;
            } else {
                if (!(reason instanceof ExecErrorReason.UnexpectedProcessTermination)) throw new NoWhenBranchMatchedException();
                ProcessOutput output2 = new ProcessOutput(EelProcessUtilsKt.getStdoutString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)reason)), EelProcessUtilsKt.getStderrString((EelProcessExecutionResultInfo)((EelProcessExecutionResultInfo)reason)), ((ExecErrorReason.UnexpectedProcessTermination)reason).getExitCode(), false, false);
                pyExecutionException = new PyExecutionException(err.getMessage(), newCommand, newArgs, output2, $this$copyWith.getFixes());
            }
            return pyExecutionException;
        } else {
            if (!(err instanceof MessageError)) throw new NoWhenBranchMatchedException();
            throw new IllegalStateException(("Error " + err.getMessage() + " has no command, command can't be changed").toString());
        }
    }
}

