/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.gitlab.ultimate.features.codeInsight.variables;

import com.intellij.markdown.utils.MarkdownToHtmlConverterKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.vcs.gitlab.ultimate.features.codeInsight.variables.GitLabCiEnvVarsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownParsingException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u001e\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0002\"\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"extractPredefinedVariablesData", "Lcom/intellij/vcs/gitlab/ultimate/features/codeInsight/variables/GitLabCiEnvVarsData;", "rawText", "", "extractPredefinedVariablesWithAvailability", "", "extractPredefinedVariablesWithoutAvailability", "parseDescriptionToHtmlOrNull", "markdownDescription", "internalMarkdownLinksRegex", "Lkotlin/text/Regex;", "replaceInternalMarkdownLinksWithPlaneText", "intellij.vcs.gitlab.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nGitLabCiEnvVarsUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabCiEnvVarsUtils.kt\ncom/intellij/vcs/gitlab/ultimate/features/codeInsight/variables/GitLabCiEnvVarsUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1563#2:108\n1634#2,3:109\n1563#2:112\n1634#2,3:113\n*S KotlinDebug\n*F\n+ 1 GitLabCiEnvVarsUtils.kt\ncom/intellij/vcs/gitlab/ultimate/features/codeInsight/variables/GitLabCiEnvVarsUtilsKt\n*L\n32#1:108\n32#1:109,3\n63#1:112\n63#1:113,3\n*E\n"})
public final class GitLabCiEnvVarsUtilsKt {
    @NotNull
    private static final Regex internalMarkdownLinksRegex = new Regex("\\[([^]]+)]\\((?!https?://)[^)]+\\)");

    @NotNull
    public static final GitLabCiEnvVarsData extractPredefinedVariablesData(@NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Map name2Documentation = MapsKt.plus(GitLabCiEnvVarsUtilsKt.extractPredefinedVariablesWithAvailability(rawText), GitLabCiEnvVarsUtilsKt.extractPredefinedVariablesWithoutAvailability(rawText));
        return new GitLabCiEnvVarsData(name2Documentation);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> extractPredefinedVariablesWithAvailability(@NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Map name2Documentation = new LinkedHashMap();
        Regex tableRegex = new Regex("\\|\\s+Variable\\s+\\|\\s+Availability\\s*\\|\\s+Description\\s*\\|\\n\\|[-| ]+\\|\\n(.+?)(?=\\n\\n|\\z)", RegexOption.DOT_MATCHES_ALL);
        for (MatchResult tableMatch = Regex.find$default((Regex)tableRegex, (CharSequence)rawText, (int)0, (int)2, null); tableMatch != null; tableMatch = tableMatch.next()) {
            List rows = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)((String)tableMatch.getGroupValues().get(1)))).toString());
            for (String row : rows) {
                String variable;
                void $this$mapTo$iv$iv;
                String[] stringArray = new String[]{"|"};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)row, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                List columns = (List)destination$iv$iv;
                if (columns.size() != 5) continue;
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.unquoteString((String)((String)columns.get(1)), (char)'`'), (String)"unquoteString(...)");
                String availability = (String)columns.get(2);
                String description = (String)columns.get(3);
                String markdownDoc = description + "\n\nAvailability: `" + availability + "`";
                name2Documentation.put(variable, GitLabCiEnvVarsUtilsKt.parseDescriptionToHtmlOrNull(markdownDoc));
            }
        }
        return name2Documentation;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> extractPredefinedVariablesWithoutAvailability(@NotNull String rawText) {
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Map name2Documentation = new LinkedHashMap();
        Regex tableRegex = new Regex("\\|\\s+Variable\\s+\\|\\s+Description\\s*\\|\\n\\|[-| ]+\\|\\n(.+?)(?=\\n\\n|\\z)", RegexOption.DOT_MATCHES_ALL);
        for (MatchResult tableMatch = Regex.find$default((Regex)tableRegex, (CharSequence)rawText, (int)0, (int)2, null); tableMatch != null; tableMatch = tableMatch.next()) {
            List rows = StringsKt.lines((CharSequence)((Object)StringsKt.trim((CharSequence)((String)tableMatch.getGroupValues().get(1)))).toString());
            for (String row : rows) {
                String variable;
                void $this$mapTo$iv$iv;
                String[] stringArray = new String[]{"|"};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)row, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                List columns = (List)destination$iv$iv;
                if (columns.size() != 4) continue;
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.unquoteString((String)((String)columns.get(1)), (char)'`'), (String)"unquoteString(...)");
                String description = (String)columns.get(2);
                name2Documentation.put(variable, GitLabCiEnvVarsUtilsKt.parseDescriptionToHtmlOrNull(description));
            }
        }
        return name2Documentation;
    }

    private static final String parseDescriptionToHtmlOrNull(String markdownDescription) {
        try {
            String refinedMarkdownDescription = GitLabCiEnvVarsUtilsKt.replaceInternalMarkdownLinksWithPlaneText(markdownDescription);
            return MarkdownToHtmlConverterKt.convertMarkdownToHtml((String)refinedMarkdownDescription);
        }
        catch (MarkdownParsingException e) {
            Logger.getInstance((String)"com.intellij.vcs.gitlab.ultimate.features.codeInsight.variables.GitLabCiPredefinedVariablesUtilsKt").warn((Throwable)e);
            return null;
        }
    }

    private static final String replaceInternalMarkdownLinksWithPlaneText(String markdownDescription) {
        CharSequence charSequence = markdownDescription;
        Regex regex = internalMarkdownLinksRegex;
        Function1 function1 = GitLabCiEnvVarsUtilsKt::replaceInternalMarkdownLinksWithPlaneText$lambda$2;
        return regex.replace(charSequence, function1);
    }

    private static final CharSequence replaceInternalMarkdownLinksWithPlaneText$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (CharSequence)it.getGroupValues().get(1);
    }
}

