/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.javascript.advancedSettings.JSAdvancedSettingsKt;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.psi.JSClassExpression;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSNumberParser;
import com.intellij.lang.javascript.JSStringLiteralLexer;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptParserBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.dialects.JSLanguageLevelDetector;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.frameworks.extjs.ExtXTypeReference;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lang.javascript.inspections.JSFileReferencesInspection;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionProperty;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.JSWithClause;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.resolve.ImplicitJSVariableImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.DuplicatesCheckUtil;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.JSNavigateToAlreadyDeclaredVariableFix;
import com.intellij.lang.javascript.validation.JSValidateExpressionUtil;
import com.intellij.lang.javascript.validation.fixes.ChangeLanguageLevelFix;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class JSAnnotatingVisitor
extends JSElementVisitor {
    private static final String OCTAL_SEQUENCE_START = "\\0";
    private static final String EVAL_FUNCTION_NAME = "eval";
    public static final String VOID_TYPE_NAME = "void";
    @NotNull
    protected final AnnotationHolder myHolder;
    @NotNull
    protected final JSAnnotatorProblemReporter myProblemReporter;
    @NotNull
    protected final JSHighlighter myHighlighter;

    public JSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(1);
        }
        this.myHolder = holder;
        this.myHighlighter = JSAnnotatingVisitor.getHighlighter(psiElement);
        this.myProblemReporter = this.createProblemReporter(psiElement);
    }

    @NotNull
    public static JSHighlighter getHighlighter(PsiElement psiElement) {
        return JSAnnotatingVisitor.getHighlighter(DialectDetector.languageOfElement(psiElement));
    }

    @NotNull
    public static JSHighlighter getHighlighter(@NotNull Language dialect) {
        if (dialect == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(2);
        }
        return dialect instanceof JSLanguageDialect ? (JSHighlighter)SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null) : new JSHighlighter(JavascriptLanguage.INSTANCE.getOptionHolder());
    }

    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context2) {
        return new JSAnnotatorProblemReporter(this.myHolder);
    }

    @NotNull
    protected JSConstructorChecker createConstructorChecker() {
        return new JSConstructorChecker(this.myProblemReporter);
    }

    public void visitElement(@NotNull PsiElement element2) {
        IElementType namedElementType;
        JSNamedElement namedElement;
        IElementType elementType;
        if (element2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(3);
        }
        if (JSKeywordSets.IDENTIFIER_NAMES.contains(elementType = element2.getNode().getElementType()) && (namedElement = JSPsiImplUtils.findElementFromNameIdentifier(element2)) instanceof JSFunction && JSElementTypes.FUNCTION_DECLARATIONS.contains(namedElementType = namedElement.getNode().getElementType())) {
            this.checkFunctionDeclaration((JSFunction)namedElement, element2);
        }
        if (elementType == JSTokenTypes.COMMA) {
            PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)element2);
            if (prev instanceof JSParameterListElement) {
                if (((JSParameterListElement)prev).isRest()) {
                    this.validateCommaPlacement(element2, JSTokenTypes.RPAR, "javascript.validation.message.comma.is.not.allowed.after.rest.element");
                } else {
                    DialectOptionHolder dialect = DialectDetector.dialectOfElement(prev);
                    if (dialect != null && dialect.isJavaScript() && !dialect.isECMA6) {
                        this.validateCommaPlacement(element2, JSTokenTypes.RPAR, "javascript.validation.message.comma.is.not.allowed.after.last.parameter");
                    }
                }
            }
            if (prev instanceof JSDestructuringArrayRestElement) {
                this.validateCommaPlacement(element2, JSTokenTypes.RBRACKET, "javascript.validation.message.comma.is.not.allowed.after.rest.element");
            }
            if (prev instanceof JSDestructuringProperty && ((JSDestructuringProperty)prev).isRest()) {
                this.validateCommaPlacement(element2, JSTokenTypes.RBRACE, "javascript.validation.message.comma.is.not.allowed.after.rest.element");
            }
        }
        super.visitElement(element2);
    }

    @Override
    public void visitJSBinaryExpression(@NotNull JSBinaryExpression node) {
        ASTNode operationNode;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(4);
        }
        if ((operationNode = node.getOperationNode()) != null && (operationNode.getElementType() == JSTokenTypes.QUEST_QUEST || operationNode.getElementType() == JSTokenTypes.QUEST_QUEST_EQ)) {
            this.checkElementInCurrentLanguageLevel(operationNode.getPsi(), JSLanguageFeature.NULLISH_COALESCING);
        }
        super.visitJSBinaryExpression(node);
    }

    @Override
    public void visitJSLiteralExpression(@NotNull JSLiteralExpression node) {
        JSLiteralExpressionKind expressionKind;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(5);
        }
        if (node.isQuotedLiteral()) {
            this.checkReferences((PsiElement)node);
        }
        if ((expressionKind = node.getExpressionKind(true)) == JSLiteralExpressionKind.OCT || expressionKind.isBin()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BINARY_AND_OCTAL_LITERALS);
        } else if (expressionKind.isBigInteger()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.BIG_INT);
        } else if (expressionKind == JSLiteralExpressionKind.QUOTED) {
            IElementType tokenType;
            boolean checkUnicodeEscapesWithBraces;
            boolean checkOctalLiteral = node.textContains('0') && JSResolveUtil.isEcmaScript5((PsiElement)node);
            boolean allowsUnicodeEscapesWithBraces = DialectDetector.isJavaScriptFamily((PsiElement)node);
            boolean bl = checkUnicodeEscapesWithBraces = allowsUnicodeEscapesWithBraces && node.textContains('{');
            if (!checkOctalLiteral && !checkUnicodeEscapesWithBraces) {
                return;
            }
            String text = node.getText();
            if (!(checkOctalLiteral &= text.contains(OCTAL_SEQUENCE_START)) && !(checkUnicodeEscapesWithBraces &= text.contains("\\u{"))) {
                return;
            }
            JSStringLiteralLexer literalLexer = new JSStringLiteralLexer(text.charAt(0), node.getNode().getFirstChildNode().getElementType(), "/v", true, allowsUnicodeEscapesWithBraces, text.charAt(0) == '`');
            literalLexer.start((CharSequence)text);
            int literalStart = node.getTextOffset();
            while ((tokenType = literalLexer.getTokenType()) != null) {
                int end;
                int start;
                if (checkUnicodeEscapesWithBraces && tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN && literalLexer.getTokenText().startsWith("\\u{")) {
                    TextRange errorRange = new TextRange(literalStart + literalLexer.getTokenStart(), literalStart + literalLexer.getTokenEnd());
                    this.checkElementInCurrentLanguageLevel((PsiElement)node, errorRange, JSLanguageFeature.UNICODE_ESCAPES_WITH_BRACES);
                    String tokenText = literalLexer.getTokenText();
                    Double numericValue = JSNumberParser.tryParseNumericValue("0x" + tokenText.substring(3, tokenText.length() - 1), false);
                    if (numericValue != null && (numericValue < 0.0 || numericValue > 1114111.0)) {
                        this.myProblemReporter.registerProblem(null, new TextRange(errorRange.getStartOffset() + 3, errorRange.getEndOffset() - 1), JavaScriptBundle.message("javascript.invalid.extended.unicode.escape", new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                    }
                }
                if (checkOctalLiteral && (tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || tokenType == StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN) && CharArrayUtil.indexOf((CharSequence)text, (CharSequence)OCTAL_SEQUENCE_START, (int)(start = literalLexer.getTokenStart()), (int)(end = literalLexer.getTokenEnd())) == start && end - start > 2) {
                    TextRange errorRange = new TextRange(literalStart + start, literalStart + end);
                    this.myProblemReporter.registerProblem(null, errorRange, JavaScriptBundle.message("javascript.octal.sequences.are.not.allowed.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                }
                literalLexer.advance();
            }
        }
    }

    protected ProblemHighlightType getHighlightTypeForTypeOrSignatureProblem(@NotNull PsiElement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(6);
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    protected boolean checkReferences(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(7);
        }
        return this.checkReferences(element2, null);
    }

    protected boolean checkReferences(PsiElement element2, @Nullable ProblemHighlightType problemHighlightType) {
        if (element2 instanceof JSXmlLiteralExpression) {
            return true;
        }
        if (JSFileReferencesInspection.hasImportReferences(element2)) {
            return true;
        }
        boolean ok = true;
        for (PsiReference ref2 : element2.getReferences()) {
            if (ref2.isSoft() || ref2 instanceof ExtXTypeReference) continue;
            if (ref2 instanceof PsiPolyVariantReference) {
                ok &= this.checkReference(problemHighlightType, (PsiPolyVariantReference)ref2);
            } else if (JSAdvancedSettingsKt.isAdvancedAnnotatorEnabled(element2) && ref2.resolve() == null) {
                ok = false;
                this.registerProblemForReference(ref2, null, problemHighlightType);
            }
            if (DialectDetector.isTypeScript(element2) && !ok) break;
        }
        return ok;
    }

    protected boolean checkReference(@Nullable ProblemHighlightType problemHighlightType, @NotNull PsiPolyVariantReference ref2) {
        ResolveResult result2;
        if (ref2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(8);
        }
        if (!JSAdvancedSettingsKt.isAdvancedAnnotatorEnabled(ref2.getElement())) {
            return true;
        }
        ResolveResult[] results = ref2.multiResolve(false);
        if (results.length == 0) {
            this.registerProblemForReference((PsiReference)ref2, null, problemHighlightType);
            return false;
        }
        if (results.length == 1 && !(result2 = results[0]).isValidResult()) {
            JSResolveResult.ProblemKind problemKind;
            String message = null;
            if (result2 instanceof JSResolveResult && (problemKind = ((JSResolveResult)result2).getResolveProblemKind()) != null) {
                message = JavaScriptBundle.message(problemKind.getMessageKey(), new Object[0]);
            }
            this.registerProblemForReference((PsiReference)ref2, message, problemHighlightType);
            return false;
        }
        return true;
    }

    protected void registerProblemForReference(@NotNull PsiReference ref2, @Nullable @InspectionMessage String unresolvedMessage, @Nullable ProblemHighlightType problemHighlightType) {
        String message;
        if (ref2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(9);
        }
        TextRange range = JSAnnotatingVisitor.calcRangeForReferences(ref2);
        String string = message = unresolvedMessage != null ? unresolvedMessage : XmlHighlightVisitor.getErrorDescription((PsiReference)ref2);
        if (problemHighlightType == null && ref2 instanceof HighlightSeverityHolder) {
            problemHighlightType = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)((HighlightSeverityHolder)ref2).getUnresolvedReferenceSeverity());
        }
        if (problemHighlightType == null) {
            problemHighlightType = ProblemHighlightType.ERROR;
        }
        LocalQuickFix[] fixes = this.getQuickFixesForReferenceProblem(ref2, message);
        this.myProblemReporter.registerProblem(ref2.getElement(), range, message, problemHighlightType, null, fixes, IntentionAction.EMPTY_ARRAY);
    }

    @NotNull
    protected @NotNull LocalQuickFix @NotNull [] getQuickFixesForReferenceProblem(@NotNull PsiReference ref2, @Nullable String message) {
        if (ref2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(10);
        }
        if (ref2 instanceof LocalQuickFixProvider) {
            LocalQuickFix[] localQuickFixArray = (LocalQuickFix[])ObjectUtils.notNull((Object)((LocalQuickFixProvider)ref2).getQuickFixes(), (Object)LocalQuickFix.EMPTY_ARRAY);
            if (localQuickFixArray == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(11);
            }
            return localQuickFixArray;
        }
        if (LocalQuickFix.EMPTY_ARRAY == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(12);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    protected static TextRange calcRangeForReferences(PsiReference ref2) {
        TextRange elementRange = ref2.getElement().getTextRange();
        TextRange textRange = ref2.getRangeInElement();
        return new TextRange(elementRange.getStartOffset() + textRange.getStartOffset(), elementRange.getStartOffset() + textRange.getEndOffset());
    }

    @Override
    public void visitJSCallExpression(@NotNull JSCallExpression node) {
        JSFunction fun;
        JSExpression methodExpression;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(13);
        }
        if ((methodExpression = node.getMethodExpression()) instanceof JSParenthesizedExpression) {
            methodExpression = JSUtils.unparenthesize(methodExpression);
        }
        if (methodExpression instanceof JSLiteralExpression && !(methodExpression instanceof JSStringTemplateExpression)) {
            this.myProblemReporter.registerGenericError((PsiElement)methodExpression, JavaScriptParserBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]), new CommonIntentionAction[0]);
        } else if (methodExpression instanceof JSSuperExpression && JSClassUtils.canHaveClasses((PsiElement)node) && ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) == null || !fun.isConstructor())) {
            String message = JavaScriptBundle.message("javascript.validation.message.super.constructor.call.should.be.in.constructor", new Object[0]);
            this.myProblemReporter.registerGenericError((PsiElement)node, message, new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSYieldExpression(@NotNull JSYieldExpression expression) {
        JSElement containerParent;
        DialectOptionHolder dialectOptionHolder;
        JSExpression subExpression;
        if (expression == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(14);
        }
        if (!((subExpression = expression.getExpression()) instanceof JSParenthesizedExpression)) {
            this.checkElementInCurrentLanguageLevel((PsiElement)expression, JSLanguageFeature.YIELD_GENERATORS);
        }
        if (!((dialectOptionHolder = DialectDetector.dialectOfElement((PsiElement)expression)) == null || !dialectOptionHolder.isECMA6 && !dialectOptionHolder.isTypeScript || (containerParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{JSExecutionScope.class, JSClass.class, ES6Decorator.class, JSParameterListElement.class})) instanceof JSFunction && ((JSFunction)containerParent).isGenerator() && !((JSFunction)containerParent).isArrowFunction())) {
            this.myProblemReporter.registerGenericError((PsiElement)expression, JavaScriptBundle.message("javascript.validation.generators.yield.not.in.generator", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSBindExpression(@NotNull JSExpression bindExpression) {
        if (bindExpression == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(15);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)bindExpression, JSLanguageFeature.BIND_EXPRESSIONS);
    }

    protected void checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @NotNull JSLanguageFeature languageFeature) {
        if (elementToHighlight == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(16);
        }
        if (languageFeature == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(17);
        }
        this.checkElementInCurrentLanguageLevel(elementToHighlight, null, languageFeature);
    }

    private void checkElementInCurrentLanguageLevel(@NotNull PsiElement elementToHighlight, @Nullable TextRange range, @NotNull JSLanguageFeature languageFeature) {
        JSLanguageLevel currentLevel;
        if (elementToHighlight == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(18);
        }
        if (languageFeature == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(19);
        }
        if ((currentLevel = JSLanguageLevelDetector.languageLevelOfElement(elementToHighlight)) != null && !currentLevel.getDialect().getOptionHolder().hasFeature(languageFeature)) {
            String message = JavaScriptParserBundle.message((String)"javascript.parser.message.are.not.supported.by.dialect", (Object[])new Object[]{languageFeature.getName()});
            ArrayList<ChangeLanguageLevelFix> fixes = new ArrayList<ChangeLanguageLevelFix>(2);
            JSLanguageLevel proposedLevel = ChangeLanguageLevelFix.defineMinimalLanguageLevel(languageFeature, currentLevel);
            if (proposedLevel != null) {
                fixes.add(new ChangeLanguageLevelFix(proposedLevel));
            }
            if (range == null) {
                this.myProblemReporter.registerProblem(elementToHighlight, null, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, fixes.toArray(IntentionAction.EMPTY_ARRAY));
            } else {
                this.myProblemReporter.registerProblem(elementToHighlight, range, message, ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, fixes.toArray(IntentionAction.EMPTY_ARRAY));
            }
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(20);
        }
        super.visitComment(comment);
        String text = comment.getText();
        if (text.startsWith("/*") && !text.endsWith("*/") && PsiTreeUtil.getNextSiblingOfType((PsiElement)comment, OuterLanguageElement.class) == null) {
            TextRange r = comment.getTextRange();
            TextRange errorRange = TextRange.create((int)Math.max(r.getStartOffset(), r.getEndOffset() - 1), (int)r.getEndOffset());
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, JavaScriptParserBundle.message((String)"javascript.parser.message.unclosed.comment", (Object[])new Object[0])).range(errorRange).afterEndOfLine().create();
        }
    }

    @Override
    public void visitJSVarStatement(@NotNull JSVarStatement node) {
        JSFunction parentFunction;
        ASTNode awaitKeyword;
        ASTNode keyword;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(21);
        }
        if ((keyword = node.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS)) != null && keyword.getElementType() == JSTokenTypes.LET_KEYWORD) {
            this.checkElementInCurrentLanguageLevel(keyword.getPsi(), JSLanguageFeature.LET_DEFINITIONS);
        }
        if (keyword != null && keyword.getElementType() == JSTokenTypes.CONST_KEYWORD) {
            this.checkElementInCurrentLanguageLevel(keyword.getPsi(), JSLanguageFeature.CONST_DEFINITIONS);
        }
        if ((awaitKeyword = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD)) != null && keyword != null && keyword.getElementType() == JSTokenTypes.USING_KEYWORD && (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && !parentFunction.isAsync()) {
            this.myProblemReporter.registerProblem(awaitKeyword.getPsi(), null, JavaScriptBundle.message("js.await-using.in.synchronous.function", new Object[0]), null, null, JSAnnotatingVisitor.getAsyncFunctionFixes(parentFunction), IntentionAction.EMPTY_ARRAY);
        }
    }

    @Override
    public void visitJSDestructuringElement(@NotNull JSDestructuringElement destructuringElement) {
        JSDestructuringContainer target2;
        if (destructuringElement == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(22);
        }
        if ((target2 = destructuringElement.getTarget()) == null) {
            return;
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)target2, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT);
        PsiElement parent = destructuringElement.getParent();
        if (!(!(parent instanceof JSVarStatement) || parent.getParent() instanceof JSForInStatement || parent.getParent() instanceof JSExpression || destructuringElement.hasInitializer() || PsiTreeUtil.hasErrorElements((PsiElement)target2))) {
            this.myProblemReporter.registerProblem((PsiElement)target2, null, JavaScriptBundle.message("javascript.validation.destructuring.without.initializer", new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    @Override
    public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
        PsiElement scope2;
        PsiElement referenceNameElement;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(23);
        }
        PsiElement parent = node.getParent();
        boolean doCheckForReferencingUnallowedMembers = false;
        if (parent instanceof JSNamedElement) {
            JSNamedElement namedElement = (JSNamedElement)parent;
            PsiElement nameIdentifier = namedElement.getNameIdentifier();
            if (nameIdentifier != node && parent instanceof JSDefinitionExpression) {
                doCheckForReferencingUnallowedMembers = true;
            }
        } else {
            doCheckForReferencingUnallowedMembers = true;
        }
        if (doCheckForReferencingUnallowedMembers) {
            String referencedName = node.getReferenceName();
            PsiElement referenceNameElement2 = node.getReferenceNameElement();
            assert (referencedName == null || referenceNameElement2 != null) : referencedName;
            if (("caller".equals(referencedName) || "callee".equals(referencedName)) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                JSExpression qualifier = node.getQualifier();
                if (qualifier instanceof JSReferenceExpression) {
                    PsiElement resolve2;
                    JSReferenceExpression refExpr = (JSReferenceExpression)qualifier;
                    if (JSAdvancedSettingsKt.isAdvancedAnnotatorEnabled((PsiElement)qualifier) && ((resolve2 = refExpr.resolve()) instanceof ImplicitJSVariableImpl || resolve2 instanceof JSFunction)) {
                        this.myProblemReporter.registerGenericError(referenceNameElement2, JavaScriptBundle.message("javascript.validation.message.referencing.arguments.caller.callee.is.not.allowed", new Object[0]), new CommonIntentionAction[0]);
                    }
                }
            } else if ("arguments".equals(referencedName) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (node.getQualifier() != null) {
                    JSType type2 = JSResolveUtil.getExpressionJSType(node.getQualifier());
                    if (!(type2 == null || type2 instanceof JSAnyType || type2 instanceof JSUnionType && ((JSUnionType)type2).isAnyType())) {
                        if (JSTypeUtils.hasFunctionType(type2, false, (PsiElement)node)) {
                            this.myProblemReporter.registerProblem(referenceNameElement2, null, JavaScriptBundle.message("javascript.validation.message.referencing.function.arguments.property.is.not.allowed", new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                        } else if (!type2.isSourceStrict()) {
                            this.myProblemReporter.registerProblem(referenceNameElement2, null, JavaScriptBundle.message("javascript.validation.message.referencing.function.arguments.property.is.not.allowed", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                        }
                    }
                } else if (parent instanceof JSDefinitionExpression) {
                    this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message("javascript.validation.message.arguments.is.readonly", new Object[0]), new CommonIntentionAction[0]);
                }
            } else if (EVAL_FUNCTION_NAME.equals(referencedName) && node.getQualifier() == null && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                if (!JSAnnotatingVisitor.isEvalAllowed(node)) {
                    this.myProblemReporter.registerGenericError(referenceNameElement2, JavaScriptBundle.message("javascript.validation.message.eval.cannot.be.assigned", new Object[0]), new CommonIntentionAction[0]);
                }
            } else if (referenceNameElement2 != null && JSKeywordSets.JS_STRICT_KEYWORDS.contains(referenceNameElement2.getNode().getElementType()) && JSResolveUtil.isEcmaScript5((PsiElement)node)) {
                this.myProblemReporter.registerGenericError(referenceNameElement2, JavaScriptBundle.message("javascript.validation.message.identifier.not.allowed.in.strict.mode", node.getReferenceName()), new CommonIntentionAction[0]);
            }
        }
        if ((referenceNameElement = node.getReferenceNameElement()) != null && referenceNameElement.getNode().getElementType() == JSTokenTypes.YIELD_KEYWORD && node.getQualifier() == null && (scope2 = JSUseScopeProvider.getLexicalScopeOrFile(referenceNameElement)) instanceof JSFunction && ((JSFunction)scope2).isGenerator()) {
            this.myProblemReporter.registerGenericError(referenceNameElement, JavaScriptBundle.message("js.annotator.yield.cannot.be.used.inside.generator", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    protected void checkSetterReturnType(@NotNull JSFunction function) {
        JSType type2;
        if (function == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(24);
        }
        if ((type2 = function.getReturnType()) != null && !(type2 instanceof JSVoidType) && !(type2 instanceof JSUnknownType)) {
            PsiElement returnTypeElement = function.getReturnTypeElement();
            PsiElement nameIdentifier = returnTypeElement != null ? returnTypeElement : JSAnnotatingVisitor.getPlaceForNamedElementProblem(function);
            this.myProblemReporter.registerProblem(nameIdentifier, null, JavaScriptBundle.message("javascript.validation.message.set.method.should.be.void.or.without.type", new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem(function), null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    protected void validateSetter(@NotNull JSFunction setter, @NotNull JSFunction getter, JSParameterListElement param, JSType setterType, JSType retType) {
        if (setter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(25);
        }
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(26);
        }
    }

    protected void validateGetter(@NotNull JSFunction getter, @Nullable JSFunction setter, JSType type2) {
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(27);
        }
    }

    private static boolean isEvalAllowed(@NotNull JSReferenceExpression node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(28);
        }
        return JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node) == ReadWriteAccessDetector.Access.Read;
    }

    protected static boolean isBindable(JSClass clazz) {
        if (clazz instanceof XmlBackedJSClass) {
            return true;
        }
        JSAttributeList attributeList = clazz.getAttributeList();
        return attributeList != null && attributeList.getAttributesByName("Bindable").length > 0;
    }

    protected void checkAccessorAccessTypeMatch(@NotNull JSFunction function, @NotNull JSFunction getter, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String s) {
        if (function == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(29);
        }
        if (getter == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(30);
        }
        JSAttributeList getterAttrList = getter.getAttributeList();
        JSAttributeList attributeList = function.getAttributeList();
        if (JSAnnotatingVisitor.differentAccessType(attributeList, getterAttrList)) {
            PsiElement typeElement = attributeList != null ? attributeList.findAccessTypeElement() : null;
            JSAttributeList.AccessType getterAccessType = getterAttrList != null ? getterAttrList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            JSAttributeList.AccessType attributeListAccessType = attributeList != null ? attributeList.getAccessType() : JSAttributeList.AccessType.PACKAGE_LOCAL;
            this.myProblemReporter.registerGenericError(typeElement != null ? typeElement : function.getNameIdentifier(), JavaScriptBundle.message(s, JSFormatUtil.formatVisibility(getterAccessType)), new CommonIntentionAction[]{JSFixFactory.getInstance().createChangeVisibilityFix(function, getterAccessType, null), JSFixFactory.getInstance().createChangeVisibilityFix(getter, attributeListAccessType, null)});
        }
    }

    private static boolean differentAccessType(@Nullable JSAttributeList attributeList, @Nullable JSAttributeList setterAttrList) {
        if (attributeList != null && setterAttrList != null) {
            JSAttributeList.AccessType setterAccessType;
            JSAttributeList.AccessType accessType = attributeList.getAccessType();
            if (accessType != (setterAccessType = setterAttrList.getAccessType())) {
                return (accessType != JSAttributeList.AccessType.PACKAGE_LOCAL || ActionScriptPsiImplUtil.getNamespaceElement(attributeList) == null) && (setterAccessType != JSAttributeList.AccessType.PACKAGE_LOCAL || ActionScriptPsiImplUtil.getNamespaceElement(setterAttrList) == null);
            }
            return false;
        }
        return attributeList != setterAttrList;
    }

    @Override
    public void visitJSSwitchStatement(@NotNull JSSwitchStatement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(31);
        }
        boolean encounteredDefault = false;
        for (JSCaseClause clause : node.getCaseClauses()) {
            if (!clause.isDefault()) continue;
            if (encounteredDefault) {
                this.reportNotAllowedElementErrorWithRemoveFix(clause, "javascript.validation.message.only.one.default.is.allowed", "javascript.fix.remove.default");
            }
            encounteredDefault = true;
        }
    }

    @Override
    public void visitJSParameter(@NotNull JSParameter node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(32);
        }
        super.visitJSParameter(node);
        if (!node.isOptional()) {
            return;
        }
        JSExpression initializer = node.getInitializer();
        if (initializer == null) {
            return;
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)initializer, JSLanguageFeature.PARAMETER_INITIALIZERS);
        ASTNode questionMark = node.getNode().findChildByType(JSTokenTypes.QUEST);
        if (questionMark == null) {
            return;
        }
        Pair<ASTNode, ASTNode> initializerNodes = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
        this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message("typescript.validate.optional.parameter.inspection.error", new Object[0]), new CommonIntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, ((ASTNode)initializerNodes.first).getPsi(), ((ASTNode)initializerNodes.second).getPsi()), JSFixFactory.getInstance().removeASTNodeFix("typescript.validate.optional.parameter.inspection.fix.question", questionMark.getPsi())});
    }

    @Override
    public void visitJSParameterList(@NotNull JSParameterList node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(33);
        }
        JSParameterListElement restParameter = null;
        boolean initializerPresent = false;
        for (JSParameterListElement parameter : node.getParameters()) {
            boolean hasInitializer;
            JSExpression initializer = parameter.getInitializer();
            boolean bl = hasInitializer = initializer != null;
            if (hasInitializer && !initializerPresent) {
                initializerPresent = true;
            }
            if (!hasInitializer && initializerPresent && this.needsInitializer(parameter)) {
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message("javascript.validation.message.parameter.should.be.initialized", new Object[0]), new CommonIntentionAction[]{JSFixFactory.getInstance().createInitializeParameterFix(parameter, JSTypeUtils.defaultValueOfType(parameter.getJSType())), JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.parameter", (PsiElement)parameter)});
            } else if (hasInitializer && parameter.isRest()) {
                Pair<ASTNode, ASTNode> nodesBefore = JSAnnotatingVisitor.getNodesBefore((PsiElement)initializer, JSTokenTypes.EQ);
                this.myProblemReporter.registerGenericError((PsiElement)parameter, JavaScriptBundle.message("javascript.validation.message.rest.parameter.should.not.be.initialized", new Object[0]), new CommonIntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.initializer", false, ((ASTNode)nodesBefore.first).getPsi(), ((ASTNode)nodesBefore.second).getPsi())});
            }
            if (parameter.isRest() && restParameter == null) {
                restParameter = parameter;
                this.validateRestParameterType(parameter);
                continue;
            }
            if (restParameter == null) continue;
            this.reportNotAllowedElementErrorWithRemoveFix((PsiElement)parameter, "javascript.validation.message.parameter.is.not.allowed.after.rest.parameter", "javascript.fix.remove.parameter");
        }
    }

    private void validateCommaPlacement(@NotNull PsiElement comma, @NotNull IElementType reportBefore, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String messageId) {
        IElementType nextElementType;
        PsiElement afterComma;
        if (comma == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(34);
        }
        if (reportBefore == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(35);
        }
        if ((afterComma = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)comma)) != null && (nextElementType = PsiUtilCore.getElementType((PsiElement)afterComma)) != reportBefore && nextElementType != JSTokenTypes.COMMA) {
            return;
        }
        this.reportNotAllowedElementErrorWithRemoveFix(comma, messageId, "javascript.fix.remove.comma");
    }

    protected void reportNotAllowedElementErrorWithRemoveFix(@NotNull PsiElement elementToReport, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String errorMessageId, @PropertyKey(resourceBundle="messages.JavaScriptBundle") @PropertyKey(resourceBundle="messages.JavaScriptBundle") String quickFixMessageId) {
        if (elementToReport == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(36);
        }
        this.myProblemReporter.registerGenericError(elementToReport, JavaScriptBundle.message(errorMessageId, new Object[0]), new CommonIntentionAction[]{JSFixFactory.getInstance().removeASTNodeFix(quickFixMessageId, elementToReport)});
    }

    @Override
    public void visitJSClass(@NotNull JSClass aClass) {
        if (aClass == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(37);
        }
        if (JSClassUtils.isES6ClassImplementation(aClass) && !(aClass instanceof JSClassExpression)) {
            this.checkDuplicates(aClass);
        }
        this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem(aClass), JSLanguageFeature.CLASSES);
        JSReferenceList list = aClass.getImplementsList();
        if (list != null && !DialectDetector.hasFeature(aClass, JSLanguageFeature.TYPES)) {
            this.myProblemReporter.registerProblem(list.getFirstChild(), null, JavaScriptBundle.message("javascript.validation.message.implements.is.not.allowed", new Object[0]), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, new IntentionAction[]{new ChangeLanguageLevelFix(JSLanguageLevel.FLOW)});
        }
    }

    protected boolean needsInitializer(JSParameterListElement parameter) {
        return false;
    }

    protected void validateRestParameterType(JSParameterListElement parameter) {
    }

    protected static Pair<ASTNode, ASTNode> getNodesBefore(PsiElement initializer, IElementType eq) {
        ASTNode end;
        ASTNode start = end = initializer.getNode();
        PsiElement element2 = initializer.getPrevSibling();
        if (element2 instanceof PsiWhiteSpace) {
            element2 = element2.getPrevSibling();
        }
        if (element2 != null && element2.getNode().getElementType() == eq) {
            start = element2.getNode();
        }
        return Pair.create((Object)start, (Object)end);
    }

    @Override
    public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression expression) {
        if (expression == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(38);
        }
        super.visitJSAssignmentExpression(expression);
        JSExpression lExpr = expression.getLOperand();
        if (lExpr == null) {
            return;
        }
        if (lExpr instanceof JSDefinitionExpression) {
            lExpr = ((JSDefinitionExpression)lExpr).getExpression();
        }
        if (lExpr == null) {
            return;
        }
        this.checkLhs(lExpr, "assignment expression");
    }

    private void checkLhs(JSExpression lExpr, @NotNull String contextTerm) {
        if (contextTerm == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(39);
        }
        if (!JSValidateExpressionUtil.isLHSExpression(lExpr)) {
            this.myProblemReporter.registerGenericError((PsiElement)lExpr, JavaScriptBundle.message("javascript.validation.message.must.be.lvalue", contextTerm), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSTryStatement(@NotNull JSTryStatement node) {
        JSCatchBlock[] blocks;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(40);
        }
        if ((blocks = node.getAllCatchBlocks()).length > 1) {
            HashSet<String> typeToCatch = new HashSet<String>();
            for (JSCatchBlock block : blocks) {
                String typeText;
                JSParameter p = block.getParameter();
                if (p == null) continue;
                JSType parameterType = p.getJSType();
                String string = typeText = parameterType == null ? "" : parameterType.getTypeText(JSType.TypeTextFormat.SIMPLE);
                if (typeToCatch.contains(typeText)) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.validation.message.duplicate.catch.block.fix", true, (PsiElement)block, (PsiElement)block);
                    this.myProblemReporter.registerGenericError((PsiElement)block, JavaScriptBundle.message("javascript.validation.message.duplicate.catch.block", new Object[0]), new CommonIntentionAction[]{fix});
                    continue;
                }
                typeToCatch.add(typeText);
            }
        } else if (blocks.length == 0 && node.getFinallyStatement() == null && node.getVarDeclaration() == null && node.getResourceExpression() == null) {
            PsiElement place = PsiTreeUtil.lastChild((PsiElement)node);
            this.myProblemReporter.registerGenericError(place, JavaScriptBundle.message("javascript.validation.message.missing.catch.or.finally", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSVariable(@NotNull JSVariable var) {
        PsiElement nameIdentifier;
        if (var == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(41);
        }
        if (var.getNode() != null && var.getNode().findChildByType(JSKeywordSets.JS_STRICT_KEYWORDS) != null && JSResolveUtil.isEcmaScript5((PsiElement)var) && (nameIdentifier = var.getNameIdentifier()) != null) {
            String message = JavaScriptBundle.message("javascript.validation.message.identifier.not.allowed.in.strict.mode", var.getName());
            this.myProblemReporter.registerGenericError(nameIdentifier, message, new CommonIntentionAction[0]);
        }
        if (var.isConst() && !var.hasInitializer() && this.isConstNeedInitializer(var)) {
            JSVarStatement statement;
            boolean reportError;
            JSAttributeList attributeList = var.getAttributeList();
            boolean bl = reportError = attributeList == null || attributeList.getAttributesByName("Embed").length == 0;
            if (reportError && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)var) instanceof OuterLanguageElement) {
                reportError = false;
            }
            if (reportError && (statement = var.getStatement()) != null && PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statement) instanceof OuterLanguageElement) {
                reportError = false;
            }
            if (reportError) {
                if (DialectDetector.isES6((PsiElement)var)) {
                    this.myProblemReporter.registerGenericError((PsiElement)var, JavaScriptBundle.message("es6.validation.message.const.variable.without.initializer", new Object[0]), new CommonIntentionAction[0]);
                } else if (!DialectDetector.isTypeScript((PsiElement)var) || !TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)var)) {
                    this.myProblemReporter.registerProblem((PsiElement)var, null, JavaScriptBundle.message("javascript.validation.message.const.variable.without.initializer", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                }
            }
        }
        this.checkForbiddenNameRedefining(var);
        if (var instanceof JSField) {
            this.visitField((JSField)((Object)var));
        }
        if (!DialectDetector.isTypeScript((PsiElement)var) && var.getJSType() instanceof JSVoidType) {
            PsiElement typeElement = var.getTypeElement();
            Object nameIdentifier2 = typeElement != null ? typeElement : var;
            this.myProblemReporter.registerProblem((PsiElement)nameIdentifier2, null, JavaScriptBundle.message("javascript.illegal.variable.type.void", new Object[0]), this.getHighlightTypeForTypeOrSignatureProblem((PsiElement)var), null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
        DuplicatesCheckUtil.JSDuplicatesCheckError error = DuplicatesCheckUtil.checkDuplicatesForVariable(var);
        this.reportDuplicateError((PsiElement)var, error);
    }

    private void visitField(@NotNull JSField var) {
        if (var == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(42);
        }
        if (JSClassUtils.isES6ClassImplementation((PsiElement)var) && StringUtil.equals((CharSequence)var.getName(), (CharSequence)"constructor") && !JSPsiImplUtils.hasModifier(var, JSAttributeList.ModifierType.STATIC)) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)var);
            if (containingClass instanceof TypeScriptEnum || containingClass instanceof TypeScriptInterface || containingClass instanceof TypeScriptTypeAlias) {
                return;
            }
            PsiElement identifier = var.getNameIdentifier();
            if (identifier != null) {
                this.myProblemReporter.registerGenericError(identifier, JavaScriptBundle.message("javascript.validation.message.constructor.field.not.allowed", new Object[0]), new CommonIntentionAction[0]);
            }
        }
    }

    protected boolean isConstNeedInitializer(JSVariable var) {
        return !JSUtils.isMember((PsiElement)var);
    }

    @Override
    public void visitJSContinueStatement(@NotNull JSContinueStatement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(43);
        }
        super.visitJSContinueStatement(node);
        if (node.getStatementToContinue() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message("javascript.validation.message.continue.without.target", new Object[0]), new CommonIntentionAction[0]);
        }
        if (!(PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSExecutionScope.class, JSLoopStatement.class}) instanceof JSLoopStatement)) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message("javascript.validation.message.continue.outside.loop", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSBreakStatement(@NotNull JSBreakStatement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(44);
        }
        super.visitJSBreakStatement(node);
        if (node.getStatementToBreak() == null) {
            this.myProblemReporter.registerGenericError((PsiElement)node, JavaScriptBundle.message("javascript.validation.message.break.without.target", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    protected void checkGetterAndSetter(@NotNull JSFunction function) {
        PsiElement nameIdentifier;
        if (function == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(45);
        }
        if ((nameIdentifier = function.getNameIdentifier()) == null) {
            return;
        }
        if (function.isSetProperty()) {
            JSParameterListElement[] params;
            this.checkSetterReturnType(function);
            JSParameterList parameterList = function.getParameterList();
            JSParameterListElement[] jSParameterListElementArray = params = parameterList != null ? parameterList.getParameters() : JSParameterListElement.EMPTY_ARRAY;
            if (params.length != 1) {
                this.myProblemReporter.registerGenericError((PsiElement)(parameterList != null ? parameterList : nameIdentifier), JavaScriptBundle.message("javascript.validation.message.set.method.should.have.one.parameter", new Object[0]), new CommonIntentionAction[0]);
            } else {
                JSFunction getter;
                PsiElement element2 = JSResolveUtil.findParent(function);
                if (element2 instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element2) && (getter = ((JSClass)element2).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.GETTER)) != null) {
                    JSType retType = getter.getReturnType();
                    JSType setterType = params[0].getJSType();
                    this.validateSetter(function, getter, params[0], setterType, retType);
                }
                if (params[0].hasInitializer()) {
                    JSExpression inititializer = params[0].getInitializer();
                    ASTNode first = params[0].getNode().findChildByType(JSTokenTypes.EQ);
                    if (first != null && inititializer != null) {
                        LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("javascript.fix.remove.setter.parameter.initializer", false, first.getPsi(), (PsiElement)inititializer);
                        this.myProblemReporter.registerGenericError((PsiElement)inititializer, JavaScriptBundle.message("javascript.validation.message.setter.parameter.cannot.have.initializer", new Object[0]), new CommonIntentionAction[]{fix});
                    }
                }
            }
        } else if (function.isGetProperty()) {
            JSParameterListElement[] parameters2;
            JSType type2 = function.getReturnType();
            PsiElement element3 = JSResolveUtil.findParent(function);
            JSFunction setter = element3 instanceof JSClass && !JSAnnotatingVisitor.isBindable((JSClass)element3) ? ((JSClass)element3).findFunctionByNameAndKind(function.getName(), JSFunction.FunctionKind.SETTER) : null;
            this.validateGetter(function, setter, type2);
            JSParameterList parameterList = function.getParameterList();
            if (parameterList != null && (parameters2 = parameterList.getParameters()).length != 0) {
                String key = parameters2.length > 1 ? "javascript.fix.remove.parameters" : "javascript.fix.remove.parameter";
                LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix(key, false, (PsiElement)parameters2[0], (PsiElement)parameters2[parameters2.length - 1]);
                this.myProblemReporter.registerGenericError((PsiElement)parameterList, JavaScriptBundle.message("javascript.validation.message.get.method.should.have.no.parameter", new Object[0]), new CommonIntentionAction[]{fix});
            }
        }
        if (JSPsiImplUtils.isGetterOrSetter(function) && !(function.getParent() instanceof JSProperty) && !(function instanceof JSFunctionProperty) && PsiTreeUtil.getParentOfType((PsiElement)function, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class}) != null) {
            this.myProblemReporter.registerGenericError(nameIdentifier, JavaScriptBundle.message("javascript.validation.message.accessor.could.not.be.nested.under.other.function", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSProperty(@NotNull JSProperty property) {
        ES6ComputedName propertyName;
        if (property == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(46);
        }
        PsiElement parent = property.getParent();
        boolean isOnLeftSide = false;
        while (parent != null && !(parent instanceof PsiFile)) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSAssignmentExpression) {
                JSAssignmentExpression assignmentExpression = (JSAssignmentExpression)grandParent;
                isOnLeftSide = assignmentExpression.getLOperand() == parent;
                break;
            }
            parent = grandParent;
        }
        if (!isOnLeftSide && property.isShorthandAssignment()) {
            this.myProblemReporter.registerProblem((PsiElement)property, null, JavaScriptBundle.message("js.annotator.assignment.pattern.rhs", new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
        this.checkReferences((PsiElement)property);
        JSExpression value = property.getValue();
        if (!JSDestructuringUtil.parentIsDestructuringAssignmentLHS(value)) {
            this.checkDuplicates(property);
        }
        if (property.isShorthanded()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)property, JSLanguageFeature.SHORTHAND_PROPERTY_NAMES);
        }
        if ((propertyName = property.getComputedPropertyName()) != null) {
            this.checkElementInCurrentLanguageLevel((PsiElement)propertyName, JSLanguageFeature.COMPUTED_PROPERTY_NAMES);
        }
    }

    @Override
    public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
        PsiElement element2;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(47);
        }
        if ((element2 = PsiTreeUtil.getParentOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class, XmlTagChild.class, XmlAttributeValue.class, JSFile.class})) instanceof JSFile && !(element2.getContext() instanceof PsiLanguageInjectionHost) && !((JSFile)element2).isCommonJSModule() || element2 instanceof XmlTagChild && !(element2.getParent() instanceof XmlAttributeValue)) {
            this.myProblemReporter.registerProblem((PsiElement)node, null, JavaScriptBundle.message("javascript.validation.message.return.outside.function.definition", new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    @Override
    public void visitJSLabeledStatement(@NotNull JSLabeledStatement node) {
        String label;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(48);
        }
        if ((label = node.getLabel()) != null) {
            for (PsiElement run2 = node.getParent(); run2 != null; run2 = run2.getParent()) {
                if (run2 instanceof JSLabeledStatement && label.equals(((JSLabeledStatement)run2).getLabel())) {
                    this.myProblemReporter.registerGenericError(node.getLabelIdentifier(), JavaScriptBundle.message("javascript.validation.message.duplicate.label", new Object[0]), new CommonIntentionAction[0]);
                    break;
                }
                if (run2 instanceof JSFunction) break;
            }
        }
    }

    @Override
    public void visitJSWithStatement(@NotNull JSWithStatement node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(49);
        }
        if (JSResolveUtil.isEcmaScript5((PsiElement)node)) {
            this.myProblemReporter.registerGenericError(node.getFirstChild(), JavaScriptBundle.message("javascript.with.statement.is.not.allowed.in.strict.mode.message", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitWithClause(@NotNull JSWithClause assertClause) {
        PsiElement firstChild;
        if (assertClause == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(50);
        }
        if ((firstChild = assertClause.getFirstChild()) != null && firstChild.getNode().getElementType() == JSTokenTypes.ASSERT_KEYWORD) {
            this.myProblemReporter.registerGenericError(firstChild, JavaScriptBundle.message("javascript.with.clause.assert.deprecated.message", new Object[0]), new CommonIntentionAction[0]);
        }
        super.visitWithClause(assertClause);
    }

    @Override
    public void visitJSPostfixExpression(@NotNull JSPostfixExpression node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(51);
        }
        this.checkLhs(node.getExpression(), "postfix expression");
    }

    @Override
    public void visitJSPrefixExpression(@NotNull JSPrefixExpression node) {
        JSFunction parentFunction;
        JSBinaryExpression binaryExpression;
        PsiElement parent;
        IElementType operationSign;
        JSExpression expression;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(52);
        }
        if ((expression = node.getExpression()) != null && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.ReadWrite) {
            this.checkLhs(expression, "prefix expression");
        }
        if ((operationSign = node.getOperationSign()) == JSTokenTypes.DELETE_KEYWORD && expression instanceof JSReferenceExpression) {
            PsiElement resolve2;
            JSReferenceExpression refExpr = (JSReferenceExpression)expression;
            if (JSAdvancedSettingsKt.isAdvancedAnnotatorEnabled((PsiElement)expression) && refExpr.getQualifier() == null && JSAnnotatingVisitor.isInvalidDeleteTarget(resolve2 = refExpr.resolve())) {
                String message = JavaScriptBundle.message("javascript.invalid.delete.target.message", new Object[0]);
                if (node.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4) || JSResolveUtil.isEcmaScript5((PsiElement)expression)) {
                    this.myProblemReporter.registerProblem((PsiElement)expression, null, message, ProblemHighlightType.ERROR, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                } else {
                    this.myProblemReporter.registerProblem((PsiElement)expression, null, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
                }
            }
        }
        if (operationSign != JSTokenTypes.PLUSPLUS && operationSign != JSTokenTypes.MINUSMINUS && (parent = node.getParent()) instanceof JSBinaryExpression && (binaryExpression = (JSBinaryExpression)parent).getOperationSign() == JSTokenTypes.MULTMULT && binaryExpression.getLOperand() == node) {
            ASTNode operationNode = node.getOperationNode();
            if (operationNode != null) {
                String message = JavaScriptBundle.message("js.annotator.unary.operator.within.exponential", operationNode.getText());
                this.myProblemReporter.registerGenericError((PsiElement)node, message, new CommonIntentionAction[0]);
            } else {
                Logger.getInstance(JSAnnotatingVisitor.class).error("Node is null, sign is not", new Attachment[]{new Attachment("unaryExpression.txt", node.getText())});
            }
        }
        if (operationSign == JSTokenTypes.AWAIT_KEYWORD && (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && !parentFunction.isAsync()) {
            this.myProblemReporter.registerProblem(node.getFirstChild(), null, JavaScriptBundle.message("js.await.in.synchronous.function", new Object[0]), null, null, JSAnnotatingVisitor.getAsyncFunctionFixes(parentFunction), IntentionAction.EMPTY_ARRAY);
        }
    }

    private static boolean isInvalidDeleteTarget(@Nullable PsiElement resolve2) {
        if (resolve2 instanceof JSParameter) {
            return !TypeScriptPsiUtil.isFieldParameter((JSParameter)resolve2);
        }
        if (resolve2 instanceof JSFunction) {
            return !(JSResolveUtil.findParent(resolve2) instanceof JSClass) && !(resolve2.getContext() instanceof JSObjectLiteralExpression);
        }
        if (resolve2 instanceof JSField) {
            return false;
        }
        return resolve2 instanceof JSVariable;
    }

    @Override
    public void visitJSForInStatement(@NotNull JSForInStatement node) {
        ASTNode awaitNode;
        JSFunction parentFunction;
        JSExpression expression;
        JSVarStatement statement;
        ASTNode ofKeyword;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(53);
        }
        if ((ofKeyword = node.getNode().findChildByType(JSTokenTypes.OF_KEYWORD)) != null) {
            this.checkElementInCurrentLanguageLevel(ofKeyword.getPsi(), JSLanguageFeature.FOR_OF);
        }
        if ((statement = node.getVarDeclaration()) != null) {
            JSExpression initializer;
            JSInitializerOwner[] variables = statement.getDeclarations();
            if (variables.length > 1) {
                this.myProblemReporter.registerGenericError((PsiElement)variables[1], JavaScriptBundle.message("javascript.validation.multiple.var.in.for.loop", ofKeyword != null ? "for-of" : "for-in"), new CommonIntentionAction[0]);
            } else if (variables.length == 1 && (initializer = variables[0].getInitializer()) != null) {
                this.myProblemReporter.registerGenericError((PsiElement)initializer, JavaScriptBundle.message("javascript.validation.initialized.var.in.for.loop", ofKeyword != null ? "for-of" : "for-in"), new CommonIntentionAction[0]);
            }
        }
        if ((expression = node.getVariableExpression()) != null) {
            this.checkLhs(expression, "for loop");
        }
        if (node.isForAwait() && (parentFunction = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)node, (Class[])new Class[]{JSFunction.class})) != null && !parentFunction.isAsync() && (awaitNode = node.getNode().findChildByType(JSTokenTypes.AWAIT_KEYWORD)) != null) {
            String message = JavaScriptBundle.message("javascript.validation.message.for.await.no.async.context", new Object[0]);
            TextRange range = new TextRange(node.getTextRange().getStartOffset(), awaitNode.getTextRange().getEndOffset());
            this.myProblemReporter.registerProblem((PsiElement)node, range, message, null, null, JSAnnotatingVisitor.getAsyncFunctionFixes(parentFunction), IntentionAction.EMPTY_ARRAY);
        }
    }

    @Override
    public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(54);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)importDeclaration, JSLanguageFeature.IMPORT_DECLARATIONS);
        super.visitES6ImportDeclaration(importDeclaration);
    }

    @Override
    public void visitES6ExportDeclaration(@NotNull ES6ExportDeclaration exportDeclaration) {
        if (exportDeclaration == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(55);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)exportDeclaration, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDeclaration(exportDeclaration);
    }

    @Override
    public void visitES6ExportDefaultAssignment(@NotNull ES6ExportDefaultAssignment node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(56);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.EXPORT_DECLARATIONS);
        super.visitES6ExportDefaultAssignment(node);
    }

    @Override
    public void visitJSAttributeList(@NotNull JSAttributeList attributeList) {
        ASTNode exportKeyword;
        if (attributeList == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(57);
        }
        if ((exportKeyword = attributeList.getNode().findChildByType(JSTokenTypes.EXPORT_KEYWORD)) != null) {
            this.checkElementInCurrentLanguageLevel(exportKeyword.getPsi(), JSLanguageFeature.EXPORT_DECLARATIONS);
        }
        super.visitJSAttributeList(attributeList);
    }

    @NotNull
    public static PsiElement getPlaceForNamedElementProblem(@NotNull PsiNameIdentifierOwner element2) {
        IElementType type2;
        PsiElement nameIdentifier;
        if (element2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(58);
        }
        if ((nameIdentifier = element2.getNameIdentifier()) != null) {
            ASTNode node = nameIdentifier.getNode();
            ASTNode realIdentifier = node.findChildByType(JSKeywordSets.IDENTIFIER_NAMES);
            if (realIdentifier != null) {
                nameIdentifier = realIdentifier.getPsi();
            }
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(59);
            }
            return psiElement;
        }
        PsiElement firstChild = element2.getFirstChild();
        if (firstChild instanceof JSAttributeList) {
            firstChild = firstChild.getNextSibling();
        }
        if (firstChild != null && JSKeywordSets.IDENTIFIER_NAMES.contains(type2 = firstChild.getNode().getElementType())) {
            PsiElement psiElement = firstChild;
            if (psiElement == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(60);
            }
            return psiElement;
        }
        PsiNameIdentifierOwner psiNameIdentifierOwner = element2;
        if (psiNameIdentifierOwner == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(61);
        }
        return psiNameIdentifierOwner;
    }

    @Override
    public void visitImportSpecifier(@NotNull ES6ImportSpecifier node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(62);
        }
        this.checkDuplicates(node);
    }

    @Override
    public void visitES6ImportedBinding(@NotNull ES6ImportedBinding importedBinding) {
        if (importedBinding == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(63);
        }
        super.visitES6ImportedBinding(importedBinding);
        this.checkDuplicates(importedBinding);
    }

    @Override
    public void visitES6ImportSpecifierAlias(@NotNull ES6ImportSpecifierAlias specifierAlias) {
        if (specifierAlias == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(64);
        }
        this.checkDuplicates(specifierAlias);
    }

    protected void checkFunctionDeclaration(@NotNull JSFunction function, @NotNull PsiElement elementToHighlight) {
        if (function == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(65);
        }
        if (elementToHighlight == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(66);
        }
        if (function.isGenerator()) {
            this.checkElementInCurrentLanguageLevel(elementToHighlight, JSLanguageFeature.YIELD_GENERATORS);
        }
        if (!TypeScriptPsiUtil.isAmbientDeclaration(function)) {
            this.checkDuplicates(function);
        }
        this.checkForbiddenNameRedefining(function);
        PsiElement functionParent = JSResolveUtil.findParent(function);
        if (!(functionParent instanceof JSFile || functionParent instanceof JSEmbeddedContent || functionParent instanceof JSClass || functionParent instanceof TypeScriptModule || functionParent instanceof JSBlockStatement && functionParent.getParent() instanceof JSFunction || DialectDetector.isES6OrES6Target(function) || !JSResolveUtil.isEcmaScript5(function))) {
            this.myProblemReporter.registerGenericError(elementToHighlight, JavaScriptBundle.message("javascript.validation.message.es5.function.declarations.allowed.on.top.level.or.function", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private void checkForbiddenNameRedefining(@NotNull JSNamedElement element2) {
        String name;
        if (element2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(67);
        }
        if ((EVAL_FUNCTION_NAME.equals(name = element2.getName()) || "arguments".equals(name)) && JSUseScopeProvider.isLexicalScopeElement((PsiElement)element2) && JSResolveUtil.isEcmaScript5((PsiElement)element2)) {
            this.myProblemReporter.registerGenericError(JSAnnotatingVisitor.getPlaceForNamedElementProblem(element2), JavaScriptBundle.message("javascript.validation.message.redefining.is.not.allowed", name), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSFunctionProperty(@NotNull JSFunctionProperty functionProperty) {
        if (functionProperty == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(68);
        }
        this.checkGetterAndSetter(functionProperty);
        this.checkDuplicates(functionProperty);
        if (!functionProperty.isGetProperty() && !functionProperty.isSetProperty()) {
            this.checkElementInCurrentLanguageLevel(JSAnnotatingVisitor.getPlaceForNamedElementProblem(functionProperty), JSLanguageFeature.METHOD_DEFINITION_SHORTHANDS);
        }
    }

    @Override
    public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
        ASTNode prev;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(69);
        }
        this.checkGetterAndSetter(node);
        ASTNode arrowNode = JSPsiImplUtils.getFunctionArrowNode(node);
        if (arrowNode == null) {
            return;
        }
        this.checkElementInCurrentLanguageLevel(arrowNode.getPsi(), JSLanguageFeature.ARROW_FUNCTIONS);
        if (arrowNode.getElementType() == JSTokenTypes.MINUSGT) {
            ReplaceWithFatArrowFix fix = new ReplaceWithFatArrowFix(arrowNode.getPsi());
            this.myProblemReporter.registerProblem(arrowNode.getPsi(), null, JavaScriptBundle.message("js.annotator.thin.arrow.used", new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, new IntentionAction[]{fix});
        }
        if ((prev = arrowNode.getTreePrev()) instanceof PsiWhiteSpace && prev.textContains('\n')) {
            this.myProblemReporter.registerProblem(arrowNode.getPsi(), null, JavaScriptBundle.message("js.annotator.newline.before.arrow", new Object[0]), null, null, LocalQuickFix.EMPTY_ARRAY, IntentionAction.EMPTY_ARRAY);
        }
    }

    @Override
    public void visitJSStringTemplateExpression(@NotNull JSStringTemplateExpression stringTemplateExpression) {
        if (stringTemplateExpression == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(70);
        }
        this.checkElementInCurrentLanguageLevel((PsiElement)stringTemplateExpression, JSLanguageFeature.STRING_TEMPLATES);
    }

    @Override
    public void visitJSCatchBlock(@NotNull JSCatchBlock node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(71);
        }
        if (!node.hasParameter()) {
            this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.OPTIONAL_CATCH_BINDING);
        }
    }

    @Override
    public void visitES6MetaProperty(@NotNull Es6MetaProperty property) {
        JSFunction containingFunction;
        if (property == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(72);
        }
        if (property.getKind() == Es6MetaProperty.Kind.NewTarget && ((containingFunction = JSPsiImplUtils.getParentFunctionThroughLambdas((PsiElement)property)) == null || JSUtils.isMember(containingFunction) && !containingFunction.isConstructor())) {
            this.myProblemReporter.registerGenericError((PsiElement)property, JavaScriptBundle.message("javascript.validation.new.target.not.in.function", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    protected void checkDuplicates(@NotNull JSPsiNamedElementBase namedElement) {
        if (namedElement == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(73);
        }
        this.reportDuplicateError((PsiElement)namedElement, DuplicatesCheckUtil.checkDuplicates(namedElement));
    }

    protected void reportDuplicateError(@NotNull PsiElement element2, @Nullable DuplicatesCheckUtil.JSDuplicatesCheckError error) {
        IntentionAction[] intentionActionArray;
        PsiElement nameIdentifier;
        if (element2 == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(74);
        }
        if (error == null || !error.hasErrorSeverity()) {
            return;
        }
        PsiElement psiElement = nameIdentifier = element2 instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)element2).getNameIdentifier() : null;
        if (nameIdentifier == null) {
            nameIdentifier = element2;
        }
        if (error.getDuplicatedElement() instanceof JSElement) {
            IntentionAction[] intentionActionArray2 = new IntentionAction[1];
            intentionActionArray = intentionActionArray2;
            intentionActionArray2[0] = new JSNavigateToAlreadyDeclaredVariableFix((JSElement)error.getDuplicatedElement());
        } else {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
        }
        IntentionAction[] actions = intentionActionArray;
        this.myProblemReporter.registerProblem(nameIdentifier, null, error.getMessage(), ProblemHighlightType.GENERIC_ERROR, null, LocalQuickFix.EMPTY_ARRAY, actions);
    }

    @Override
    public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
        PsiElement functionParent;
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(75);
        }
        super.visitJSFunctionDeclaration(node);
        if (node.isConstructor() && (functionParent = JSResolveUtil.findParent(node)) instanceof JSClass) {
            this.createConstructorChecker().checkConstructor(node, (JSClass)functionParent);
        }
        this.checkGetterAndSetter(node);
    }

    @Override
    public void visitJSXmlLiteralExpression(@NotNull JSXmlLiteralExpression node) {
        if (node == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(76);
        }
        super.visitJSXmlLiteralExpression(node);
        this.checkElementInCurrentLanguageLevel((PsiElement)node, JSLanguageFeature.E4X);
    }

    @Override
    public void visitJSDestructuringArrayRestElement(@NotNull JSDestructuringArrayRestElement jsDestructuringArrayRest) {
        JSElement[] elementsWithRest;
        if (jsDestructuringArrayRest == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(77);
        }
        super.visitJSDestructuringArrayRestElement(jsDestructuringArrayRest);
        PsiElement parent = jsDestructuringArrayRest.getParent();
        if (parent instanceof JSDestructuringArray && (elementsWithRest = (JSElement[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, JSElement.class)) != null && jsDestructuringArrayRest != elementsWithRest[elementsWithRest.length - 1]) {
            this.myProblemReporter.registerGenericError((PsiElement)jsDestructuringArrayRest, JavaScriptBundle.message("js.annotator.rest.element.must.be.last", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    @Override
    public void visitJSSpreadExpression(@NotNull JSSpreadExpression spreadExpression) {
        JSExpression[] elementsWithRest;
        if (spreadExpression == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(78);
        }
        super.visitJSSpreadExpression(spreadExpression);
        PsiElement parent = spreadExpression.getParent();
        if (parent instanceof JSArrayLiteralExpression && JSDestructuringUtil.isInAssignmentPattern(parent) && spreadExpression != (elementsWithRest = ((JSArrayLiteralExpression)parent).getExpressions())[elementsWithRest.length - 1]) {
            this.myProblemReporter.registerGenericError((PsiElement)spreadExpression, JavaScriptBundle.message("js.annotator.rest.element.must.be.last", new Object[0]), new CommonIntentionAction[0]);
        }
    }

    private static LocalQuickFix @NotNull [] getAsyncFunctionFixes(@Nullable JSFunction parentFunction) {
        JSExpression expression;
        PsiElement argumentList;
        JSCallExpression callExpression;
        if (parentFunction == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(79);
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        if (parentFunction instanceof JSFunctionExpression && parentFunction.getParent() instanceof JSArgumentList && (callExpression = (JSCallExpression)ObjectUtils.tryCast((Object)(argumentList = parentFunction.getParent()).getParent(), JSCallExpression.class)) != null && (expression = callExpression.getMethodExpression()) instanceof JSReferenceExpression && "forEach".equals(((JSReferenceExpression)expression).getReferenceName())) {
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createForEachToForOfFix()};
            if (localQuickFixArray == null) {
                JSAnnotatingVisitor.$$$reportNull$$$0(80);
            }
            return localQuickFixArray;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{JSFixFactory.getInstance().createMakeFunctionAsyncFix(parentFunction)};
        if (localQuickFixArray == null) {
            JSAnnotatingVisitor.$$$reportNull$$$0(81);
        }
        return localQuickFixArray;
    }

    String getAnnotatorInspectionId() {
        return this.myProblemReporter.getAnnotatorInspectionId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 59, 60, 61, 79, 80, 81 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 3: 
            case 7: 
            case 58: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 13: 
            case 21: 
            case 23: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 40: 
            case 43: 
            case 44: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 56: 
            case 62: 
            case 69: 
            case 71: 
            case 75: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 11: 
            case 12: 
            case 59: 
            case 60: 
            case 61: 
            case 79: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindExpression";
                break;
            }
            case 16: 
            case 18: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToHighlight";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageFeature";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destructuringElement";
                break;
            }
            case 24: 
            case 29: 
            case 45: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 26: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comma";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reportBefore";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToReport";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextTerm";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 46: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assertClause";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportDeclaration";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeList";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedBinding";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifierAlias";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionProperty";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringTemplateExpression";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsDestructuringArrayRest";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spreadExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceForNamedElementProblem";
                break;
            }
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsyncFunctionFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getHighlighter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBinaryExpression";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitJSLiteralExpression";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightTypeForTypeOrSignatureProblem";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkReference";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemForReference";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixesForReferenceProblem";
                break;
            }
            case 11: 
            case 12: 
            case 59: 
            case 60: 
            case 61: 
            case 79: 
            case 80: 
            case 81: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "visitJSCallExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "visitJSYieldExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBindExpression";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkElementInCurrentLanguageLevel";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVarStatement";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "visitJSDestructuringElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReferenceExpression";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterReturnType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "validateSetter";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "validateGetter";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isEvalAllowed";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessorAccessTypeMatch";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "visitJSSwitchStatement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "visitJSParameter";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "visitJSParameterList";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "validateCommaPlacement";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "reportNotAllowedElementErrorWithRemoveFix";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "visitJSClass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAssignmentExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkLhs";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "visitJSTryStatement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "visitJSVariable";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "visitField";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "visitJSContinueStatement";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "visitJSBreakStatement";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterAndSetter";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "visitJSProperty";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "visitJSReturnStatement";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "visitJSLabeledStatement";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "visitJSWithStatement";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "visitWithClause";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPostfixExpression";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "visitJSPrefixExpression";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "visitJSForInStatement";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportDeclaration";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDeclaration";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ExportDefaultAssignment";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "visitJSAttributeList";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceForNamedElementProblem";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "visitImportSpecifier";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportedBinding";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "visitES6ImportSpecifierAlias";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "checkFunctionDeclaration";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "checkForbiddenNameRedefining";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionProperty";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionExpression";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "visitJSStringTemplateExpression";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "visitJSCatchBlock";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "visitES6MetaProperty";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "checkDuplicates";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "reportDuplicateError";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "visitJSFunctionDeclaration";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "visitJSXmlLiteralExpression";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "visitJSDestructuringArrayRestElement";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "visitJSSpreadExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 59, 60, 61, 79, 80, 81 -> new IllegalStateException(string);
        };
    }

    private static final class ReplaceWithFatArrowFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private ReplaceWithFatArrowFix(@Nullable PsiElement element2) {
            super(element2);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("js.annotator.replace.with.fat.arrow", new Object[0]);
            if (string == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                ReplaceWithFatArrowFix.$$$reportNull$$$0(5);
            }
            startElement.replace(JSChangeUtil.createTokenElement(startElement, JSTokenTypes.EQGT, "=>"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$ReplaceWithFatArrowFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$ReplaceWithFatArrowFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public class SimpleErrorReportingClient
    implements ErrorReportingClient {
        @Override
        public void reportError(ASTNode nameIdentifier, @NotNull @InspectionMessage String message, ErrorReportingClient.ProblemKind kind, IntentionAction ... fixes) {
            if (message == null) {
                SimpleErrorReportingClient.$$$reportNull$$$0(0);
            }
            if (fixes == null) {
                SimpleErrorReportingClient.$$$reportNull$$$0(1);
            }
            if (kind == ErrorReportingClient.ProblemKind.ERROR) {
                JSAnnotatingVisitor.this.myProblemReporter.registerGenericError(nameIdentifier, message, (CommonIntentionAction[])fixes);
            } else {
                JSAnnotatingVisitor.this.myProblemReporter.registerProblem(nameIdentifier.getPsi(), null, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, LocalQuickFix.EMPTY_ARRAY, fixes);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "message";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fixes";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/validation/JSAnnotatingVisitor$SimpleErrorReportingClient";
            objectArray[2] = "reportError";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected static enum SignatureMatchResult {
        PARAMETERS_DIFFERS,
        RETURN_TYPE_DIFFERS,
        FUNCTION_KIND_DIFFERS,
        COMPATIBLE_SIGNATURE;

    }

    public static interface ErrorReportingClient {
        public void reportError(ASTNode var1, @NotNull @InspectionMessage String var2, ProblemKind var3, IntentionAction ... var4);

        public static enum ProblemKind {
            ERROR,
            WARNING;

        }
    }
}

