/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverType;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSApplyTypeOperationContextImpl
implements JSApplyTypeOperationContext {
    @NotNull
    private final ProcessingContext myProcessingContext;
    @NotNull
    private final ProcessingContext mySubtypingProcessingContext;
    @NotNull
    private final NotNullLazyValue<JSType> myDeclaredTypeProvider;
    @Nullable
    private final JSType myRealType;
    @NotNull
    private final PsiElement myContextReference;
    @NotNull
    private final JSTypeSource mySource;
    private final boolean myUseAutoVariableType;
    private final boolean myUseAutoArrayType;
    private final boolean myIsTypeScript;
    private final boolean myStrictNullCheck;
    @NotNull
    private final Set<JSType> myEvolvingArrays;
    @NotNull
    private final Map<JSTypeOperation, Map<JSType, JSType>> myCachedOperations;

    @NotNull
    private static JSType getDeclaredType(@Nullable JSType startType, boolean isTypeScript, @NotNull JSTypeSource source, boolean useAutoVariableType) {
        if (source == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(0);
        }
        if (startType != null) {
            JSType jSType = JSTypeGuardChecker.getExactType(startType);
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(1);
            }
            return jSType;
        }
        JSType jSType = isTypeScript && useAutoVariableType ? JSNamedTypeFactory.createType("Object", source, JSContext.INSTANCE) : JSAnyType.get(source);
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    public JSApplyTypeOperationContextImpl(@NotNull PsiElement element2, @Nullable JSType startType, boolean useAutoArrayType, boolean useAutoVariableType, boolean strictNullCheck) {
        if (element2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(3);
        }
        this.myEvolvingArrays = new HashSet<JSType>();
        this.myCachedOperations = new HashMap<JSTypeOperation, Map<JSType, JSType>>();
        this.myProcessingContext = JSTypeComparingContextService.createProcessingContextWithCache(element2);
        this.mySubtypingProcessingContext = JSTypeComparingContextService.createSubtypingProcessingContext(element2);
        this.myRealType = startType;
        this.myContextReference = element2;
        this.myIsTypeScript = DialectDetector.isTypeScript(element2);
        this.mySource = startType == null || startType instanceof JSAnyType ? JSTypeSourceFactory.createTypeSource(this.myContextReference, this.myIsTypeScript) : startType.getSource();
        this.myUseAutoVariableType = useAutoVariableType;
        this.myUseAutoArrayType = useAutoArrayType;
        this.myStrictNullCheck = strictNullCheck;
        this.myDeclaredTypeProvider = NotNullLazyValue.createValue(() -> JSApplyTypeOperationContextImpl.getDeclaredType(startType, this.myIsTypeScript, this.mySource, useAutoVariableType));
    }

    @Override
    @NotNull
    public ProcessingContext getProcessingContext() {
        ProcessingContext processingContext = this.myProcessingContext;
        if (processingContext == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(4);
        }
        return processingContext;
    }

    @Override
    @NotNull
    public ProcessingContext getSubtypingProcessingContext() {
        ProcessingContext processingContext = this.mySubtypingProcessingContext;
        if (processingContext == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(5);
        }
        return processingContext;
    }

    @Override
    @NotNull
    public PsiElement getContextElement() {
        PsiElement psiElement = this.myContextReference;
        if (psiElement == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public JSType getDeclaredType() {
        JSType jSType = (JSType)this.myDeclaredTypeProvider.getValue();
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(7);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType getRealType() {
        return this.myRealType;
    }

    @Override
    public boolean isAutoVariableType() {
        return this.myUseAutoVariableType;
    }

    @Override
    @NotNull
    public JSType narrowTypeByDiscriminant(@NotNull JSType type2, @NotNull String propertyName, @NotNull Function<? super JSType, ? extends JSType> convertType) {
        JSType propType;
        JSType narrowedPropType;
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(8);
        }
        if (propertyName == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(9);
        }
        if (convertType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(10);
        }
        JSType jSType = narrowedPropType = (propType = JSApplyTypeOperationContextImpl.getTypeOfPropertyOfType(type2, propertyName)) == null ? null : (JSType)convertType.fun((Object)propType);
        if (narrowedPropType == null) {
            JSType jSType2 = type2;
            if (jSType2 == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(11);
            }
            return jSType2;
        }
        if (narrowedPropType instanceof TypeScriptNeverType) {
            JSType jSType3 = this.processNeverType(type2, narrowedPropType);
            if (jSType3 == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(12);
            }
            return jSType3;
        }
        JSType result2 = propType == narrowedPropType ? type2 : TypeScriptTypeRelations.filterType(type2, t -> {
            JSType discriminantType = JSApplyTypeOperationContextImpl.getTypeOfPropertyOfType(t, propertyName);
            return TypeScriptTypeRelations.isTypeComparableTo(narrowedPropType, discriminantType, this.getProcessingContext());
        }, this.getContextElement());
        JSType jSType4 = this.processNeverType(type2, result2);
        if (jSType4 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(13);
        }
        return jSType4;
    }

    @Override
    @Nullable
    public JSType expandOperationType(@NotNull JSType type2) {
        Object expression;
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(14);
        }
        if (type2 instanceof JSPsiBasedTypeOfType && PsiTreeUtil.isAncestor(expression = ((JSPsiBasedTypeOfType)type2).getElement(), (PsiElement)this.myContextReference, (boolean)false)) {
            return null;
        }
        return JSTypeGuardChecker.getExactType(type2);
    }

    @Override
    @Nullable
    public JSType getCachedResult(@NotNull JSTypeOperation operation, @NotNull JSType type2) {
        Map<JSType, JSType> cacheValue;
        if (operation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(15);
        }
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(16);
        }
        return (cacheValue = this.myCachedOperations.get(operation)) == null ? null : cacheValue.get(type2);
    }

    @Override
    public void putCacheResult(@NotNull JSTypeOperation operation, @NotNull JSType type2, @NotNull JSType resultType) {
        if (operation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(17);
        }
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(18);
        }
        if (resultType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(19);
        }
        Map result2 = this.myCachedOperations.computeIfAbsent(operation, key -> new HashMap());
        result2.put(type2, resultType);
    }

    @Override
    @NotNull
    public JSTypeSource getDefaultTypeSource() {
        JSTypeSource jSTypeSource = this.mySource;
        if (jSTypeSource == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(20);
        }
        return jSTypeSource;
    }

    @Override
    public boolean strictNullChecks() {
        return this.myStrictNullCheck;
    }

    @Override
    public boolean isAutoArrayType() {
        return this.myUseAutoArrayType;
    }

    @Override
    @NotNull
    public JSType getNarrowedType(@NotNull JSType type2, @NotNull JSType candidate, boolean assumeTrue, @NotNull JSTypeGuardChecker.TypeRelation relation) {
        JSType assignableType;
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(21);
        }
        if (candidate == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(22);
        }
        if (relation == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(23);
        }
        if (!assumeTrue) {
            JSType jSType = TypeScriptTypeRelations.filterType(type2, t -> !relation.isRelated((JSType)t, candidate), this.myContextReference);
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(24);
            }
            return jSType;
        }
        if (JSTypeUtils.unwrapType(type2) instanceof JSUnionType && !((assignableType = TypeScriptTypeRelations.filterType(type2, t -> relation.isRelated((JSType)t, candidate), this.myContextReference)) instanceof TypeScriptNeverType)) {
            JSType jSType = assignableType;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(25);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeSubtypeOf(candidate, type2, this.mySubtypingProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(26);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(type2, candidate, this.myProcessingContext)) {
            JSType jSType = type2;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(27);
            }
            return jSType;
        }
        if (TypeScriptTypeRelations.isTypeAssignableTo(candidate, type2, this.myProcessingContext)) {
            JSType jSType = candidate;
            if (jSType == null) {
                JSApplyTypeOperationContextImpl.$$$reportNull$$$0(28);
            }
            return jSType;
        }
        return JSApplyTypeOperationContextImpl.getIntersectionTypeWithProcessingDecorators(type2, candidate);
    }

    @NotNull
    private static JSType getIntersectionTypeWithProcessingDecorators(@NotNull JSType type2, @NotNull JSType candidate) {
        if (type2 == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(29);
        }
        if (candidate == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(30);
        }
        JSType jSType = JSCompositeTypeFactory.createIntersectionType(List.of(type2, candidate), candidate.getSource());
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(31);
        }
        return jSType;
    }

    @Override
    public JSType processNeverType(@Nullable JSType type2, @Nullable JSType resultOrNeverType) {
        if (this.myIsTypeScript) {
            return resultOrNeverType;
        }
        return resultOrNeverType instanceof TypeScriptNeverType ? type2 : resultOrNeverType;
    }

    @Override
    public boolean isEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(32);
        }
        return this.myEvolvingArrays.contains(arrayType);
    }

    @Override
    @NotNull
    public JSType getEvolvingArrayType(@NotNull JSType parameterType) {
        if (parameterType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(33);
        }
        JSArrayTypeImpl type2 = new JSArrayTypeImpl(parameterType, this.getDefaultTypeSource());
        this.myEvolvingArrays.add(type2);
        JSArrayTypeImpl jSArrayTypeImpl = type2;
        if (jSArrayTypeImpl == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(34);
        }
        return jSArrayTypeImpl;
    }

    @Override
    @NotNull
    public JSType finalizeEvolvingArrayType(@NotNull JSType arrayType) {
        if (arrayType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(35);
        }
        if (arrayType instanceof JSArrayType && !((JSArrayType)arrayType).isPrimitive()) {
            JSType type2 = ((JSArrayType)arrayType).getType();
            if (type2 instanceof TypeScriptNeverType) {
                JSType jSType = this.getDeclaredType();
                if (jSType == null) {
                    JSApplyTypeOperationContextImpl.$$$reportNull$$$0(36);
                }
                return jSType;
            }
            this.myEvolvingArrays.remove(arrayType);
        }
        JSType jSType = arrayType;
        if (jSType == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(37);
        }
        return jSType;
    }

    @Nullable
    public static JSType getTypeOfPropertyOfType(@Nullable JSType type2, @NotNull String propertyName) {
        if (propertyName == null) {
            JSApplyTypeOperationContextImpl.$$$reportNull$$$0(38);
        }
        if (type2 == null) {
            return null;
        }
        JSRecordType recordType = JSTypeUtils.removeNullableComponents(type2).asRecordType();
        JSRecordType.PropertySignature signature = recordType.findPropertySignature(propertyName);
        if (signature == null) {
            return null;
        }
        JSType jsType = signature.getJSType();
        if (signature.isOptional() && jsType != null) {
            jsType = JSTypeGuardUtil.wrapWithUndefined(jsType, jsType.getSource());
        }
        return JSTypeGuardChecker.getExactType(jsType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 5, 6, 7, 11, 12, 13, 20, 24, 25, 26, 27, 28, 31, 34, 36, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSApplyTypeOperationContextImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertType";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultType";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSApplyTypeOperationContextImpl";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessingContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubtypingProcessingContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "narrowTypeByDiscriminant";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeSource";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getNarrowedType";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionTypeWithProcessingDecorators";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvolvingArrayType";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "finalizeEvolvingArrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 37: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrowTypeByDiscriminant";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "expandOperationType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCachedResult";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putCacheResult";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getNarrowedType";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionTypeWithProcessingDecorators";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isEvolvingArrayType";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getEvolvingArrayType";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "finalizeEvolvingArrayType";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getTypeOfPropertyOfType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 5, 6, 7, 11, 12, 13, 20, 24, 25, 26, 27, 28, 31, 34, 36, 37 -> new IllegalStateException(string);
        };
    }
}

