/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_SK = "اسلواکی";
        final String metaValue_ku = "کرمانجی";
        final String metaValue_ar = "عربی";
        final String metaValue_hy = "ارمنی";
        final String metaValue_ae = "اوستایی";
        final String metaValue_ban = "بالیایی";
        final String metaValue_bn = "بنگالی";
        final String metaValue_chr = "چروکی";
        final String metaValue_cop = "قبطی";
        final String metaValue_ka = "گرجی";
        final String metaValue_got = "گوتی";
        final String metaValue_el = "یونانی";
        final String metaValue_gu = "گجراتی";
        final String metaValue_he = "عبری";
        final String metaValue_jv = "جاوه‌ای";
        final String metaValue_ja = "ژاپنی";
        final String metaValue_km = "خمری";
        final String metaValue_kn = "کانارا";
        final String metaValue_ko = "کره‌ای";
        final String metaValue_lo = "لائوسی";
        final String metaValue_la = "لاتین";
        final String metaValue_men = "منده‌ای";
        final String metaValue_ml = "مالایالامی";
        final String metaValue_mn = "مغولی";
        final String metaValue_phn = "فنیقی";
        final String metaValue_si = "سینهالی";
        final String metaValue_syr = "سریانی";
        final String metaValue_ta = "تامیلی";
        final String metaValue_te = "تلوگویی";
        final String metaValue_tl = "تاگالوگی";
        final String metaValue_th = "تایلندی";
        final String metaValue_bo = "تبتی";
        final String metaValue_uga = "اوگاریتی";
        final String metaValue_vai = "ویایی";
        final String metaValue_peo = "فارسی باستان";
        final Object[][] data = new Object[][] {
            { "001", "جهان" },
            { "002", "افریقا" },
            { "003", "امریکای شمالی" },
            { "005", "امریکای جنوبی" },
            { "009", "اقیانوسیه" },
            { "011", "غرب افریقا" },
            { "013", "امریکای مرکزی" },
            { "014", "شرق افریقا" },
            { "015", "شمال افریقا" },
            { "017", "مرکز افریقا" },
            { "018", "جنوب افریقا" },
            { "019", "امریکا" },
            { "021", "شمال امریکا" },
            { "029", "کارائیب" },
            { "030", "شرق آسیا" },
            { "034", "جنوب آسیا" },
            { "035", "جنوب شرق آسیا" },
            { "039", "جنوب اروپا" },
            { "053", "استرالزی" },
            { "054", "ملانزی" },
            { "057", "ناحیهٔ میکرونزی" },
            { "061", "پلی‌نزی" },
            { "142", "آسیا" },
            { "143", "آسیای مرکزی" },
            { "145", "غرب آسیا" },
            { "150", "اروپا" },
            { "151", "شرق اروپا" },
            { "154", "شمال اروپا" },
            { "155", "غرب اروپا" },
            { "202", "افریقای جنوب صحرا" },
            { "419", "امریکای لاتین" },
            { "AC", "جزایر آسنسیون" },
            { "AD", "آندورا" },
            { "AE", "امارات متحدهٔ عربی" },
            { "AF", "افغانستان" },
            { "AG", "آنتیگوا و باربودا" },
            { "AI", "آنگویلا" },
            { "AL", "آلبانی" },
            { "AM", "ارمنستان" },
            { "AO", "آنگولا" },
            { "AQ", "جنوبگان" },
            { "AR", "آرژانتین" },
            { "AS", "ساموآی امریکا" },
            { "AT", "اتریش" },
            { "AU", "استرالیا" },
            { "AW", "آروبا" },
            { "AX", "جزایر آلاند" },
            { "AZ", "جمهوری آذربایجان" },
            { "BA", "بوسنی و هرزگوین" },
            { "BB", "باربادوس" },
            { "BD", "بنگلادش" },
            { "BE", "بلژیک" },
            { "BF", "بورکینافاسو" },
            { "BG", "بلغارستان" },
            { "BH", "بحرین" },
            { "BI", "بوروندی" },
            { "BJ", "بنین" },
            { "BL", "سن بارتلمی" },
            { "BM", "برمودا" },
            { "BN", "برونئی" },
            { "BO", "بولیوی" },
            { "BQ", "جزایر کارائیب هلند" },
            { "BR", "برزیل" },
            { "BS", "باهاما" },
            { "BT", "بوتان" },
            { "BV", "جزیرهٔ بووه" },
            { "BW", "بوتسوانا" },
            { "BY", "بلاروس" },
            { "BZ", "بلیز" },
            { "CA", "کانادا" },
            { "CC", "جزایر کوکوس" },
            { "CD", "کنگو - کینشاسا" },
            { "CF", "جمهوری افریقای مرکزی" },
            { "CG", "کنگو - برازویل" },
            { "CH", "سوئیس" },
            { "CI", "ساحل عاج" },
            { "CK", "جزایر کوک" },
            { "CL", "شیلی" },
            { "CM", "کامرون" },
            { "CN", "چین" },
            { "CO", "کلمبیا" },
            { "CP", "جزایر کلیپرتون" },
            { "CQ", "سارک" },
            { "CR", "کاستاریکا" },
            { "CU", "کوبا" },
            { "CV", "کیپ‌ورد" },
            { "CW", "کوراسائو" },
            { "CX", "جزیرهٔ کریسمس" },
            { "CY", "قبرس" },
            { "CZ", "چک" },
            { "DE", "آلمان" },
            { "DG", "دیه‌گو گارسیا" },
            { "DJ", "جیبوتی" },
            { "DK", "دانمارک" },
            { "DM", "دومینیکا" },
            { "DO", "جمهوری دومینیکن" },
            { "DZ", "الجزایر" },
            { "EA", "سبته و ملیله" },
            { "EC", "اکوادور" },
            { "EE", "استونی" },
            { "EG", "مصر" },
            { "EH", "صحرای غربی" },
            { "ER", "اریتره" },
            { "ES", "اسپانیا" },
            { "ET", "اتیوپی" },
            { "EU", "اتحادیهٔ اروپا" },
            { "EZ", "منطقهٔ یورو" },
            { "FI", "فنلاند" },
            { "FJ", "فیجی" },
            { "FK", "جزایر فالکلند" },
            { "FM", "میکرونزی" },
            { "FO", "جزایر فارو" },
            { "FR", "فرانسه" },
            { "GA", "گابن" },
            { "GB", "بریتانیا" },
            { "GD", "گرنادا" },
            { "GE", "گرجستان" },
            { "GF", "گویان فرانسه" },
            { "GG", "گرنزی" },
            { "GH", "غنا" },
            { "GI", "جبل‌الطارق" },
            { "GL", "گرینلند" },
            { "GM", "گامبیا" },
            { "GN", "گینه" },
            { "GP", "گوادلوپ" },
            { "GQ", "گینهٔ استوایی" },
            { "GR", "یونان" },
            { "GS", "جورجیای جنوبی و جزایر ساندویچ جنوبی" },
            { "GT", "گواتمالا" },
            { "GU", "گوام" },
            { "GW", "گینهٔ بیسائو" },
            { "GY", "گویان" },
            { "HK", "هنگ‌کنگ، منطقهٔ ویژهٔ اداری چین" },
            { "HM", "هرد و جزایر مک‌دونالد" },
            { "HN", "هندوراس" },
            { "HR", "کرواسی" },
            { "HT", "هائیتی" },
            { "HU", "مجارستان" },
            { "IC", "جزایر قناری" },
            { "ID", "اندونزی" },
            { "IE", "ایرلند" },
            { "IL", "اسرائیل" },
            { "IM", "جزیرهٔ من" },
            { "IN", "هند" },
            { "IO", "قلمرو بریتانیا در اقیانوس هند" },
            { "IQ", "عراق" },
            { "IR", "ایران" },
            { "IS", "ایسلند" },
            { "IT", "ایتالیا" },
            { "JE", "جرزی" },
            { "JM", "جامائیکا" },
            { "JO", "اردن" },
            { "JP", "ژاپن" },
            { "KE", "کنیا" },
            { "KG", "قرقیزستان" },
            { "KH", "کامبوج" },
            { "KI", "کیریباتی" },
            { "KM", "کومور" },
            { "KN", "سنت کیتس و نویس" },
            { "KP", "کرهٔ شمالی" },
            { "KR", "کرهٔ جنوبی" },
            { "KW", "کویت" },
            { "KY", "جزایر کِیمن" },
            { "KZ", "قزاقستان" },
            { "LA", "لائوس" },
            { "LB", "لبنان" },
            { "LC", "سنت لوسیا" },
            { "LI", "لیختن‌اشتاین" },
            { "LK", "سری‌لانکا" },
            { "LR", "لیبریا" },
            { "LS", "لسوتو" },
            { "LT", "لیتوانی" },
            { "LU", "لوکزامبورگ" },
            { "LV", "لتونی" },
            { "LY", "لیبی" },
            { "MA", "مراکش" },
            { "MC", "موناکو" },
            { "MD", "مولداوی" },
            { "ME", "مونته‌نگرو" },
            { "MF", "سنت مارتین" },
            { "MG", "ماداگاسکار" },
            { "MH", "جزایر مارشال" },
            { "MK", "مقدونیهٔ شمالی" },
            { "ML", "مالی" },
            { "MM", "میانمار (برمه)" },
            { "MN", "مغولستان" },
            { "MO", "ماکائو، منطقهٔ ویژهٔ اداری چین" },
            { "MP", "جزایر ماریانای شمالی" },
            { "MQ", "مارتینیک" },
            { "MR", "موریتانی" },
            { "MS", "مونت‌سرات" },
            { "MT", "مالت" },
            { "MU", "موریس" },
            { "MV", "مالدیو" },
            { "MW", "مالاوی" },
            { "MX", "مکزیک" },
            { "MY", "مالزی" },
            { "MZ", "موزامبیک" },
            { "NA", "نامیبیا" },
            { "NC", "کالدونیای جدید" },
            { "NE", "نیجر" },
            { "NF", "جزیرهٔ نورفولک" },
            { "NG", "نیجریه" },
            { "NI", "نیکاراگوئه" },
            { "NL", "هلند" },
            { "NO", "نروژ" },
            { "NP", "نپال" },
            { "NR", "نائورو" },
            { "NU", "نیوئه" },
            { "NZ", "نیوزیلند" },
            { "OM", "عمان" },
            { "PA", "پاناما" },
            { "PE", "پرو" },
            { "PF", "پلی‌نزی فرانسه" },
            { "PG", "پاپوا گینهٔ نو" },
            { "PH", "فیلیپین" },
            { "PK", "پاکستان" },
            { "PL", "لهستان" },
            { "PM", "سن پیر و میکلن" },
            { "PN", "جزایر پیت‌کرن" },
            { "PR", "پورتوریکو" },
            { "PS", "سرزمین‌های فلسطینی" },
            { "PT", "پرتغال" },
            { "PW", "پالائو" },
            { "PY", "پاراگوئه" },
            { "QA", "قطر" },
            { "QO", "بخش‌های دورافتادهٔ اقیانوسیه" },
            { "RE", "رئونیون" },
            { "RO", "رومانی" },
            { "RS", "صربستان" },
            { "RU", "روسیه" },
            { "RW", "رواندا" },
            { "SA", "عربستان سعودی" },
            { "SB", "جزایر سلیمان" },
            { "SC", "سیشل" },
            { "SD", "سودان" },
            { "SE", "سوئد" },
            { "SG", "سنگاپور" },
            { "SH", "سنت هلن" },
            { "SI", "اسلوونی" },
            { "SJ", "سوالبارد و یان ماین" },
            { "SK", metaValue_SK },
            { "SL", "سیرالئون" },
            { "SM", "سان‌مارینو" },
            { "SN", "سنگال" },
            { "SO", "سومالی" },
            { "SR", "سورینام" },
            { "SS", "سودان جنوبی" },
            { "ST", "سائوتومه و پرینسیپ" },
            { "SV", "السالوادور" },
            { "SX", "سنت مارتن" },
            { "SY", "سوریه" },
            { "SZ", "اسواتینی" },
            { "TA", "تریستان دا کونا" },
            { "TC", "جزایر تورکس و کایکوس" },
            { "TD", "چاد" },
            { "TF", "سرزمین‌های جنوبی فرانسه" },
            { "TG", "توگو" },
            { "TH", "تایلند" },
            { "TJ", "تاجیکستان" },
            { "TK", "توکلائو" },
            { "TL", "تیمور-لسته" },
            { "TM", "ترکمنستان" },
            { "TN", "تونس" },
            { "TO", "تونگا" },
            { "TR", "ترکیه" },
            { "TT", "ترینیداد و توباگو" },
            { "TV", "تووالو" },
            { "TW", "تایوان" },
            { "TZ", "تانزانیا" },
            { "UA", "اوکراین" },
            { "UG", "اوگاندا" },
            { "UM", "جزایر دورافتادهٔ ایالات متحده" },
            { "UN", "سازمان ملل متحد" },
            { "US", "ایالات متحده" },
            { "UY", "اروگوئه" },
            { "UZ", "ازبکستان" },
            { "VA", "واتیکان" },
            { "VC", "سنت وینسنت و گرنادین" },
            { "VE", "ونزوئلا" },
            { "VG", "جزایر ویرجین بریتانیا" },
            { "VI", "جزایر ویرجین ایالات متحده" },
            { "VN", "ویتنام" },
            { "VU", "وانواتو" },
            { "WF", "والیس و فوتونا" },
            { "WS", "ساموآ" },
            { "XA", "انگلیسی با لهجه خارجی" },
            { "XB", "مجازی - دوجهته" },
            { "XK", "کوزوو" },
            { "YE", "یمن" },
            { "YT", "مایوت" },
            { "ZA", "افریقای جنوبی" },
            { "ZM", "زامبیا" },
            { "ZW", "زیمبابوه" },
            { "ZZ", "ناحیهٔ نامشخص" },
            { "aa", "آفاری" },
            { "ab", "آبخازی" },
            { "ae", metaValue_ae },
            { "af", "آفریکانس" },
            { "ak", "آکان" },
            { "am", "امهری" },
            { "an", "آراگونی" },
            { "ar", metaValue_ar },
            { "as", "آسامی" },
            { "av", "آواری" },
            { "ay", "آیمارایی" },
            { "az", "ترکی آذربایجانی" },
            { "ba", "باشقیری" },
            { "be", "بلاروسی" },
            { "bg", "بلغاری" },
            { "bi", "بیسلاما" },
            { "bm", "بامبارایی" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "برتون" },
            { "bs", "بوسنیایی" },
            { "ca", "کاتالان" },
            { "ce", "چچنی" },
            { "ch", "چامورویی" },
            { "co", "کورسی" },
            { "cr", "کریایی" },
            { "cs", "چکی" },
            { "cu", "اسلاوی کلیسایی" },
            { "cv", "چوواشی" },
            { "cy", "ولزی" },
            { "da", "دانمارکی" },
            { "de", "آلمانی" },
            { "dv", "دیوهی" },
            { "dz", "دزونگخا" },
            { "ee", "اوه‌ای" },
            { "el", metaValue_el },
            { "en", "انگلیسی" },
            { "eo", "اسپرانتو" },
            { "es", "اسپانیایی" },
            { "et", "استونیایی" },
            { "eu", "باسکی" },
            { "fa", "فارسی" },
            { "ff", "فولانی" },
            { "fi", "فنلاندی" },
            { "fj", "فیجیایی" },
            { "fo", "فارویی" },
            { "fr", "فرانسوی" },
            { "fy", "فریسی غربی" },
            { "ga", "ایرلندی" },
            { "gd", "گیلی اسکاتلندی" },
            { "gl", "گالیسیایی" },
            { "gn", "گوارانی" },
            { "gu", metaValue_gu },
            { "gv", "مانی" },
            { "ha", "هوسایی" },
            { "he", metaValue_he },
            { "hi", "هندی" },
            { "ho", "موتویی هیری" },
            { "hr", "کروات" },
            { "ht", "هائیتیایی" },
            { "hu", "مجاری" },
            { "hy", metaValue_hy },
            { "hz", "هریرویی" },
            { "ia", "اینترلینگوا" },
            { "id", "اندونزیایی" },
            { "ie", "اکسیدنتال" },
            { "ig", "ایگبویی" },
            { "ii", "یی سیچوان" },
            { "ik", "اینوپیک" },
            { "io", "ایدو" },
            { "is", "ایسلندی" },
            { "it", "ایتالیایی" },
            { "iu", "اینوکتیتوت" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "کنگویی" },
            { "ki", "کیکویویی" },
            { "kj", "کوانیاما" },
            { "kk", "قزاقی" },
            { "kl", "گرینلندی" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "کانوریایی" },
            { "ks", "کشمیری" },
            { "ku", metaValue_ku },
            { "kv", "کومیایی" },
            { "kw", "کورنی" },
            { "ky", "قرقیزی" },
            { "la", metaValue_la },
            { "lb", "لوگزامبورگی" },
            { "lg", "گاندایی" },
            { "li", "لیمبورگی" },
            { "ln", "لینگالا" },
            { "lo", metaValue_lo },
            { "lt", "لیتوانیایی" },
            { "lu", "لوبایی‐کاتانگا" },
            { "lv", "لتونیایی" },
            { "mg", "مالاگاسی" },
            { "mh", "مارشالی" },
            { "mi", "مائوری" },
            { "mk", "مقدونی" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "مراتی" },
            { "ms", "مالایی" },
            { "mt", "مالتی" },
            { "my", "برمه‌ای" },
            { "na", "نائورویی" },
            { "nb", "نروژی بوک‌مُل" },
            { "nd", "انده‌بله‌ای شمالی" },
            { "ne", "نپالی" },
            { "ng", "اندونگایی" },
            { "nl", "هلندی" },
            { "nn", "نروژی نی‌نُشک" },
            { "no", "نروژی" },
            { "nr", "انده‌بله‌ای جنوبی" },
            { "nv", "ناواهویی" },
            { "ny", "نیانجایی" },
            { "oc", "اکسیتان" },
            { "oj", "اوجیبوایی" },
            { "om", "اورومویی" },
            { "or", "اوریه‌ای" },
            { "os", "آسی" },
            { "pa", "پنجابی" },
            { "pi", "پالی" },
            { "pl", "لهستانی" },
            { "ps", "پشتو" },
            { "pt", "پرتغالی" },
            { "qu", "کچوایی" },
            { "rm", "رومانش" },
            { "rn", "روندیایی" },
            { "ro", "رومانیایی" },
            { "ru", "روسی" },
            { "rw", "کینیارواندایی" },
            { "sa", "سانسکریت" },
            { "sc", "ساردینیایی" },
            { "sd", "سندی" },
            { "se", "سامی شمالی" },
            { "sg", "سانگو" },
            { "sh", "صرب و کرواتی" },
            { "si", metaValue_si },
            { "sk", metaValue_SK },
            { "sl", "اسلوونیایی" },
            { "sm", "ساموآیی" },
            { "sn", "شونایی" },
            { "so", "سومالیایی" },
            { "sq", "آلبانیایی" },
            { "sr", "صربی" },
            { "ss", "سوازیایی" },
            { "st", "سوتوی جنوبی" },
            { "su", "سوندایی" },
            { "sv", "سوئدی" },
            { "sw", "سواحیلی" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "تاجیکی" },
            { "th", metaValue_th },
            { "ti", "تیگرینیایی" },
            { "tk", "ترکمنی" },
            { "tl", metaValue_tl },
            { "tn", "تسوانایی" },
            { "to", "تونگایی" },
            { "tr", "ترکی استانبولی" },
            { "ts", "تسونگایی" },
            { "tt", "تاتاری" },
            { "tw", "توی‌یایی" },
            { "ty", "تاهیتیایی" },
            { "ug", "اویغوری" },
            { "uk", "اوکراینی" },
            { "ur", "اردو" },
            { "uz", "ازبکی" },
            { "ve", "وندایی" },
            { "vi", "ویتنامی" },
            { "vo", "ولاپوک" },
            { "wa", "والونی" },
            { "wo", "ولوفی" },
            { "xh", "خوسایی" },
            { "yi", "یدی" },
            { "yo", "یوروبایی" },
            { "za", "ژوانگی" },
            { "zh", "چینی" },
            { "zu", "زولویی" },
            { "ace", "آچئی" },
            { "ach", "آچولیایی" },
            { "ada", "آدانگمه‌ای" },
            { "ady", "آدیجیایی" },
            { "aeb", "عربی تونسی" },
            { "afh", "آفریهیلی" },
            { "agq", "آگیم" },
            { "ain", "آینویی" },
            { "akk", "اکدی" },
            { "akz", "آلابامایی" },
            { "ale", "آلئوتی" },
            { "alt", "آلتایی جنوبی" },
            { "ang", "انگلیسی باستان" },
            { "ann", "اوبولو" },
            { "anp", "آنگیکا" },
            { "arc", "آرامی" },
            { "arn", "ماپوچه‌ای" },
            { "arp", "آراپاهویی" },
            { "arq", "عربی الجزایری" },
            { "ars", "عربی نجدی" },
            { "arw", "آراواکی" },
            { "ary", "عربی مراکشی" },
            { "arz", "عربی مصری" },
            { "asa", "آسو" },
            { "ast", "آستوری" },
            { "atj", "آتیکامکو" },
            { "awa", "اودهی" },
            { "bal", "بلوچی" },
            { "ban", metaValue_ban },
            { "bar", "باواریایی" },
            { "bas", "باسایی" },
            { "bax", "بمونی" },
            { "bej", "بجایی" },
            { "bem", "بمبایی" },
            { "bez", "بنایی" },
            { "bgc", "هارایاناوی" },
            { "bgn", "بلوچی غربی" },
            { "bho", "بوجپوری" },
            { "bik", "بیکولی" },
            { "bin", "بینی" },
            { "bla", "سیکسیکا" },
            { "blo", "باسیلا" },
            { "bqi", "لری بختیاری" },
            { "bra", "براج" },
            { "brh", "براهویی" },
            { "brx", "بودویی" },
            { "bua", "بوریاتی" },
            { "bug", "بوگینس" },
            { "byn", "بلین" },
            { "cad", "کادویی" },
            { "car", "کاریبی" },
            { "cay", "کایوگا" },
            { "ccp", "چاکما" },
            { "ceb", "سبویی" },
            { "cgg", "چیگا" },
            { "chb", "چیبچا" },
            { "chg", "جغتایی" },
            { "chk", "چوکی" },
            { "chm", "ماریایی" },
            { "cho", "چوکتویی" },
            { "chp", "چیپه‌ویه‌ای" },
            { "chr", metaValue_chr },
            { "chy", "شایانی" },
            { "ckb", "کردی مرکزی" },
            { "clc", "چیلکوتن" },
            { "cop", metaValue_cop },
            { "crg", "میچیف" },
            { "crh", "ترکی کریمه" },
            { "crj", "کری جنوب شرقی" },
            { "crk", "کری صحرایی" },
            { "crl", "کری شمال شرقی" },
            { "crm", "موس کری" },
            { "crr", "آلگانکوین کارولینا" },
            { "crs", "سیشل آمیختهٔ فرانسوی" },
            { "csb", "کاشوبی" },
            { "csw", "کری سوامپی" },
            { "dak", "داکوتایی" },
            { "dar", "دارگوا" },
            { "dav", "تایتا" },
            { "del", "دلاواری" },
            { "dgr", "دوگریب" },
            { "din", "دینکایی" },
            { "dje", "زرما" },
            { "doi", "دوگری" },
            { "dsb", "صُربی سفلی" },
            { "dua", "دوآلایی" },
            { "dum", "هلندی میانه" },
            { "dyo", "دیولا فونی" },
            { "dyu", "دایولایی" },
            { "dzg", "دازاگا" },
            { "ebu", "امبو" },
            { "efi", "افیکی" },
            { "egy", "مصری کهن" },
            { "eka", "اکاجوک" },
            { "elx", "عیلامی" },
            { "enm", "انگلیسی میانه" },
            { "ewo", "اواندو" },
            { "fan", "فانگی" },
            { "fat", "فانتیایی" },
            { "fil", "فیلیپینی" },
            { "fon", "فونی" },
            { "frc", "فرانسوی کاجون" },
            { "frm", "فرانسوی میانه" },
            { "fro", "فرانسوی باستان" },
            { "frr", "فریزی شمالی" },
            { "frs", "فریزی شرقی" },
            { "fur", "فریولیایی" },
            { "gaa", "گایی" },
            { "gag", "گاگائوزیایی" },
            { "gay", "گایویی" },
            { "gba", "گبایایی" },
            { "gbz", "دری زرتشتی" },
            { "gez", "گی‌ئزی" },
            { "gil", "گیلبرتی" },
            { "glk", "گیلکی" },
            { "gmh", "آلمانی معیار میانه" },
            { "goh", "آلمانی علیای باستان" },
            { "gon", "گوندی" },
            { "gor", "گورونتالو" },
            { "got", metaValue_got },
            { "grb", "گریبویی" },
            { "grc", "یونانی کهن" },
            { "gsw", "آلمانی سوئیسی" },
            { "guz", "گوسی" },
            { "gwi", "گویچ این" },
            { "hai", "هایدایی" },
            { "haw", "هاوایی" },
            { "hax", "هایدا جنوبی" },
            { "hif", "هندی فیجیایی" },
            { "hil", "هیلی‌گاینونی" },
            { "hit", "هیتی" },
            { "hmn", "همونگ" },
            { "hsb", "صُربی علیا" },
            { "hup", "هوپا" },
            { "hur", "هالکوملم" },
            { "iba", "ایبانی" },
            { "ibb", "ایبیبیو" },
            { "ikt", "اینوکتیتوت غرب کانادا" },
            { "ilo", "ایلوکویی" },
            { "inh", "اینگوشی" },
            { "jbo", "لوجبان" },
            { "jgo", "نگومبا" },
            { "jmc", "ماچامه‌ای" },
            { "jpr", "فارسی یهودی" },
            { "jrb", "عربی یهودی" },
            { "kaa", "قره‌قالپاقی" },
            { "kab", "قبایلی" },
            { "kac", "کاچینی" },
            { "kaj", "جو" },
            { "kam", "کامبایی" },
            { "kaw", "کاویایی" },
            { "kbd", "کاباردینی" },
            { "kcg", "تیاپی" },
            { "kde", "ماکونده" },
            { "kea", "کابووردیانو" },
            { "kfo", "کورو" },
            { "kgp", "کاین گنگ" },
            { "kha", "خاسیایی" },
            { "kho", "ختنی" },
            { "khq", "کوجراچینی" },
            { "khw", "کهوار" },
            { "kiu", metaValue_ku },
            { "kkj", "کاکایی" },
            { "kln", "کالنجین" },
            { "kmb", "کیمبوندویی" },
            { "koi", "کومی پرمیاک" },
            { "kok", "کنکانی" },
            { "kpe", "کپله‌ای" },
            { "krc", "قره‌چایی‐بالکاری" },
            { "krl", "کاریلیانی" },
            { "kru", "کوروخی" },
            { "ksb", "شامبالا" },
            { "ksf", "بافیایی" },
            { "ksh", "کولش" },
            { "kum", "کومیکی" },
            { "kut", "کوتنی" },
            { "kwk", "کواک والا" },
            { "kxv", "کووی" },
            { "lad", "لادینو" },
            { "lag", "لانگی" },
            { "lah", "لاهندا" },
            { "lam", "لامبا" },
            { "lez", "لزگی" },
            { "lij", "لیگوری" },
            { "lil", "لیلوئت" },
            { "lkt", "لاکوتا" },
            { "lmo", "لومبارد" },
            { "lol", "مونگویی" },
            { "lou", "کرئول لوئیزیانا" },
            { "loz", "لوزیایی" },
            { "lrc", "لری شمالی" },
            { "lsm", "سامیا" },
            { "lua", "لوبایی‐لولوا" },
            { "lui", "لویسنو" },
            { "lun", "لوندایی" },
            { "luo", "لوئویی" },
            { "lus", "میزو" },
            { "luy", "لویا" },
            { "lzh", "چینی ادبی" },
            { "mad", "مادورایی" },
            { "mag", "ماگاهیایی" },
            { "mai", "مایدیلی" },
            { "mak", "ماکاسار" },
            { "man", "ماندینگویی" },
            { "mas", "ماسایی" },
            { "mdf", "مکشایی" },
            { "mdr", "ماندار" },
            { "men", metaValue_men },
            { "mer", "مرویی" },
            { "mfe", "موریسین" },
            { "mga", "ایرلندی میانه" },
            { "mgh", "ماکوا متو" },
            { "mgo", "متایی" },
            { "mic", "میکماکی" },
            { "min", "مینانگ‌کابویی" },
            { "mnc", "مانچویی" },
            { "mni", "مانیپوری" },
            { "moe", "اینوآیموم" },
            { "moh", "موهاکی" },
            { "mos", "ماسیایی" },
            { "mua", "ماندانگی" },
            { "mul", "چندین زبان" },
            { "mus", "کریکی" },
            { "mwl", "میراندی" },
            { "mwr", "مارواری" },
            { "myv", "ارزیایی" },
            { "mzn", "مازندرانی" },
            { "nap", "ناپلی" },
            { "naq", "نامایی" },
            { "nds", "آلمانی سفلی" },
            { "new", "نواریایی" },
            { "nia", "نیاسی" },
            { "niu", "نیویی" },
            { "nmg", "کوازیو" },
            { "nnh", "نیامبون" },
            { "nog", "نغایی" },
            { "non", "نرس باستان" },
            { "nqo", "نکو" },
            { "nso", "سوتویی شمالی" },
            { "nus", "نویر" },
            { "nwc", "نواریایی کلاسیک" },
            { "nym", "نیام‌وزیایی" },
            { "nyn", "نیانکوله‌ای" },
            { "nyo", "نیورویی" },
            { "nzi", "نزیمایی" },
            { "ojb", "اوجیبوای شمالی" },
            { "ojc", "اوجیبوای مرکزی" },
            { "ojs", "اوجی-کری" },
            { "ojw", "اوجیبوای غربی" },
            { "oka", "اوکاناگان" },
            { "osa", "اوسیجی" },
            { "ota", "ترکی عثمانی" },
            { "pag", "پانگاسینانی" },
            { "pal", "پهلوی" },
            { "pam", "پامپانگایی" },
            { "pap", "پاپیامنتو" },
            { "pau", "پالائویی" },
            { "pcm", "نیم‌زبان نیجریه‌ای" },
            { "pdc", "آلمانی پنسیلوانیایی" },
            { "peo", metaValue_peo },
            { "phn", metaValue_phn },
            { "pis", "پی‌جین" },
            { "pon", "پانپیی" },
            { "pqm", "ملیسیت - پاسماکودی" },
            { "prg", "پروسی" },
            { "pro", "پرووانسی باستان" },
            { "quc", "کیچه‌" },
            { "raj", "راجستانی" },
            { "rap", "راپانویی" },
            { "rar", "راروتونگایی" },
            { "rhg", "روهینگیا" },
            { "rof", "رومبویی" },
            { "rom", "رومانویی" },
            { "rup", "آرومانی" },
            { "rwk", "روایی" },
            { "sad", "سانداوه‌ای" },
            { "sah", "یاقوتی" },
            { "sam", "آرامی سامری" },
            { "saq", "سامبورو" },
            { "sas", "ساساکی" },
            { "sat", "سانتالی" },
            { "sba", "انگامبایی" },
            { "sbp", "سانگویی" },
            { "scn", "سیسیلی" },
            { "sco", "اسکاتلندی" },
            { "sdh", "کردی جنوبی" },
            { "seh", "سنا" },
            { "sel", "سلکوپی" },
            { "ses", "کویرابورا سنی" },
            { "sga", "ایرلندی باستان" },
            { "shi", "تاچل‌هیت" },
            { "shn", "شانی" },
            { "shu", "عربی چادی" },
            { "sid", "سیدامویی" },
            { "slh", "لاشوتسید جنوبی" },
            { "sli", "سیلزیایی سفلی" },
            { "sma", "سامی جنوبی" },
            { "smj", "لوله سامی" },
            { "smn", "ایناری سامی" },
            { "sms", "اسکولت سامی" },
            { "snk", "سونینکه‌ای" },
            { "sog", "سغدی" },
            { "srn", "زبان اسرانان" },
            { "srr", "سریری" },
            { "ssy", "ساهو" },
            { "str", "سالیش استریتز" },
            { "suk", "سوکومایی" },
            { "sus", "سوسویی" },
            { "sux", "سومری" },
            { "swb", "کوموری" },
            { "syc", "سریانی کلاسیک" },
            { "syr", metaValue_syr },
            { "szl", "سیلزیایی" },
            { "tce", "توچون جنوبی" },
            { "tem", "تمنه‌ای" },
            { "teo", "تسویی" },
            { "ter", "ترنو" },
            { "tet", "تتومی" },
            { "tgx", "تاگیش" },
            { "tht", "تالتان" },
            { "tig", "تیگره‌ای" },
            { "tiv", "تیوی" },
            { "tlh", "کلینگون" },
            { "tli", "تلین‌گیتی" },
            { "tmh", "تاماشقی" },
            { "tog", "تونگایی نیاسا" },
            { "tok", "توکی پونا" },
            { "tpi", "توک‌پیسینی" },
            { "trv", "تاروکویی" },
            { "tsi", "تسیم‌شیانی" },
            { "ttm", "تاچونی شمالی" },
            { "tum", "تومبوکایی" },
            { "tvl", "تووالویی" },
            { "twq", "تسواکی" },
            { "tyv", "تووایی" },
            { "tzm", "آمازیغی اطلس مرکزی" },
            { "udm", "اودمورتی" },
            { "uga", metaValue_uga },
            { "umb", "امبوندویی" },
            { "und", "زبان نامشخص" },
            { "vai", metaValue_vai },
            { "vec", "ونیزی" },
            { "vmw", "ماکوا" },
            { "vot", "وتی" },
            { "vun", "ونجو" },
            { "wae", "والسر" },
            { "wal", "والامو" },
            { "war", "وارایی" },
            { "was", "واشویی" },
            { "wbp", "وارلپیری" },
            { "wuu", "وو چینی" },
            { "xal", "قلموقی" },
            { "xnr", "کانگری" },
            { "xog", "سوگایی" },
            { "yao", "یائویی" },
            { "yap", "یاپی" },
            { "yav", "یانگبنی" },
            { "ybb", "یمبایی" },
            { "yrl", "نهین گاتو" },
            { "yue", "کانتونی" },
            { "zap", "زاپوتکی" },
            { "zen", "زناگا" },
            { "zgh", "آمازیغی معیار مراکش" },
            { "zun", "زونیایی" },
            { "zxx", "بدون محتوای زبانی" },
            { "zza", "زازایی" },
            { "Adlm", "آدلام" },
            { "Aghb", "آلبانیایی قفقازی" },
            { "Arab", metaValue_ar },
            { "Aran", "آران" },
            { "Armi", "آرامی هخامنشی" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "باتاکی" },
            { "Beng", metaValue_bn },
            { "Blis", "نمادهای بلیس" },
            { "Bopo", "بوپوموفو" },
            { "Brah", "براهمی" },
            { "Brai", "بریل" },
            { "Bugi", "بوگیایی" },
            { "Buhd", "بوهید" },
            { "Cakm", "چاکمایی" },
            { "Cans", "زبان‌های سیلابی بومی‌های متحد کانادایی" },
            { "Cari", "کاری" },
            { "Cham", "چمی" },
            { "Cher", metaValue_chr },
            { "Cirt", "کرت" },
            { "Copt", metaValue_cop },
            { "Cprt", "قبرسی" },
            { "Cyrl", "سیریلی" },
            { "Deva", "دوناگری" },
            { "Dsrt", "دیسرتی" },
            { "Egyh", "کاهنی مصری" },
            { "Egyp", "هیروگلیف مصری" },
            { "Ethi", "اتیوپیایی" },
            { "Geok", "گرجی خوتسوری" },
            { "Geor", metaValue_ka },
            { "Glag", "گلاگولیتی" },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "گورومخی" },
            { "Hanb", "هان با بوموپوفو" },
            { "Hang", "هانگول" },
            { "Hani", "هان" },
            { "Hano", "هانونویی" },
            { "Hans", "ساده‌شده" },
            { "Hant", "سنتی" },
            { "Hebr", metaValue_he },
            { "Hira", "هیراگانا" },
            { "Hluw", "هیروگلیف آناتولی" },
            { "Hrkt", "هجانگاری ژاپنی" },
            { "Hung", "مجاری باستان" },
            { "Inds", "ایندوس" },
            { "Ital", "ایتالی باستان" },
            { "Jamo", "جامو" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kali", "کایالی" },
            { "Kana", "کاتاکانا" },
            { "Khmr", metaValue_km },
            { "Khoj", "خواجکی" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "کثی" },
            { "Lana", "لانایی" },
            { "Laoo", metaValue_lo },
            { "Latf", "لاتینی فراکتور" },
            { "Latg", "لاتینی گیلی" },
            { "Latn", metaValue_la },
            { "Limb", "لیمبایی" },
            { "Lina", "خطی الف" },
            { "Linb", "خطی ب" },
            { "Lyci", "لسیایی" },
            { "Lydi", "لدیایی" },
            { "Mand", metaValue_men },
            { "Mani", "مانوی" },
            { "Maya", "هیروگلیف مایایی" },
            { "Mero", "مروییتی" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "مونی" },
            { "Mtei", "مایک میتی" },
            { "Mymr", "میانمار" },
            { "Narb", "عربی شمالی باستان" },
            { "Nbat", "نبطی" },
            { "Nkoo", "اِن کو" },
            { "Ogam", "اوگامی" },
            { "Olck", "اول چیکی" },
            { "Orkh", "اورخونی" },
            { "Orya", "اودیه" },
            { "Palm", "پالمیرایی" },
            { "Perm", "پرمی باستان" },
            { "Phli", "پهلوی کتیبه‌ای" },
            { "Phlp", "پهلوی زبوری" },
            { "Phlv", "پهلوی کتابی" },
            { "Phnx", metaValue_phn },
            { "Prti", "پارتی کتیبه‌ای" },
            { "Rjng", "رجنگی" },
            { "Rohg", "حنیفی" },
            { "Runr", "رونی" },
            { "Samr", "سامری" },
            { "Sara", "ساراتی" },
            { "Sarb", "عربی جنوبی باستان" },
            { "Saur", "سوراشترایی" },
            { "Shaw", "شاوی" },
            { "Sinh", metaValue_si },
            { "Sund", "سوندانی" },
            { "Sylo", "سیلوتی نگاری" },
            { "Syrc", metaValue_syr },
            { "Syre", "سریانی سطرنجیلی" },
            { "Syrj", "سریانی غربی" },
            { "Syrn", "سریانی شرقی" },
            { "Tagb", "تگبنوایی" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Teng", "تنگوار" },
            { "Tfng", "تیفیناغی" },
            { "Tglg", metaValue_tl },
            { "Thaa", "تانا" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "گفتار قابل مشاهده" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "میخی سومری‐اکدی" },
            { "Yiii", "یی" },
            { "Zinh", "موروثی" },
            { "Zmth", "علائم ریاضی" },
            { "Zsye", "اموجی" },
            { "Zsym", "علائم" },
            { "Zxxx", "نانوشته" },
            { "Zyyy", "مشترک" },
            { "Zzzz", "خط نامشخص" },
            { "de_AT", "آلمانی اتریش" },
            { "de_CH", "آلمانی معیار سوئیس" },
            { "en_AU", "انگلیسی استرالیا" },
            { "en_CA", "انگلیسی کانادا" },
            { "en_GB", "انگلیسی بریتانیا" },
            { "en_US", "انگلیسی آمریکا" },
            { "es_ES", "اسپانیایی اروپا" },
            { "es_MX", "اسپانیایی مکزیک" },
            { "fa_AF", "دری" },
            { "fr_CA", "فرانسوی کانادا" },
            { "fr_CH", "فرانسوی سوئیس" },
            { "nl_BE", "فلمنگی" },
            { "pt_BR", "پرتغالی برزیل" },
            { "pt_PT", "پرتغالی اروپا" },
            { "ro_MD", "مولداویایی" },
            { "sw_CD", "سواحیلی کنگو" },
            { "%%1901", "رسم‌الخط سنتی آلمانی" },
            { "%%1996", "رسم‌الخط آلمانی ۱۹۹۶ میلادی" },
            { "ar_001", "عربی رسمی" },
            { "es_419", "اسپانیایی امریکای لاتین" },
            { "key.ca", "تقویم" },
            { "key.cf", "قالب واحد پول" },
            { "key.co", "ترتیب" },
            { "key.cu", "واحد پول" },
            { "key.em", "نمایش اموجی" },
            { "key.hc", "دور ساعت (۱۲ در مقابل ۲۴)" },
            { "key.lb", "شیوهٔ سطرشکنی" },
            { "key.lw", "شکست خط داخل کلمات" },
            { "key.ms", "دستگاه اندازه‌گیری" },
            { "key.nu", "اعداد" },
            { "key.ss", "شکست جمله پس از مخفف" },
            { "key.tz", "منطقهٔ زمانی" },
            { "key.va", "متغیر محلی" },
            { "nds_NL", "ساکسونی سفلی" },
            { "%%KSCOR", "رسم‌الخط استاندارد" },
            { "%%POSIX", "کامپیوتری" },
            { "%%ROZAJ", "روژان" },
            { "%%SAAHO", "ساهویی" },
            { "az_Arab", "ترکی آذری جنوبی" },
            { "zh_Hans", "چینی ساده‌شده" },
            { "zh_Hant", "چینی سنتی" },
            { "%%FONIPA", "فونتیک IPA" },
            { "%%FONUPA", "فونتیک UPA" },
            { "%%AREVELA", "ارمنی شرقی" },
            { "%%AREVMDA", "ارمنی غربی" },
            { "%%REVISED", "رسم‌الخط تجدیدنظرشده" },
            { "%%COLB1945", "کنوانسیون رسم‌الخط پرتغال و برزیل در ۱۹۴۵" },
            { "%%OXENDICT", "املای فرهنگ انگلیسی آکسفورد" },
            { "%%SCOTLAND", "انگلیسی معیار اسکاتلند" },
            { "type.ca.roc", "تقویم جمهوری چین (تایوان)" },
            { "type.co.eor", "قوانین ترتیب اروپایی" },
            { "type.hc.h11", "سیستم ۱۲ ساعته (۰ تا ۱۱)" },
            { "type.hc.h12", "سیستم ۱۲ ساعته (۱ تا ۱۲)" },
            { "type.hc.h23", "سیستم ۲۴ ساعته (۰ تا ۲۳)" },
            { "type.hc.h24", "سیستم ۲۴ ساعته (۱ تا ۲۴)" },
            { "type.m0.bgn", "ترانویسی انجمن نام‌های جغرافیایی ایالات متحده" },
            { "type.nu.arab", "ارقام عربی" },
            { "type.nu.armn", "اعداد ارمنی" },
            { "type.nu.bali", "ارقام بالیایی" },
            { "type.nu.beng", "ارقام بنگالی" },
            { "type.nu.brah", "ارقام برهمایی" },
            { "type.nu.cakm", "ارقام چاکما" },
            { "type.nu.cyrl", "ارقام سیریلیک" },
            { "type.nu.deva", "ارقام دوناگری" },
            { "type.nu.ethi", "اعداد اتیوپیایی" },
            { "type.nu.geor", "اعداد گرجی" },
            { "type.nu.grek", "اعداد یونانی" },
            { "type.nu.gujr", "ارقام گجراتی" },
            { "type.nu.guru", "ارقام گورومخی" },
            { "type.nu.hans", "اعداد چینی ساده‌شده" },
            { "type.nu.hant", "اعداد چینی سنتی" },
            { "type.nu.hebr", "اعداد عبری" },
            { "type.nu.java", "ارقام جاوه‌ای" },
            { "type.nu.jpan", "اعداد ژاپنی" },
            { "type.nu.khmr", "ارقام خمری" },
            { "type.nu.knda", "ارقام کاناده‌ای" },
            { "type.nu.laoo", "ارقام لائوسی" },
            { "type.nu.latn", "ارقام غربی" },
            { "type.nu.mlym", "ارقام مالایالامی" },
            { "type.nu.mong", "ارقام مغولی" },
            { "type.nu.mtei", "ارقام میتی مایک" },
            { "type.nu.mymr", "ارقام میانماری" },
            { "type.nu.olck", "ارقام اول چیکی" },
            { "type.nu.orya", "ارقام اودیه" },
            { "type.nu.taml", "اعداد سنتی تامیلی" },
            { "type.nu.telu", "ارقام تلوگویی" },
            { "type.nu.thai", "ارقام تایلندی" },
            { "type.nu.tibt", "ارقام تبتی" },
            { "type.nu.vaii", "ارقام وایی" },
            { "type.ca.dangi", "تقویم دانگی" },
            { "type.co.ducet", "ترتیب پیش‌فرض یونی‌کد" },
            { "type.co.emoji", "ترتیب ایموجی" },
            { "type.lb.loose", "شیوهٔ سطرشکنی سهل‌گیرانه" },
            { "type.nu.roman", "اعداد رومی" },
            { "type.ca.coptic", "تقویم قبطی" },
            { "type.ca.hebrew", "تقویم عبری" },
            { "type.ca.indian", "تقویم ملی هند" },
            { "type.co.compat", "ترتیب پیشین، برای سازگاری" },
            { "type.co.pinyin", "ترتیب پین‌یین" },
            { "type.co.search", "جستجوی عمومی" },
            { "type.co.stroke", "ترتیب حرکتی" },
            { "type.co.unihan", "ترتیب رادیکالی-حرکتی" },
            { "type.co.zhuyin", "ترتیب ژویین" },
            { "type.d0.fwidth", "تمام‌عرض" },
            { "type.d0.hwidth", "نیم‌عرض" },
            { "type.lb.normal", "شیوهٔ سطرشکنی عادی" },
            { "type.lb.strict", "شیوهٔ سطرشکنی سخت‌گیرانه" },
            { "type.m0.ungegn", "ترانویسی گروه نام‌های جغرافیایی سازمان ملل" },
            { "type.ms.metric", "دستگاه متریک" },
            { "type.nu.native", "ارقام بومی" },
            { "type.ca.chinese", "تقویم چینی" },
            { "type.ca.islamic", "تقویم هجری قمری" },
            { "type.ca.iso8601", "تقویم ایزو ۸۶۰۱" },
            { "type.ca.persian", "تقویم هجری شمسی" },
            { "type.cf.account", "قالب حسابداری واحد پول" },
            { "type.d0.npinyin", "سیستم اعداد" },
            { "type.nu.arabext", "ارقام فارسی" },
            { "type.nu.armnlow", "اعداد ارمنی با حروف کوچک" },
            { "type.nu.finance", "سیستم عددی مالی" },
            { "type.nu.greklow", "اعداد یونانی با حروف کوچک" },
            { "type.nu.hanidec", "اعداد دهدهی چینی" },
            { "type.nu.hansfin", "اعداد مالی چینی ساده‌شده" },
            { "type.nu.hantfin", "اعداد مالی چینی سنتی" },
            { "type.nu.jpanfin", "اعداد مالی ژاپنی" },
            { "type.nu.tamldec", "ارقام تامیلی" },
            { "type.ca.buddhist", "تقویم بودایی" },
            { "type.ca.ethiopic", "تقویم اتیوپیایی" },
            { "type.ca.japanese", "تقویم ژاپنی" },
            { "type.cf.standard", "قالب استاندارد واحد پول" },
            { "type.co.phonetic", "مرتب کردن بر اساس آوایی" },
            { "type.co.searchjl", "جستجو با صامت اول هانگول" },
            { "type.co.standard", "ترتیب استاندارد" },
            { "type.ms.uksystem", "سیستم اندازه‌گیری انگلیسی" },
            { "type.ms.ussystem", "سیستم اندازه‌گیری امریکایی" },
            { "type.nu.fullwide", "ارقام تمام‌عرض" },
            { "type.nu.mathbold", "ارقام ریاضی سیاه" },
            { "type.nu.mathsanb", "ارقام ریاضی سیاه بی‌سریف" },
            { "type.nu.mathsans", "ارقام ریاضی بی‌سریف" },
            { "type.nu.mymrshan", "ارقام شان میانماری" },
            { "type.nu.romanlow", "اعداد رومی با حروف کوچک" },
            { "type.ca.gregorian", "تقویم میلادی" },
            { "type.co.phonebook", "ترتیب دفتر تلفن" },
            { "type.co.dictionary", "ترتیب فرهنگ لغت" },
            { "type.co.traditional", "ترتیب سنتی" },
            { "type.nu.traditional", "سیستم اعداد سنتی" },
            { "type.ca.islamic-rgsa", "قویم هجری قمری هلالی عربستان سعودی" },
            { "type.ca.islamic-tbla", "تقویم هجری قمری جدولی نجومی" },
            { "type.ca.islamic-civil", "تقویم هجری قمری جدولی مدنی" },
            { "ListCompositionPattern", "{0}، {1}" },
            { "type.ca.islamic-umalqura", "تقویم هجری قمری ام‌القری" },
            { "type.ca.ethiopic-amete-alem", "تقویم اتیوپیایی عامت عالم" },
        };
        return data;
    }
}
