/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.utils;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.converters.StringToInteger;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class StyleHelper {
    public static boolean isMenuBar(Menu menu) {
        return StyleHelper.checkStyle((Widget)menu, 2);
    }

    public static boolean isOnMenubar(MenuItem menuItem) {
        return StyleHelper.isMenuBar(menuItem.getParent());
    }

    public static boolean checkStyle(Widget widget, int style) {
        return widget != null && !widget.isDisposed() && StyleHelper.checkStyle(widget.getStyle(), style);
    }

    public static boolean checkStyle(int styles, String style) {
        if ("SHELL_TRIM".equalsIgnoreCase(style) || "SWT.SHELL_TRIM".equalsIgnoreCase(style)) {
            return StyleHelper.checkStyle(styles, 64) && StyleHelper.checkStyle(styles, 128) && StyleHelper.checkStyle(styles, 1024) && StyleHelper.checkStyle(styles, 32) && StyleHelper.checkStyle(styles, 16);
        }
        if ("DIALOG_TRIM".equalsIgnoreCase(style) || "SWT.DIALOG_TRIM".equalsIgnoreCase(style)) {
            return StyleHelper.checkStyle(styles, 64) && StyleHelper.checkStyle(styles, 32) && StyleHelper.checkStyle(styles, 2048);
        }
        int value = (Integer)StringToInteger.instance.convert((Object)style);
        return StyleHelper.checkStyle(styles, value);
    }

    public static boolean checkStyle(int styles, int style) {
        return (styles & style) != 0;
    }

    public static boolean checkStyle(XamlNode node, int style) {
        return StyleHelper.checkStyle(StyleHelper.getStyle(node), style);
    }

    public static int getStyle(XamlNode node) {
        if (node == null) {
            return 0;
        }
        XamlAttribute attribute = node.getAttribute("style", "http://www.eclipse.org/xwt");
        if (attribute != null && attribute.getValue() != null) {
            String styleValue = attribute.getValue();
            IConverter c = XWT.findConvertor(String.class, Integer.class);
            if (c != null) {
                return (Integer)c.convert((Object)styleValue);
            }
        }
        return 0;
    }
}

