/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies.layout.grid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.policies.layout.grid.IGridListener;

public class GridController {
    public static final String GRID_KEY = "org.soyatec.xaml.ve.xwt.editpolicies.gridlayout.gridkey";
    private boolean showGrid = false;
    private int gridWidth = 15;
    private int gridHeight = 15;
    private int gridMargin = 0;
    private List<IGridListener> listeners = new ArrayList<IGridListener>();
    protected Map<EditPart, GridController> registeredEPs = new HashMap<EditPart, GridController>(2);

    public void addGridListener(IGridListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeGridListener(IGridListener listener) {
        this.listeners.remove(listener);
    }

    public void setGridShowing(boolean showGrid) {
        this.showGrid = showGrid;
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).gridVisibilityChanged(showGrid);
            ++i;
        }
    }

    public boolean isGridShowing() {
        return this.showGrid;
    }

    public void setGridWidth(int gridWidth) {
        int oldGridWidth = this.gridWidth;
        this.gridWidth = gridWidth;
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).gridWidthChanged(gridWidth, oldGridWidth);
            ++i;
        }
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public void setGridHeight(int gridHeight) {
        int oldGridHeight = this.gridHeight;
        this.gridHeight = gridHeight;
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).gridHeightChanged(gridHeight, oldGridHeight);
            ++i;
        }
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridMargin(int gridMargin) {
        int oldGridMargin = this.gridMargin;
        this.gridMargin = gridMargin;
        int i = 0;
        while (i < this.listeners.size()) {
            this.listeners.get(i).gridMarginChanged(gridMargin, oldGridMargin);
            ++i;
        }
    }

    public int getGridMargin() {
        return this.gridMargin;
    }

    public static GridController getGridController(EditPart editPart) {
        EditPartViewer viewer = editPart.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, (Object)GRID_KEY);
        if (gc != null) {
            return gc.registeredEPs.get(editPart);
        }
        return null;
    }

    public static void registerEditPart(EditPart ep, GridController newgc) {
        EditPartViewer viewer = ep.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, (Object)GRID_KEY);
        if (gc != null) {
            gc.registeredEPs.put(ep, newgc);
        }
    }

    public static void unregisterEditPart(EditPart ep) {
        EditPartViewer viewer = ep.getRoot().getViewer();
        EditDomain dom = (EditDomain)viewer.getEditDomain();
        GridController gc = (GridController)dom.getViewerData(viewer, (Object)GRID_KEY);
        if (gc != null && gc.registeredEPs.get(ep) != null) {
            gc.registeredEPs.remove(ep);
        }
    }
}

