/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.handles.NonResizableHandleKit;
import org.eclipse.gef.handles.ResizableHandleKit;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.xwt.tools.ui.designer.utils.OffsetUtil;

public class NewResizableEditPolicy
extends ResizableEditPolicy {
    protected static final int WIDTH = 50;
    protected static final int HEIGHT = 16;
    private boolean diaplayNonHandles = true;
    private Label tooltip;

    public NewResizableEditPolicy(int directions, boolean displayNonHandles) {
        this.setResizeDirections(directions);
        this.diaplayNonHandles = displayNonHandles;
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        int directions = this.getResizeDirections();
        if (directions == 0 && this.diaplayNonHandles) {
            NonResizableHandleKit.addHandles((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
        } else if (directions != -1) {
            ResizableHandleKit.addMoveHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list);
            if ((directions & 0x10) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)16);
            }
            if ((directions & 0x14) == 20) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)20);
            }
            if ((directions & 4) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)4);
            }
            if ((directions & 0xC) == 12) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)12);
            }
            if ((directions & 8) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)8);
            }
            if ((directions & 9) == 9) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)9);
            }
            if ((directions & 1) != 0) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)1);
            }
            if ((directions & 0x11) == 17) {
                ResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            } else if (this.diaplayNonHandles) {
                NonResizableHandleKit.addHandle((GraphicalEditPart)((GraphicalEditPart)this.getHost()), list, (int)17);
            }
        }
        return list;
    }

    protected Label getToolTip() {
        if (this.tooltip == null) {
            this.tooltip = new Label();
        }
        if (this.tooltip.getParent() == null) {
            this.addFeedback((IFigure)this.tooltip);
        }
        return this.tooltip;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        Rectangle init = this.getInitialFeedbackBounds().getCopy();
        PrecisionRectangle rect = new PrecisionRectangle(init);
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        Point remove = request.getMoveDelta();
        rect.translate(remove);
        Dimension resize = request.getSizeDelta();
        rect.resize(resize);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
        Point p = rect.getRight();
        int directions = request.getResizeDirection();
        if (directions != -1) {
            if ((directions & 0x14) == 20) {
                p = rect.getLocation().getTranslated(rect.width, rect.height);
            } else if ((directions & 0xC) == 12) {
                p = rect.getLocation().getTranslated(-50, rect.height);
            } else if ((directions & 9) == 9) {
                p = rect.getLocation().getTranslated(-50, -16);
            } else if ((directions & 0x11) == 17) {
                p = rect.getLocation().getTranslated(rect.width, -16);
            } else if ((directions & 4) != 0) {
                p = rect.getLocation().getTranslated((rect.width - 50) / 2, rect.height);
            } else if ((directions & 0x10) != 0) {
                p = rect.getLocation().getTranslated(rect.width, rect.height / 2);
            } else if ((directions & 8) != 0) {
                p = rect.getLocation().getTranslated(-50, rect.height / 2);
            } else if ((directions & 1) != 0) {
                p = rect.getLocation().getTranslated((rect.width - 50) / 2, -16);
            }
        }
        Dimension size = new Dimension(50, 16);
        Label tip = this.getToolTip();
        tip.setBounds(new Rectangle(p, size));
        if (resize != null && (resize.width != 0 || resize.height != 0)) {
            tip.setForegroundColor(ColorConstants.black);
            tip.setText(String.valueOf(init.width + resize.width) + "," + (init.height + resize.height));
        } else if (remove != null && (remove.x != 0 || remove.y != 0)) {
            tip.setForegroundColor(ColorConstants.blue);
            Point moveTo = init.getLocation();
            this.getHostFigure().translateToAbsolute((Translatable)moveTo);
            moveTo = moveTo.getTranslated(remove);
            this.getHostFigure().translateToRelative((Translatable)moveTo);
            p = ((GraphicalEditPart)this.getHost().getParent()).getContentPane().getClientArea().getLocation().getNegated();
            moveTo.translate(p);
            int xOffset = OffsetUtil.getXOffset(this.getHost().getParent());
            int yOffset = OffsetUtil.getYOffset(this.getHost().getParent());
            moveTo.translate(-xOffset, -yOffset);
            tip.setText(String.valueOf(moveTo.x) + "," + moveTo.y);
        }
    }

    protected void eraseChangeBoundsFeedback(ChangeBoundsRequest request) {
        super.eraseChangeBoundsFeedback(request);
        if (this.tooltip != null && this.tooltip.getParent() != null) {
            this.removeFeedback((IFigure)this.tooltip);
        }
    }
}

