/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.layouts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutDataType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class LayoutsHelper {
    public static List<LayoutType> layoutsList = new ArrayList<LayoutType>();

    static {
        layoutsList.add(LayoutType.NullLayout);
        layoutsList.add(LayoutType.FillLayout);
        layoutsList.add(LayoutType.FormLayout);
        layoutsList.add(LayoutType.GridLayout);
        layoutsList.add(LayoutType.RowLayout);
        layoutsList.add(LayoutType.StackLayout);
    }

    public static LayoutType getLayoutType(EditPart editPart) {
        if (editPart instanceof CompositeEditPart) {
            Layout layout = ((CompositeEditPart)editPart).getLayout();
            return LayoutsHelper.getLayoutType(layout);
        }
        return LayoutType.Unknown;
    }

    public static LayoutDataType getLayoutDataType(EditPart editPart) {
        if (editPart == null) {
            return LayoutDataType.Unknown;
        }
        EditPart parent = editPart.getParent();
        LayoutType layoutType = LayoutsHelper.getLayoutType(parent);
        if (LayoutType.GridLayout == layoutType) {
            return LayoutDataType.GridData;
        }
        if (LayoutType.RowLayout == layoutType) {
            return LayoutDataType.RowData;
        }
        if (LayoutType.FormLayout == layoutType) {
            return LayoutDataType.FormData;
        }
        return LayoutDataType.Unknown;
    }

    public static LayoutType getLayoutType(Layout layout) {
        if (layout == null) {
            return LayoutType.NullLayout;
        }
        if (layout instanceof GridLayout) {
            return LayoutType.GridLayout;
        }
        if (layout instanceof FillLayout) {
            return LayoutType.FillLayout;
        }
        if (layout instanceof RowLayout) {
            return LayoutType.RowLayout;
        }
        if (layout instanceof StackLayout) {
            return LayoutType.StackLayout;
        }
        if (layout instanceof FormLayout) {
            return LayoutType.FormLayout;
        }
        return LayoutType.NullLayout;
    }

    public static LayoutType getLayoutType(String value) {
        LayoutType[] values;
        if (value == null) {
            return LayoutType.NullLayout;
        }
        LayoutType[] layoutTypeArray = values = LayoutType.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            LayoutType layoutType = layoutTypeArray[n2];
            if (value.equals(layoutType.value())) {
                return layoutType;
            }
            ++n2;
        }
        return LayoutType.Unknown;
    }

    public static LayoutType getLayoutType(XamlElement element) {
        IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)element);
        if (metaclass == null || !Composite.class.isAssignableFrom(metaclass.getType())) {
            return LayoutType.Unknown;
        }
        XamlAttribute attribute = element.getAttribute("layout");
        if (attribute == null || attribute.getChildNodes().isEmpty()) {
            return LayoutType.NullLayout;
        }
        String name = ((XamlElement)attribute.getChildNodes().get(0)).getName();
        return LayoutsHelper.getLayoutType(name);
    }

    public static LayoutType getLayoutType(Object object) {
        if (object == null) {
            return LayoutType.NullLayout;
        }
        if (object instanceof LayoutType) {
            return (LayoutType)((Object)object);
        }
        if (object instanceof String) {
            return LayoutsHelper.getLayoutType((String)object);
        }
        if (object instanceof EditPart) {
            return LayoutsHelper.getLayoutType((EditPart)object);
        }
        if (object instanceof Layout) {
            return LayoutsHelper.getLayoutType((Layout)object);
        }
        if (object instanceof XamlElement) {
            return LayoutsHelper.getLayoutType((XamlElement)object);
        }
        return LayoutType.Unknown;
    }

    public static boolean isLayoutNode(XamlNode node) {
        if (node == null || !(node instanceof XamlAttribute)) {
            return false;
        }
        return "layout".equalsIgnoreCase(node.getName());
    }

    public static boolean canSetLayout(EditPart host) {
        if (host == null || host.getModel() == null) {
            return false;
        }
        return LayoutsHelper.canSetLayout(host.getModel());
    }

    public static boolean canSetLayout(Object model) {
        if (model == null) {
            return false;
        }
        if (model instanceof XamlElement) {
            XamlElement XamlElement2 = (XamlElement)model;
            String name = XamlElement2.getName();
            String namespace = XamlElement2.getNamespace();
            try {
                IMetaclass metaclass = XWT.getMetaclass((String)name, (String)namespace);
                if (metaclass != null) {
                    Class type = metaclass.getType();
                    return type != null && Composite.class.isAssignableFrom(type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

