/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class DeleteCommand
extends Command {
    private List<XamlNode> deleteNodes;
    private Map<EObject, DeleteData> deletedObjects = new HashMap<EObject, DeleteData>(1);

    public DeleteCommand(List deleteNodes) {
        this.deleteNodes = this.convertNodes(deleteNodes);
    }

    public DeleteCommand(XamlNode singleNode) {
        this(Collections.singletonList(singleNode));
    }

    private List<XamlNode> convertNodes(List deleteNodes) {
        if (deleteNodes == null) {
            return null;
        }
        ArrayList<XamlNode> nodes = new ArrayList<XamlNode>();
        for (Object obj : deleteNodes) {
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (!(obj instanceof XamlNode)) continue;
            nodes.add((XamlNode)obj);
        }
        return nodes;
    }

    public boolean canExecute() {
        return this.deleteNodes != null && !this.deleteNodes.isEmpty();
    }

    public void execute() {
        for (XamlNode deleted : this.deleteNodes) {
            DeleteData dd = new DeleteData();
            dd.parent = deleted.eContainer();
            if (deleted instanceof XamlElement) {
                if (dd.parent instanceof XamlNode) {
                    dd.index = ((XamlNode)dd.parent).getChildNodes().indexOf((Object)deleted);
                    if (dd.index > -1) {
                        ((XamlNode)dd.parent).getChildNodes().remove(dd.index);
                    }
                } else if (dd.parent instanceof XamlDocument) {
                    ((XamlDocument)dd.parent).setRootElement(null);
                }
            } else if (deleted instanceof XamlAttribute && dd.parent instanceof XamlNode) {
                dd.index = ((XamlNode)dd.parent).getAttributes().indexOf((Object)deleted);
                if (dd.index > -1) {
                    ((XamlNode)dd.parent).getAttributes().remove(dd.index);
                }
            }
            this.deletedObjects.put((EObject)deleted, dd);
        }
    }

    public boolean canUndo() {
        return !this.deletedObjects.isEmpty();
    }

    public void undo() {
        Set<EObject> deletedKeys = this.deletedObjects.keySet();
        for (EObject deleted : deletedKeys) {
            DeleteData dd = this.deletedObjects.get(deleted);
            if (dd == null) continue;
            EObject parent = dd.parent;
            int index = dd.index;
            if (deleted instanceof XamlElement) {
                if (parent instanceof XamlNode) {
                    if (index > -1) {
                        ((XamlNode)parent).getChildNodes().add(index, (Object)((XamlElement)deleted));
                        continue;
                    }
                    ((XamlNode)parent).getChildNodes().add((Object)((XamlElement)deleted));
                    continue;
                }
                if (!(parent instanceof XamlDocument)) continue;
                ((XamlDocument)parent).setRootElement((XamlElement)deleted);
                continue;
            }
            if (!(deleted instanceof XamlAttribute) || !(parent instanceof XamlNode)) continue;
            if (index > -1) {
                ((XamlNode)parent).getAttributes().add(index, (Object)((XamlAttribute)deleted));
                continue;
            }
            ((XamlNode)parent).getAttributes().add((Object)((XamlAttribute)deleted));
        }
        deletedKeys.clear();
        this.deletedObjects.clear();
    }

    private static class DeleteData {
        EObject parent;
        int index = -1;

        private DeleteData() {
        }
    }
}

