/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.clipboard.ComponentInfoMemento;
import org.eclipse.wb.internal.core.model.clipboard.JavaInfoMemento;
import org.eclipse.wb.internal.core.utils.check.AssertionFailedException;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.model.parser.AbstractJavaInfoTest;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClipboardTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
    }

    @Test
    public void test_properties_String() throws Exception {
        this.check_propertiesPaste("setText(\"My button\")");
    }

    @Test
    public void test_properties_boolean() throws Exception {
        this.check_propertiesPaste("setEnabled(false)");
    }

    @Test
    public void test_properties_Color_new() throws Exception {
        this.check_propertiesPaste("setBackground(new Color(null, 1, 2, 3))");
    }

    @Test
    public void test_properties_Color_system() throws Exception {
        this.check_propertiesPaste("setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_RED))");
    }

    @Test
    public void test_properties_Color_systemInt() throws Exception {
        this.check_propertiesPaste("setBackground(Display.getCurrent().getSystemColor(3))", "setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_RED))");
    }

    @Test
    public void test_properties_Font_new() throws Exception {
        this.check_propertiesPaste("setFont(new Font(null, \"Arial\", 12, SWT.BOLD))");
    }

    @Test
    public void test_properties_Font_JFaceResources() throws Exception {
        this.check_propertiesPaste("setFont(JFaceResources.getHeaderFont())");
    }

    @Test
    public void test_properties_Image_null() throws Exception {
        this.check_propertiesPaste("setImage(null)");
    }

    @Test
    public void test_properties_Image_newFile() throws Exception {
        this.check_propertiesPaste("setImage(new Image(null, \"c:/1.png\"))");
    }

    @Test
    public void test_properties_Image_newClasspath() throws Exception {
        this.check_propertiesPaste("setImage(new Image(null, Test.class.getResourceAsStream(\"/resources/1.png\")))");
    }

    @Test
    public void test_properties_Image_newClasspath_otherClass() throws Exception {
        this.check_propertiesPaste("setImage(new Image(null, test.Test.class.getResourceAsStream(\"/resources/1.png\")))", "setImage(new Image(null, Test.class.getResourceAsStream(\"/resources/1.png\")))");
    }

    private void check_propertiesPaste(String invocationCode) throws Exception {
        this.check_propertiesPaste(invocationCode, invocationCode);
    }

    private void check_propertiesPaste(String invocationCode_1, String invocationCode_2) throws Exception {
        this.m_waitForAutoBuild = true;
        final CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.BORDER | SWT.CHECK);", "      button." + invocationCode_1 + ";", "    }", "  }", "}");
        final RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)button);
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ControlInfo button = (ControlInfo)memento.create((JavaInfo)shell);
                rowLayout.command_CREATE(button, null);
                memento.apply();
            }
        });
        this.assertEditor("class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.BORDER | SWT.CHECK);", "      button." + invocationCode_1 + ";", "    }", "    {", "      Button button = new Button(this, SWT.BORDER | SWT.CHECK);", "      button." + invocationCode_2 + ";", "    }", "  }", "}");
    }

    @Test
    public void test_liveImageSize() throws Exception {
        final CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 20, 200, 100);", "    }", "  }", "}");
        final AbsoluteLayoutInfo absoluteLayout = (AbsoluteLayoutInfo)shell.getLayout();
        shell.refresh();
        final ControlInfo sourceControl = (ControlInfo)shell.getChildrenControls().get(0);
        final ComponentInfoMemento memento = (ComponentInfoMemento)JavaInfoMemento.createMemento((JavaInfo)sourceControl);
        ClipboardTest.assertNotNull((Object)memento.getImage());
        ClipboardTest.assertFalse((boolean)memento.getImage().isDisposed());
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                ControlInfo control = (ControlInfo)memento.create((JavaInfo)shell);
                ClipboardTest.assertNotNull((Object)control.getImage());
                ClipboardTest.assertEquals((Object)new Dimension(200, 100), (Object)control.getPreferredSize());
                Rectangle bounds = control.getBounds();
                ClipboardTest.assertEquals((Object)new Dimension(200, 100), (Object)bounds.getSize());
                ClipboardTest.assertEquals((int)(10 + shell.getClientAreaInsets().left), (int)bounds.x);
                ClipboardTest.assertEquals((int)(20 + shell.getClientAreaInsets().top), (int)bounds.y);
                ClipboardTest.assertEquals((Object)sourceControl.getAbsoluteBounds(), (Object)bounds);
                absoluteLayout.commandCreate(control, null);
                memento.apply();
                ClipboardTest.assertTrue((boolean)memento.getImage().isDisposed());
            }
        });
    }

    @Test
    public void test_asserts() throws Exception {
        final CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 20, 200, 100);", "    }", "  }", "}");
        final AbsoluteLayoutInfo absoluteLayout = (AbsoluteLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo sourceControl = (ControlInfo)shell.getChildrenControls().get(0);
        final JavaInfoMemento memento = JavaInfoMemento.createMemento((JavaInfo)sourceControl);
        ExecutionUtils.run((ObjectInfo)shell, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                try {
                    memento.apply();
                    ClipboardTest.fail();
                }
                catch (AssertionFailedException assertionFailedException) {
                    // empty catch block
                }
                ControlInfo control = (ControlInfo)memento.create((JavaInfo)shell);
                try {
                    memento.apply();
                    ClipboardTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                absoluteLayout.commandCreate(control, null);
                memento.apply();
                try {
                    memento.apply();
                    ClipboardTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                try {
                    memento.create((JavaInfo)shell);
                    ClipboardTest.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        });
    }

    private void layouts_doCopy(String[] sourceLines, String[] targetLines) throws Exception {
        CompositeInfo shell = this.parseComposite(sourceLines);
        final RowLayoutInfo rowLayout = (RowLayoutInfo)shell.getLayout();
        shell.refresh();
        ControlInfo control = (ControlInfo)shell.getChildrenControls().get(0);
        ClipboardTest.doCopyPaste(control, new AbstractJavaInfoTest.PasteProcedure<ControlInfo>(){

            @Override
            public void run(ControlInfo p) throws Exception {
                rowLayout.command_CREATE(p, null);
            }
        });
        this.assertEditor(targetLines);
    }

    @Test
    public void test_factoryStatic() throws Exception {
        ClipboardTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static Button createButton(Composite parent, String text) {", "    Button button = new Button(parent, SWT.NONE);", "    button.setText(text);", "    return button;", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = StaticFactory.createButton(this, \"button\");", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = StaticFactory.createButton(this, \"button\");", "    }", "    {", "      Button button = StaticFactory.createButton(this, \"button\");", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_viewer_1() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      TableViewer viewer = new TableViewer(this, SWT.BORDER);", "      viewer.setUseHashlookup(true);", "      viewer.getTable().setHeaderVisible(true);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      TableViewer viewer = new TableViewer(this, SWT.BORDER);", "      viewer.setUseHashlookup(true);", "      viewer.getTable().setHeaderVisible(true);", "    }", "    {", "      TableViewer viewer = new TableViewer(this, SWT.BORDER);", "      viewer.setUseHashlookup(true);", "      Table table = viewer.getTable();", "      table.setHeaderVisible(true);", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_exposedSubComponent() throws Exception {
        ClipboardTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "    m_button = new Button(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        ClipboardTest.waitForAutoBuild();
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "      myComposite.getButton().setText(\"button\");", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "      myComposite.getButton().setText(\"button\");", "    }", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "      myComposite.getButton().setText(\"button\");", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_viewer_2() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      table.setHeaderVisible(true);", "      TableViewer viewer = new TableViewer(table);", "      viewer.setUseHashlookup(true);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      table.setHeaderVisible(true);", "      TableViewer viewer = new TableViewer(table);", "      viewer.setUseHashlookup(true);", "    }", "    {", "      Table table = new Table(this, SWT.BORDER);", "      table.setHeaderVisible(true);", "      TableViewer viewer = new TableViewer(table);", "      viewer.setUseHashlookup(true);", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_Table() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"AAA\");", "      }", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"BBB\");", "      }", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"AAA\");", "      }", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"BBB\");", "      }", "    }", "    {", "      Table table = new Table(this, SWT.BORDER);", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"AAA\");", "      }", "      {", "        TableColumn tableColumn = new TableColumn(table, SWT.NONE);", "        tableColumn.setWidth(100);", "        tableColumn.setText(\"BBB\");", "      }", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_AbsoluteLayout_implicit() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_AbsoluteLayout_null() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(null);", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(null);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(null);", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_AbsoluteLayout_withComponent() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"button\");", "        button.setBounds(10, 20, 200, 100);", "      }", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"button\");", "        button.setBounds(10, 20, 200, 100);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"button\");", "        button.setBounds(10, 20, 200, 100);", "      }", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_FillLayout() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"second button\");", "      }", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"second button\");", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "        button.setText(\"second button\");", "      }", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_RowLayout() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new RowData(100, 200));", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "      {", "        Button button = new Button(composite, SWT.RADIO);", "        RowData rowData = new RowData();", "        rowData.width = 100;", "        button.setLayoutData(rowData);", "      }", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new RowData(100, 200));", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "      {", "        Button button = new Button(composite, SWT.RADIO);", "        RowData rowData = new RowData();", "        rowData.width = 100;", "        button.setLayoutData(rowData);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new RowData(100, 200));", "      }", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "      {", "        Button button = new Button(composite, SWT.RADIO);", "        button.setLayoutData(new RowData(100, SWT.DEFAULT));", "      }", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }

    @Test
    public void test_layouts_GridLayout() throws Exception {
        String[] sourceLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        GridData gridData = new GridData();", "        gridData.horizontalAlignment = GridData.FILL;", "        button.setLayoutData(gridData);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "  }", "}"};
        String[] targetLines = new String[]{"class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        GridData gridData = new GridData();", "        gridData.horizontalAlignment = GridData.FILL;", "        button.setLayoutData(gridData);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button = new Button(composite, SWT.CHECK);", "      }", "    }", "  }", "}"};
        this.layouts_doCopy(sourceLines, targetLines);
    }
}

