/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.model.property.editor.presentation.CFlatButton;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;

public class PresentationButton
extends Button {
    private final PropertyEditorPresentation m_presentation;

    public PresentationButton(PropertyEditorPresentation presentation, Image image) {
        this.m_presentation = presentation;
        if (this.useFlatButton()) {
            this.setContents((IFigure)new CFlatButton(this.getModel(), image));
            this.setBorder(null);
        } else {
            this.setContents((IFigure)new Label(image));
        }
    }

    protected void paintClientArea(Graphics graphics) {
        if (this.useFlatButton() && (this.getModel().isArmed() || this.getModel().isSelected())) {
            graphics.translate(-1, -1);
        }
        super.paintClientArea(graphics);
        if (this.useFlatButton() && (this.getModel().isArmed() || this.getModel().isSelected())) {
            graphics.translate(1, 1);
        }
    }

    private boolean useFlatButton() {
        return EnvironmentUtils.IS_MAC;
    }

    public final PropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }
}

