/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class BeanInfoTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_isContainer_true() throws Exception {
        this.prepareComponentFor_isContainer("Boolean.TRUE");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyComponent {", "  public Test() {", "  }", "}");
        BeanInfoTest.assertTrue((boolean)panel.hasLayout());
    }

    @Test
    public void test_isContainer_false() throws Exception {
        this.prepareComponentFor_isContainer("Boolean.FALSE");
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends MyComponent {", "  public Test() {", "  }", "}");
        BeanInfoTest.assertFalse((boolean)panel.hasLayout());
    }

    private void prepareComponentFor_isContainer(String value) throws Exception {
        BeanInfoTest.setFileContentSrc("test/MyComponent.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyComponent extends JPanel {", "}"));
        BeanInfoTest.setFileContentSrc("test/MyComponentBeanInfo.java", this.getTestSource("import java.beans.*;", "public class MyComponentBeanInfo extends SimpleBeanInfo {", "  public BeanDescriptor getBeanDescriptor() {", "    BeanDescriptor descriptor = new BeanDescriptor(MyComponent.class);", "    descriptor.setValue('isContainer', " + value + ");", "    return descriptor;", "  }", "}"));
        BeanInfoTest.waitForAutoBuild();
    }
}

