/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.MenuIntersector;
import org.eclipse.wb.internal.rcp.model.widgets.ScrolledCompositeInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.Expectations;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class SurroundSupportTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_emptySelection() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.refresh();
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)shell, Collections.emptyList());
    }

    @Test
    public void test_notControl() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        shell.refresh();
        LayoutInfo layout = shell.getLayout();
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)shell, List.of(layout));
    }

    @Test
    public void test_notSameParent() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 20, 100, 50);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)shell, List.of(shell, button));
    }

    @Test
    public void test_flow_singleControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout(SWT.HORIZONTAL));", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_flow_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new RowLayout(SWT.HORIZONTAL));", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_flow_notAdjacentControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_3 = (ControlInfo)shell.getChildrenControls().get(2);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)button_3, List.of(button_1, button_3));
    }

    @Test
    public void test_absolute_singleControl() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 20, 100, 50);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(10, 20, 100, 50);", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(0, 0, 100, 50);", "      }", "    }", "  }", "}");
    }

    @Disabled
    @Test
    public void test_absolute_singleControl_onGroup() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(10, 20, 100, 50);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        SurroundSupportTest.runSurround("org.eclipse.swt.widgets.Group", new ObjectInfo[]{button});
        String expected1 = Expectations.get("(7, 5, 106, 68)", new Expectations.StrValue("flanker-win", "(7, 7, 106, 66)"), new Expectations.StrValue("scheglov-win", "(7, 5, 106, 68)"));
        String expected2 = Expectations.get("(3, 15, 100, 50)", new Expectations.StrValue("flanker-win", "(3, 13, 100, 50)"), new Expectations.StrValue("scheglov-kwin", "(3, 15, 100, 50)"));
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Group group = new Group(this, SWT.NONE);", "      group.setBounds" + expected1 + ";", "      {", "        Button button = new Button(group, SWT.NONE);", "        button.setBounds" + expected2 + ";", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_absolute_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setBounds(150, 50, 100, 20);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(10, 10, 100, 20);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "      button_3.setBounds(160, 100, 110, 50);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_3 = (ControlInfo)shell.getChildrenControls().get(2);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_1, button_3});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(150, 50, 120, 100);", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "        button_1.setBounds(0, 0, 100, 20);", "      }", "      {", "        Button button_3 = new Button(composite, SWT.NONE);", "        button_3.setBounds(10, 50, 110, 50);", "      }", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "      button_2.setBounds(10, 10, 100, 20);", "    }", "  }", "}");
    }

    @Test
    public void test_SashForm_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        SurroundSupportTest.runSurround("org.eclipse.swt.custom.SashForm", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      SashForm sashForm = new SashForm(this, SWT.NONE);", "      {", "        Button button_1 = new Button(sashForm, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(sashForm, SWT.NONE);", "      }", "      sashForm.setWeights(new int[] {1, 1});", "    }", "  }", "}");
    }

    @Test
    public void test_TabFolder_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        SurroundSupportTest.runSurround("org.eclipse.swt.widgets.TabFolder", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      TabFolder tabFolder = new TabFolder(this, SWT.NONE);", "      {", "        TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button_1 = new Button(tabFolder, SWT.NONE);", "          tabItem.setControl(button_1);", "        }", "      }", "      {", "        TabItem tabItem = new TabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button_2 = new Button(tabFolder, SWT.NONE);", "          tabItem.setControl(button_2);", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_CTabFolder_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        SurroundSupportTest.runSurround("org.eclipse.swt.custom.CTabFolder", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      CTabFolder tabFolder = new CTabFolder(this, SWT.BORDER);", "      tabFolder.setSelectionBackground(Display.getCurrent().getSystemColor(SWT.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT));", "      {", "        CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button_1 = new Button(tabFolder, SWT.NONE);", "          tabItem.setControl(button_1);", "        }", "      }", "      {", "        CTabItem tabItem = new CTabItem(tabFolder, SWT.NONE);", "        tabItem.setText('New Item');", "        {", "          Button button_2 = new Button(tabFolder, SWT.NONE);", "          tabItem.setControl(button_2);", "        }", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_ScrolledComposite_oneComposite() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        SurroundSupportTest.runSurround("org.eclipse.swt.custom.ScrolledComposite", new ObjectInfo[]{composite});
        this.assertEditor("public class Test extends Shell {", "  private Composite composite;", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ScrolledComposite scrolledComposite = new ScrolledComposite(this, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);", "      scrolledComposite.setExpandHorizontal(true);", "      scrolledComposite.setExpandVertical(true);", "      {", "        composite = new Composite(scrolledComposite, SWT.NONE);", "      }", "      scrolledComposite.setContent(composite);", "      scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "    }", "  }", "}");
    }

    @Test
    public void test_ScrolledComposite_twoControls() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button_1 = (ControlInfo)shell.getChildrenControls().get(0);
        ControlInfo button_2 = (ControlInfo)shell.getChildrenControls().get(1);
        SurroundSupportTest.runSurround("org.eclipse.swt.custom.ScrolledComposite", new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  private Composite composite;", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      ScrolledComposite scrolledComposite = new ScrolledComposite(this, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);", "      scrolledComposite.setExpandHorizontal(true);", "      scrolledComposite.setExpandVertical(true);", "      {", "        composite = new Composite(scrolledComposite, SWT.NONE);", "        composite.setLayout(new RowLayout(SWT.HORIZONTAL));", "        {", "          Button button_1 = new Button(composite, SWT.NONE);", "        }", "        {", "          Button button_2 = new Button(composite, SWT.NONE);", "        }", "      }", "      scrolledComposite.setContent(composite);", "      scrolledComposite.setMinSize(composite.computeSize(SWT.DEFAULT, SWT.DEFAULT));", "    }", "  }", "}");
        ScrolledCompositeInfo scrolledComposite = (ScrolledCompositeInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite = (CompositeInfo)scrolledComposite.getContent();
        AbsoluteLayoutInfo absoluteLayout = AbsoluteLayoutInfo.createExplicit((CompositeInfo)composite);
        composite.setLayout((LayoutInfo)absoluteLayout);
        SurroundSupportTest.assertNoErrors((JavaInfo)shell);
    }

    @Test
    public void test_GridLayout_disableWhenExposed() throws Exception {
        SurroundSupportTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    button = new Button(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return button;", "  }", "}"));
        SurroundSupportTest.waitForAutoBuild();
        this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    }", "  }", "}");
        this.refresh();
        ControlInfo button = (ControlInfo)SurroundSupportTest.getJavaInfoByName("getButton()");
        SurroundSupportTest.assertNotNull((Object)button);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)button, List.of(button));
    }

    @Test
    public void test_GridLayout_0() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_BAD = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button_1 = buttons.get(0);
        ControlInfo button_2 = buttons.get(2);
        SurroundSupportTest.assertNoSurroundManager((ObjectInfo)shell, List.of(button_1, button_2));
    }

    @Test
    public void test_GridLayout_1() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button_1 = buttons.get(0);
        ControlInfo button_2 = buttons.get(1);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_GridLayout_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    new Label(this, SWT.NONE);", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button_1 = buttons.get(0);
        ControlInfo button_2 = buttons.get(1);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_1, button_2});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_GridLayout_3() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(2, false));", "    {", "      Button button_1 = new Button(this, SWT.NONE);", "      button_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));", "    }", "    {", "      Button button_2 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_3 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button_1 = buttons.get(0);
        ControlInfo button_2 = buttons.get(1);
        ControlInfo button_3 = buttons.get(2);
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_1, button_2, button_3});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button_1 = new Button(composite, SWT.NONE);", "        button_1.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));", "      }", "      {", "        Button button_2 = new Button(composite, SWT.NONE);", "      }", "      {", "        Button button_3 = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_GridLayout_4() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_00 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_10 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_20 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_01 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_11 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button_02 = new Button(this, SWT.NONE);", "    }", "    new Label(this, SWT.NONE);", "    {", "      Button button_22 = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button_11 = buttons.get(4);
        ControlInfo button_22 = buttons.get(6);
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button_11);
        SurroundSupportTest.assertEquals((int)1, (int)ReflectionUtils.getFieldInt((Object)gridData, (String)"x"));
        SurroundSupportTest.assertEquals((int)1, (int)ReflectionUtils.getFieldInt((Object)gridData, (String)"y"));
        gridData = GridLayoutInfo.getGridData((ControlInfo)button_22);
        SurroundSupportTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)gridData, (String)"x"));
        SurroundSupportTest.assertEquals((int)2, (int)ReflectionUtils.getFieldInt((Object)gridData, (String)"y"));
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button_11, button_22});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(3, false));", "    {", "      Button button_00 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_10 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_20 = new Button(this, SWT.NONE);", "    }", "    {", "      Button button_01 = new Button(this, SWT.NONE);", "    }", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 2));", "      composite.setLayout(new GridLayout(2, false));", "      {", "        Button button_11 = new Button(composite, SWT.NONE);", "      }", "      new Label(composite, SWT.NONE);", "      new Label(composite, SWT.NONE);", "      {", "        Button button_22 = new Button(composite, SWT.NONE);", "      }", "    }", "    {", "      Button button_02 = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_GridLayout_5() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new GridLayout(1, false));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setLayoutData(new GridData(150, 50));", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = SurroundSupportTest.getButtons(shell).get(0);
        AbsoluteLayoutInfo absoluteLayout = AbsoluteLayoutInfo.createExplicit((CompositeInfo)shell);
        shell.setLayout((LayoutInfo)absoluteLayout);
        shell.refresh();
        Rectangle bounds = button.getBounds();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setBounds(5, 5, " + bounds.width + ", " + bounds.height + ");", "    }", "  }", "}");
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setBounds(5, 5, " + bounds.width + ", " + bounds.height + ");", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setBounds(0, 0, " + bounds.width + ", " + bounds.height + ");", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_GridLayout_leadingImplicitControls() throws Exception {
        SurroundSupportTest.setFileContentSrc("test/MyShell.java", this.getTestSource("public class MyShell extends Shell {", "  public MyShell() {", "    setLayout(new GridLayout());", "    new Text(this, SWT.NONE);", "  }", "  protected void checkSubclass() {", "  }", "}"));
        SurroundSupportTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends MyShell {", "  public Test() {", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        GridLayoutInfo layout = (GridLayoutInfo)shell.getLayout();
        List<ControlInfo> buttons = SurroundSupportTest.getButtons(shell);
        ControlInfo button = buttons.get(0);
        IGridInfo gridInfo = layout.getGridInfo();
        SurroundSupportTest.assertEquals((int)1, (int)gridInfo.getColumnCount());
        SurroundSupportTest.assertEquals((int)2, (int)gridInfo.getRowCount());
        SurroundSupportTest.assertEquals((Object)new Rectangle(0, 1, 1, 1), (Object)gridInfo.getComponentCells((IAbstractComponentInfo)button));
        SurroundSupportTest.runSurround_Composite(new ObjectInfo[]{button});
        this.assertEditor("public class Test extends MyShell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 1, 1));", "      composite.setLayout(new GridLayout(1, false));", "      {", "        Button button = new Button(composite, SWT.NONE);", "      }", "    }", "  }", "}");
    }

    private static List<ControlInfo> getButtons(CompositeInfo parent) {
        ArrayList<ControlInfo> buttons = new ArrayList<ControlInfo>();
        for (ControlInfo control : parent.getChildrenControls()) {
            if (!control.getDescription().getComponentClass().getName().equals("org.eclipse.swt.widgets.Button")) continue;
            buttons.add(control);
        }
        return buttons;
    }

    private static IMenuManager createSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        MenuManager resultMenuManager;
        if (objects.size() < 2) {
            resultMenuManager = SurroundSupportTest.getDesignerMenuManager();
            object.getBroadcastObject().addContextMenu(objects, object, (IMenuManager)resultMenuManager);
        } else {
            resultMenuManager = new MenuManager();
            ArrayList<MenuManager> managers = new ArrayList<MenuManager>();
            for (ObjectInfo objectInfo : objects) {
                MenuManager manager = SurroundSupportTest.getDesignerMenuManager();
                object.getBroadcastObject().addContextMenu(objects, objectInfo, (IMenuManager)manager);
                managers.add(manager);
            }
            MenuIntersector.merge((IMenuManager)resultMenuManager, managers);
        }
        return SurroundSupportTest.findChildMenuManager((IContributionManager)resultMenuManager, "Surround with");
    }

    private static void assertNoSurroundManager(ObjectInfo object, List<? extends ObjectInfo> objects) throws Exception {
        IMenuManager surroundManager = SurroundSupportTest.createSurroundManager(object, objects);
        SurroundSupportTest.assertNull((Object)surroundManager);
    }

    private static void runSurround(String actionText, ObjectInfo ... objects) throws Exception {
        SurroundSupportTest.assertFalse((objects.length == 0 ? 1 : 0) != 0);
        IMenuManager surroundManager = SurroundSupportTest.createSurroundManager(objects[0], List.of(objects));
        SurroundSupportTest.assertNotNull((Object)surroundManager);
        IAction surroundAction = SurroundSupportTest.findChildAction((IContributionManager)surroundManager, actionText);
        SurroundSupportTest.assertNotNull((Object)surroundAction);
        surroundAction.run();
    }

    private static void runSurround_Composite(ObjectInfo ... objects) throws Exception {
        SurroundSupportTest.runSurround("org.eclipse.swt.widgets.Composite", objects);
    }
}

