/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.order.ComponentOrder;
import org.eclipse.wb.internal.core.model.order.ComponentOrderBeforeSibling;
import org.eclipse.wb.internal.core.model.order.ComponentOrderFirst;
import org.eclipse.wb.internal.core.model.order.ComponentOrderLast;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class ComponentOrderTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_parseBad() throws Exception {
        try {
            ComponentOrder.parse((String)"noSuchComponentOrder");
            ComponentOrderTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_default() throws Exception {
        ComponentOrder order = ComponentOrder.parse((String)"default");
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JCheckBox());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentInfo component = ComponentOrderTest.createJButton();
        ComponentOrderTest.assertSame(null, (Object)order.getNextComponent_whenLast((JavaInfo)component, (JavaInfo)container));
        ComponentInfo otherComponent = (ComponentInfo)container.getChildrenComponents().get(0);
        ComponentOrderTest.assertTrue((boolean)order.canBeBefore((JavaInfo)otherComponent));
    }

    @Test
    public void test_first() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    add(new JCheckBox());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/ /add(new JCheckBox())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}", "  {new: javax.swing.JCheckBox} {empty} {/add(new JCheckBox())/}");
        ComponentInfo component = this.create_firstComponent();
        ComponentOrder order = component.getDescription().getOrder();
        ComponentInfo firstChild = (ComponentInfo)container.getChildrenComponents().get(0);
        ComponentOrderTest.assertSame((Object)firstChild, (Object)order.getNextComponent_whenLast((JavaInfo)component, (JavaInfo)container));
        ComponentInfo otherComponent = (ComponentInfo)container.getChildrenComponents().get(0);
        ComponentOrderTest.assertTrue((boolean)order.canBeBefore((JavaInfo)otherComponent));
    }

    @Test
    public void test_first_add() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo component = this.create_firstComponent();
        ((FlowLayoutInfo)container.getLayout()).add(component, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "    }", "    add(new JButton());", "  }", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/ /add(myButton)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: myButton} {/new MyButton()/ /add(myButton)/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    @Test
    public void test_first_add_allImplicit() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "  }", "  // filler filler filler", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}");
        ComponentInfo component = this.create_firstComponent();
        ((FlowLayoutInfo)container.getLayout()).add(component, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "    }", "  }", "  // filler filler filler", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(myButton)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {local-unique: myButton} {/new MyButton()/ /add(myButton)/}");
    }

    private ComponentInfo create_firstComponent() throws Exception {
        ComponentOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  // filler filler filler", "}"));
        ComponentOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", ComponentOrderTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <order>first</order>", "</component>"));
        ComponentOrderTest.waitForAutoBuild();
        ComponentInfo component = ComponentOrderTest.createComponent("test.MyButton");
        ComponentOrderTest.assertSame((Object)ComponentOrderFirst.INSTANCE, (Object)component.getDescription().getOrder());
        return component;
    }

    @Test
    public void test_last() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentInfo component = this.create_lastComponent();
        ComponentOrder order = component.getDescription().getOrder();
        Object expectedNextComponent = null;
        ComponentOrderTest.assertSame(expectedNextComponent, (Object)order.getNextComponent_whenLast((JavaInfo)component, (JavaInfo)container));
        ComponentInfo otherComponent = (ComponentInfo)container.getChildrenComponents().get(0);
        ComponentOrderTest.assertFalse((boolean)order.canBeBefore((JavaInfo)otherComponent));
    }

    @Test
    public void test_last_addIt() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo component = this.create_lastComponent();
        ((FlowLayoutInfo)container.getLayout()).add(component, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "    }", "  }", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JButton())/ /add(myButton)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}", "  {new: test.MyButton} {local-unique: myButton} {/new MyButton()/ /add(myButton)/}");
    }

    @Test
    public void test_last_addOther() throws Exception {
        this.prepare_lastComponent();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new MyButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: test.MyButton} {empty} {/add(new MyButton())/}");
        container.refresh();
        ComponentInfo newButton = ComponentOrderTest.createJButton();
        ((FlowLayoutInfo)container.getLayout()).add(newButton, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    add(new MyButton());", "  }", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new MyButton())/ /add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton empty} {local-unique: button} {/new JButton()/ /add(button)/}", "  {new: test.MyButton} {empty} {/add(new MyButton())/}");
    }

    @Test
    public void test_last_reparentOther() throws Exception {
        this.prepare_lastComponent();
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "      {", "        JButton button = new JButton();", "        inner.add(button);", "      }", "    }", "    add(new MyButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(inner)/ /add(new MyButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPanel} {local-unique: inner} {/new JPanel()/ /add(inner)/ /inner.add(button)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "    {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /inner.add(button)/}", "  {new: test.MyButton} {empty} {/add(new MyButton())/}");
        container.refresh();
        ContainerInfo inner = (ContainerInfo)container.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        ((FlowLayoutInfo)container.getLayout()).move(button, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    {", "      JPanel inner = new JPanel();", "      add(inner);", "    }", "    {", "      JButton button = new JButton();", "      add(button);", "    }", "    add(new MyButton());", "  }", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(inner)/ /add(new MyButton())/ /add(button)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JPanel} {local-unique: inner} {/new JPanel()/ /add(inner)/}", "    {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JButton} {local-unique: button} {/new JButton()/ /add(button)/}", "  {new: test.MyButton} {empty} {/add(new MyButton())/}");
    }

    private ComponentInfo create_lastComponent() throws Exception {
        this.prepare_lastComponent();
        ComponentInfo component = ComponentOrderTest.createComponent("test.MyButton");
        ComponentOrderTest.assertSame((Object)ComponentOrderLast.INSTANCE, (Object)component.getDescription().getOrder());
        return component;
    }

    private void prepare_lastComponent() throws Exception {
        ComponentOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  // filler filler filler", "}"));
        ComponentOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", ComponentOrderTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <order>last</order>", "</component>"));
        ComponentOrderTest.waitForAutoBuild();
    }

    @Test
    public void test_beforeSibling() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JTextField());", "    add(new JButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JTextField())/ /add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JTextField} {empty} {/add(new JTextField())/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo component = this.create_beforeSibling();
        ComponentOrder order = component.getDescription().getOrder();
        ComponentInfo button = (ComponentInfo)container.getChildrenComponents().get(1);
        ComponentOrderTest.assertSame((Object)button, (Object)order.getNextComponent_whenLast((JavaInfo)component, (JavaInfo)container));
        ComponentInfo otherComponent = (ComponentInfo)container.getChildrenComponents().get(0);
        ComponentOrderTest.assertTrue((boolean)order.canBeBefore((JavaInfo)otherComponent));
    }

    @Test
    public void test_beforeSibling_noComponentForBefore() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JTextField());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JTextField())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JTextField} {empty} {/add(new JTextField())/}");
        ComponentInfo component = this.create_beforeSibling();
        ComponentOrder order = component.getDescription().getOrder();
        ComponentOrderTest.assertSame(null, (Object)order.getNextComponent_whenLast((JavaInfo)component, (JavaInfo)container));
    }

    @Test
    public void test_beforeSibling_add_it() throws Exception {
        String[] lines = new String[]{"public class Test extends JPanel {", "  public Test() {", "    add(new JTextField());", "    add(new JButton());", "  }", "}"};
        ContainerInfo container = this.parseContainer(lines);
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JTextField())/ /add(new JButton())/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JTextField} {empty} {/add(new JTextField())/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
        ComponentInfo component = this.create_beforeSibling();
        ((FlowLayoutInfo)container.getLayout()).add(component, null);
        this.assertEditor("public class Test extends JPanel {", "  public Test() {", "    add(new JTextField());", "    {", "      MyButton myButton = new MyButton();", "      add(myButton);", "    }", "    add(new JButton());", "  }", "}");
        ComponentOrderTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(new JTextField())/ /add(new JButton())/ /add(myButton)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JTextField} {empty} {/add(new JTextField())/}", "  {new: test.MyButton} {local-unique: myButton} {/new MyButton()/ /add(myButton)/}", "  {new: javax.swing.JButton} {empty} {/add(new JButton())/}");
    }

    private ComponentInfo create_beforeSibling() throws Exception {
        ComponentOrderTest.setFileContentSrc("test/MyButton.java", this.getTestSource("// filler filler filler filler filler", "// filler filler filler filler filler", "public class MyButton extends JButton {", "  // filler filler filler", "}"));
        ComponentOrderTest.setFileContentSrc("test/MyButton.wbp-component.xml", ComponentOrderTest.getSource("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <order>beforeSibling javax.swing.JButton</order>", "</component>"));
        ComponentOrderTest.waitForAutoBuild();
        ComponentInfo component = ComponentOrderTest.createComponent("test.MyButton");
        ComponentOrderTest.assertInstanceOf(ComponentOrderBeforeSibling.class, (Object)component.getDescription().getOrder());
        return component;
    }
}

