/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.primities;

import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class LongTest
extends AbstractEngineTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        LongTest.do_projectCreate();
    }

    @Test
    public void test_long_value1() throws Exception {
        this.check_long("1L", 1L);
    }

    @Test
    public void test_long_value2() throws Exception {
        this.check_long("2l", 2L);
    }

    @Test
    public void test_long_value_hex() throws Exception {
        this.check_long("0x0AL", 10L);
    }

    @Test
    public void test_long_value_oct() throws Exception {
        this.check_long("020L", 16L);
    }

    @Test
    public void test_long_positive_value() throws Exception {
        this.check_long("+3l", 3L);
    }

    @Test
    public void test_long_negative_value() throws Exception {
        this.check_long("-3l", -3L);
    }

    @Test
    public void test_long_plus() throws Exception {
        this.check_long("1L + 2L", 3L);
    }

    @Test
    public void test_long_plus3() throws Exception {
        this.check_long("1L + 2L + 3L", 6L);
    }

    @Test
    public void test_long_minus() throws Exception {
        this.check_long("5L - 1L", 4L);
    }

    @Test
    public void test_long_mul() throws Exception {
        this.check_long("2L * 3L", 6L);
    }

    @Test
    public void test_long_div() throws Exception {
        this.check_long("6L / 2L", 3L);
    }

    @Test
    public void test_long_div2() throws Exception {
        this.check_long("5L / 2L", 2L);
    }

    @Test
    public void test_long_mod() throws Exception {
        this.check_long("5L % 2L", 1L);
    }

    @Test
    public void test_long_mod2() throws Exception {
        this.check_long("-5L % 3L", -2L);
    }

    @Test
    public void test_long_or() throws Exception {
        this.check_long("1L | 2L", 3L);
    }

    @Test
    public void test_long_and() throws Exception {
        this.check_long("5L & 2L", 0L);
    }

    @Test
    public void test_long_mix_int() throws Exception {
        this.check_long("1L + 2", 3L);
    }

    @Test
    public void test_long_mix_char() throws Exception {
        this.check_long("1L + '0'", 49L);
    }

    @Test
    public void test_long_cast_to() throws Exception {
        this.check_long("((long)1) + 2", 3L);
    }

    private void check_long(String expression, long expected) throws Exception {
        LongTest.assertEquals((Object)expected, (Object)this.evaluateExpression(expression, "long"));
    }
}

